/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.AxisMap;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.IrregularGrid1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range1D;

public class IrregularAxisMap
extends AxisMap {
    private IrregularGrid1D preferedGrid;

    public IrregularAxisMap(IInterval1D data, IrregularGrid1D grid) {
        super(data);
        this.preferedGrid = grid;
        Range1D.Double range = grid.getRange1D();
        this.setFullViewRange(range);
        this.resetZoom();
    }

    @Override
    protected void calcGrid() {
        double zoomMin = this.realZoomRange.getXMin();
        double zoomMax = this.realZoomRange.getXMax();
        if (this.realZoomRange.equals(this.fullViewRange)) {
            this.resetZoom();
        } else if (this.preferedGrid.isAscending()) {
            double left = Math.floor(this.preferedGrid.coordinateAt(zoomMin));
            double right = Math.ceil(this.preferedGrid.coordinateAt(zoomMax));
            int n = (int)(right - left) + 1;
            if (n < 20 && n > 2) {
                double[] gridArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    gridArray[i] = this.preferedGrid.valueAt((int)left + i);
                }
                this.grid = new IrregularGrid1D(gridArray);
                this.realZoomRange.set(this.grid.getRange1D());
                this.gridZoomRange.set(this.grid.coordinateAt(zoomMin), this.grid.coordinateAt(zoomMax));
            } else {
                double gridStep = IrregularAxisMap.alignTickStep(this.realZoomRange.getXWidth() / 5.0);
                double gridStart = Math.floor(zoomMin / gridStep) * gridStep;
                double gridEnd = Math.ceil(zoomMax / gridStep) * gridStep;
                this.grid = new LinearGrid1D(gridStart, gridEnd, gridStep);
                this.gridZoomRange.set(this.grid.coordinateAt(zoomMin), this.grid.coordinateAt(zoomMax));
            }
        } else {
            double left = Math.floor(this.preferedGrid.coordinateAt(zoomMax));
            double right = Math.ceil(this.preferedGrid.coordinateAt(zoomMin));
            int n = (int)(right - left) + 1;
            if (n < 20 && n > 2) {
                double[] gridArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    gridArray[i] = this.preferedGrid.valueAt((int)left + i);
                }
                this.grid = new IrregularGrid1D(gridArray);
                this.realZoomRange.set(this.grid.getRange1D());
                this.gridZoomRange.set(this.grid.coordinateAt(zoomMin), this.grid.coordinateAt(zoomMax));
            } else {
                double gridStep = IrregularAxisMap.alignTickStep(this.realZoomRange.getXWidth() / 5.0);
                double gridStart = Math.floor(zoomMin / gridStep) * gridStep;
                double gridEnd = Math.ceil(zoomMax / gridStep) * gridStep;
                this.grid = new LinearGrid1D(gridEnd, gridStart, -gridStep);
                this.gridZoomRange.set(this.grid.coordinateAt(zoomMin), this.grid.coordinateAt(zoomMax));
            }
        }
    }

    @Override
    public void resetZoom() {
        if (this.preferedGrid != null) {
            this.realZoomRange.set(this.preferedGrid.getRange1D());
            this.grid = this.preferedGrid;
            this.gridZoomRange.set(this.grid.coordinateAt(this.realZoomRange.getXMin()), this.grid.coordinateAt(this.realZoomRange.getXMax()));
        }
    }
}

