/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Grid1D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class IrregularGrid1D
extends Grid1D {
    private static final long serialVersionUID = -3347468188186084124L;
    private double[] samples;
    private boolean ascending;
    private Range1D.Double range = new Range1D.Double();

    public IrregularGrid1D() {
        this.samples = new double[0];
    }

    public IrregularGrid1D(double[] samples) {
        this(samples, true);
    }

    IrregularGrid1D(double[] samples, Range1D range, boolean ascending) {
        super(samples.length);
        this.samples = (double[])samples.clone();
        this.range.set(range);
        this.ascending = ascending;
    }

    public IrregularGrid1D(double[] samples, boolean copy) {
        super(samples.length);
        this.setSamples(samples, copy);
    }

    public IrregularGrid1D(IOrderedArray1D samples) {
        this(samples.toArray(), false);
    }

    public IrregularGrid1D(IrregularGrid1D from, Range1D range) {
        int i;
        double r;
        double l;
        double gleft = from.coordinateAt(range.getXMinAsDouble());
        double gright = from.coordinateAt(range.getXMaxAsDouble());
        int length = 0;
        if (from.ascending) {
            l = Math.floor(gleft);
            r = Math.ceil(gright);
            length = (int)(r - l) + 1;
            this.samples = new double[length];
            for (i = 0; i < length; ++i) {
                this.samples[i] = from.valueAt((int)l + i);
            }
        } else {
            l = Math.floor(gright);
            r = Math.ceil(gleft);
            length = (int)(r - l) + 1;
            this.samples = new double[length];
            for (i = 0; i < length; ++i) {
                this.samples[i] = from.valueAt((int)l + i);
            }
        }
        this.setLength(length);
        if (length < 2) {
            throw new RuntimeException("samples do not form a valid grid");
        }
        this.range.set(this.samples[0], this.samples[0]);
        boolean bl = this.ascending = this.samples[length - 1] > this.samples[0];
        if (this.ascending) {
            for (int i2 = 1; i2 < length; ++i2) {
                if (this.samples[i2] < this.range.getXMin()) {
                    this.range.set(this.samples[i2], this.range.getXMax());
                }
                if (this.samples[i2] > this.range.getXMax()) {
                    this.range.set(this.range.getXMin(), this.samples[i2]);
                }
                if (!(this.samples[i2] <= this.samples[i2 - 1])) continue;
                throw new RuntimeException("samples do not form a valid grid");
            }
        } else {
            for (int i3 = 1; i3 < length; ++i3) {
                if (this.samples[i3] < this.range.getXMin()) {
                    this.range.set(this.samples[i3], this.range.getXMax());
                }
                if (this.samples[i3] > this.range.getXMax()) {
                    this.range.set(this.range.getXMin(), this.samples[i3]);
                }
                if (!(this.samples[i3] >= this.samples[i3 - 1])) continue;
                throw new RuntimeException("samples do not form a valid grid");
            }
        }
    }

    @Override
    public Object clone() {
        return new IrregularGrid1D(this.samples, this.range, this.ascending);
    }

    @Override
    public double coordinateAt(double x) {
        double grid;
        if (Double.isNaN(x)) {
            grid = Double.NaN;
        } else {
            int left = 0;
            int right = this.getLength() - 1;
            double sleft = this.samples[left];
            double sright = this.samples[right];
            if (this.ascending) {
                if (x < sleft) {
                    double grid2 = (double)left + (x - sleft) / (this.samples[left + 1] - sleft);
                    return grid2;
                }
                if (x > sright) {
                    double grid3 = (double)right + (x - sright) / (sright - this.samples[right - 1]);
                    return grid3;
                }
                while (right - left > 1) {
                    int mid = (right + left) / 2;
                    double sx = this.samples[mid];
                    if (x > sx) {
                        left = mid;
                        continue;
                    }
                    if (x < sx) {
                        right = mid;
                        continue;
                    }
                    left = mid;
                    break;
                }
                grid = (double)left + (x - this.samples[left]) / (this.samples[left + 1] - this.samples[left]);
            } else {
                if (x < sright) {
                    double grid4 = (double)right + (sright - x) / (this.samples[right - 1] - sright);
                    return grid4;
                }
                if (x > sleft) {
                    double grid5 = (double)left + (sleft - x) / (sleft - this.samples[left + 1]);
                    return grid5;
                }
                while (right - left > 1) {
                    int mid = (right + left) / 2;
                    double sx = this.samples[mid];
                    if (x < sx) {
                        left = mid;
                        continue;
                    }
                    if (x > sx) {
                        right = mid;
                        continue;
                    }
                    left = mid;
                    break;
                }
                grid = (double)left + (this.samples[left] - x) / (this.samples[left] - this.samples[left + 1]);
            }
        }
        return grid;
    }

    @Override
    public double[] coordinatesAt(double[] value) {
        int n = value.length;
        double[] grid = new double[n];
        for (int i = 0; i < n; ++i) {
            double sx;
            int mid;
            double x = value[i];
            if (Double.isNaN(x)) {
                grid[i] = Double.NaN;
                continue;
            }
            int left = 0;
            int right = this.getLength() - 1;
            double sleft = this.samples[left];
            double sright = this.samples[right];
            if (this.ascending) {
                if (x < sleft) {
                    grid[i] = (double)left + (x - sleft) / (this.samples[left + 1] - sleft);
                    continue;
                }
                if (x > sright) {
                    grid[i] = (double)right + (x - sright) / (sright - this.samples[right - 1]);
                    continue;
                }
                while (right - left > 1) {
                    mid = (right + left) / 2;
                    sx = this.samples[mid];
                    if (x > sx) {
                        left = mid;
                        continue;
                    }
                    if (x < sx) {
                        right = mid;
                        continue;
                    }
                    left = mid;
                    break;
                }
                grid[i] = (double)left + (x - this.samples[left]) / (this.samples[left + 1] - this.samples[left]);
                continue;
            }
            if (x < sright) {
                grid[i] = (double)right + (sright - x) / (this.samples[right - 1] - sright);
                continue;
            }
            if (x > sleft) {
                grid[i] = (double)left + (sleft - x) / (sleft - this.samples[left + 1]);
                continue;
            }
            while (right - left > 1) {
                mid = (right + left) / 2;
                sx = this.samples[mid];
                if (x < sx) {
                    left = mid;
                    continue;
                }
                if (x > sx) {
                    right = mid;
                    continue;
                }
                left = mid;
                break;
            }
            grid[i] = (double)left + (this.samples[left] - x) / (this.samples[left] - this.samples[left + 1]);
        }
        return grid;
    }

    @Override
    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Range.Double getRange() {
        return (Range.Double)this.range.clone();
    }

    @Override
    public Range1D.Double getRange1D() {
        return (Range1D.Double)this.range.clone();
    }

    public double[] getSamples() {
        return this.samples;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public double pointAt(int index) {
        int length = this.getLength();
        if (index >= 0 && index < length) {
            return this.samples[index];
        }
        if (index < 0) {
            return this.samples[0] + (double)index * (this.samples[1] - this.samples[0]);
        }
        return this.samples[length - 1] + (double)(index - length + 1) * (this.samples[length - 1] - this.samples[length - 2]);
    }

    @Override
    public void scale(double amount) {
        int i = 0;
        while (i < this.samples.length) {
            int n = i++;
            this.samples[n] = this.samples[n] * amount;
        }
        this.range = new Range1D.Double(this.range.getXMin() * amount, this.range.getXMax() * amount);
        if (amount < 0.0) {
            this.ascending = !this.ascending;
        }
    }

    public void setSamples(double[] newSamples) {
        this.setSamples(newSamples, true);
    }

    public void setSamples(double[] newSamples, boolean copy) {
        this.samples = newSamples;
        this.samples = copy ? (double[])newSamples.clone() : newSamples;
        this.range.set(this.samples[0], this.samples[0]);
        int length = this.getLength();
        boolean bl = this.ascending = this.samples[length - 1] > this.samples[0];
        if (this.ascending) {
            for (int i = 1; i < length; ++i) {
                if (this.samples[i] < this.range.getXMin()) {
                    this.range.set(this.samples[i], this.range.getXMax());
                }
                if (this.samples[i] > this.range.getXMax()) {
                    this.range.set(this.range.getXMin(), this.samples[i]);
                }
                if (!(this.samples[i] <= this.samples[i - 1])) continue;
                throw new RuntimeException("samples do not form a valid grid");
            }
        } else {
            for (int i = 1; i < length; ++i) {
                if (this.samples[i] < this.range.getXMin()) {
                    this.range.set(this.samples[i], this.range.getXMax());
                }
                if (this.samples[i] > this.range.getXMax()) {
                    this.range.set(this.range.getXMin(), this.samples[i]);
                }
                if (!(this.samples[i] >= this.samples[i - 1])) continue;
                throw new RuntimeException("samples do not form a valid grid");
            }
        }
    }

    @Override
    public double[] toArray() {
        double[] a = new double[this.samples.length];
        System.arraycopy(this.samples, 0, a, 0, this.samples.length);
        return a;
    }

    @Override
    public void translate(double amount) {
        int i = 0;
        while (i < this.samples.length) {
            int n = i++;
            this.samples[n] = this.samples[n] + amount;
        }
        this.range.translate(amount);
    }

    @Override
    public double valueAt(double gx) {
        double value;
        int length = this.getLength();
        if (gx < 0.0) {
            double dx = this.samples[1] - this.samples[0];
            value = this.samples[0] + dx * gx;
        } else if (gx > (double)(length - 1)) {
            double dx = this.samples[length - 1] - this.samples[length - 2];
            value = this.samples[length - 1] + dx * (gx - (double)length + 1.0);
        } else {
            int gx0 = (int)Math.floor(gx + 0.5);
            if (gx0 < 0) {
                gx0 = 0;
            }
            if (gx0 > length - 2) {
                gx0 = length - 2;
            }
            double dx = gx - (double)gx0;
            value = (1.0 - dx) * this.samples[gx0] + dx * this.samples[gx0 + 1];
        }
        return value;
    }

    @Override
    public double[] valuesAt(double[] grid) {
        int n = grid.length;
        double[] value = new double[n];
        int length = this.getLength();
        for (int i = 0; i < n; ++i) {
            double gx = grid[i];
            if (gx < 0.0) {
                double dx = this.samples[1] - this.samples[0];
                value[i] = this.samples[0] + dx * gx;
                continue;
            }
            if (gx > (double)(length - 1)) {
                double dx = this.samples[length - 1] - this.samples[length - 2];
                value[i] = this.samples[length - 1] + dx * (gx - (double)length + 1.0);
                continue;
            }
            int gx0 = (int)Math.floor(gx + 0.5);
            if (gx0 < 0) {
                gx0 = 0;
            }
            if (gx0 > length - 2) {
                gx0 = length - 2;
            }
            double dx = gx - (double)gx0;
            value[i] = (1.0 - dx) * this.samples[gx0] + dx * this.samples[gx0 + 1];
        }
        return value;
    }
}

