/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.AxisMap;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range1D;

public class LinearAxisMap
extends AxisMap {
    public LinearAxisMap(IInterval1D data) {
        super(data);
    }

    public LinearAxisMap(IInterval1D data, Range1D fullViewRange) {
        super(data);
        this.setFullViewRange(fullViewRange);
    }

    @Override
    protected void calcGrid() {
        double gridStep = LinearAxisMap.alignTickStep(this.realZoomRange.getXWidth() / 5.0);
        double gridStart = Math.floor(this.realZoomRange.getXMin() / gridStep) * gridStep;
        double gridEnd = Math.ceil(this.realZoomRange.getXMax() / gridStep) * gridStep;
        this.grid = new LinearGrid1D(gridStart, gridEnd, gridStep);
        this.gridZoomRange.set(this.grid.coordinateAt(this.realZoomRange.getXMin()), this.grid.coordinateAt(this.realZoomRange.getXMax()));
    }

    @Override
    public Grid1D map(Grid1D grid) {
        if (grid instanceof LinearGrid1D) {
            return new LinearGrid1D(this.map(((LinearGrid1D)grid).getStart()), this.map(((LinearGrid1D)grid).getEnd()), grid.getLength());
        }
        return super.map(grid);
    }

    @Override
    public Grid1D reverseMap(Grid1D grid) {
        if (grid instanceof LinearGrid1D) {
            return new LinearGrid1D(this.reverseMap(((LinearGrid1D)grid).getStart()), this.reverseMap(((LinearGrid1D)grid).getEnd()), grid.getLength());
        }
        return super.reverseMap(grid);
    }
}

