/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class LinearGrid1D
extends Grid1D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6900058303852024997L;
    private double start;
    private double end;
    private double step;
    private double istep;

    public LinearGrid1D() {
        super(0);
        this.start = Double.NaN;
        this.end = Double.NaN;
        this.step = 0.0;
        this.istep = 0.0;
    }

    public LinearGrid1D(double start, double end, double step) {
        super(0);
        if (end > start && step <= 0.0 || start > end && step >= 0.0) {
            throw new IllegalArgumentException("illegal linear grid");
        }
        int length = (int)Math.ceil((end - start) / step) + 1;
        this.setLength(length);
        this.start = start;
        this.end = start + (double)(length - 1) * step;
        this.step = step;
        this.istep = 1.0 / step;
    }

    public LinearGrid1D(double start, double end, int length) {
        super(length);
        if (length < 2) {
            throw new IllegalArgumentException("grid length lesser than 2");
        }
        this.start = start;
        this.end = end;
        this.step = (end - start) / (double)(length - 1);
        this.istep = 1.0 / this.step;
    }

    public LinearGrid1D(Range1D range, int length) {
        super(length);
        if (length < 2) {
            throw new IllegalArgumentException("grid length lesser than 2");
        }
        this.start = range.getXMinAsDouble();
        this.end = range.getXMaxAsDouble();
        this.step = (this.end - this.start) / (double)(length - 1);
        this.istep = 1.0 / this.step;
    }

    @Override
    public Object clone() {
        LinearGrid1D grid = null;
        grid = (LinearGrid1D)super.clone();
        return grid;
    }

    @Override
    public double coordinateAt(double x) {
        double grid = (x - this.start) * this.istep;
        return grid;
    }

    @Override
    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public double getEnd() {
        return this.end;
    }

    @Override
    public Range.Double getRange() {
        return new Range1D.Double(this.start, this.end);
    }

    @Override
    public Range1D.Double getRange1D() {
        return new Range1D.Double(this.start, this.end);
    }

    public double getStart() {
        return this.start;
    }

    public double getStep() {
        return this.step;
    }

    @Override
    public boolean isAscending() {
        return this.step > 0.0;
    }

    @Override
    public double pointAt(int index) {
        return this.start + (double)index * this.step;
    }

    @Override
    public void scale(double amount) {
        this.start *= amount;
        this.end *= amount;
        this.step *= amount;
        this.istep = 1.0 / this.step;
    }

    @Override
    public double[] toArray() {
        int n = this.getLength();
        double[] a = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = this.start + (double)i * this.step;
        }
        return a;
    }

    @Override
    public void translate(double amount) {
        this.start += amount;
        this.end += amount;
    }

    @Override
    public double valueAt(double g) {
        double l = -0.5;
        double r = (double)this.getLength() - 0.5;
        double value = l < g && g < r ? this.start + g * this.step : Double.NaN;
        return value;
    }
}

