/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import org.jcamp.math.Grid1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.RectangularGrid2D;

public class LinearGrid2D
extends RectangularGrid2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4627615487641799717L;

    public LinearGrid2D() {
    }

    public LinearGrid2D(double startX, double endX, double stepX, double startY, double endY, double stepY) {
        super(new LinearGrid1D(startX, endX, stepX), new LinearGrid1D(startY, endY, stepY));
    }

    public LinearGrid2D(double startX, double endX, int lengthX, double startY, double endY, int lengthY) {
        super(new LinearGrid1D(startX, endX, lengthX), new LinearGrid1D(startY, endY, lengthY));
    }

    public LinearGrid2D(LinearGrid1D xgrid, LinearGrid1D ygrid) {
        super(xgrid, ygrid);
    }

    @Override
    public Object clone() {
        LinearGrid2D grid = null;
        grid = (LinearGrid2D)super.clone();
        return grid;
    }

    public double getXEnd() {
        return ((LinearGrid1D)this.getXGrid()).getEnd();
    }

    public double getXStart() {
        return ((LinearGrid1D)this.getXGrid()).getStart();
    }

    public double getXStep() {
        return ((LinearGrid1D)this.getXGrid()).getStep();
    }

    public double getYEnd() {
        return ((LinearGrid1D)this.getYGrid()).getEnd();
    }

    public double getYStart() {
        return ((LinearGrid1D)this.getYGrid()).getStart();
    }

    public double getYStep() {
        return ((LinearGrid1D)this.getYGrid()).getStep();
    }

    public double[] interpolate(RectangularGrid2D dataGrid, double[] data) {
        Grid1D x = dataGrid.getXGrid();
        Grid1D y = dataGrid.getYGrid();
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        double[] interpolated = new double[this.getLength()];
        for (int index = 0; index < this.getLength(); ++index) {
            double z;
            int gy0;
            double[] xy = this.gridPointAt(index);
            double gx = x.coordinateAt(xy[0]);
            double gy = y.coordinateAt(xy[1]);
            if (gx < -0.5 || gx > (double)lengthX - 0.5 || gy < -0.5 || gy > (double)lengthY - 0.5) {
                interpolated[index] = Double.NaN;
                continue;
            }
            int gx0 = (int)Math.floor(gx + 0.5);
            if (gx0 < 0) {
                gx0 = 0;
            }
            if (gx0 > lengthX - 2) {
                gx0 = lengthX - 2;
            }
            if ((gy0 = (int)Math.floor(gy + 0.5)) < 0) {
                gy0 = 0;
            }
            if (gy0 > lengthY - 2) {
                gy0 = lengthY - 2;
            }
            int lb = gy0 * lengthX + gx0;
            int rb = gy0 * lengthX + gx0 + 1;
            int lt = (gy0 + 1) * lengthX + gx0;
            int rt = (gy0 + 1) * lengthX + gx0 + 1;
            double dx = Math.max(0.0, Math.min(1.0, gx - (double)gx0));
            double dy = Math.max(0.0, Math.min(1.0, gy - (double)gy0));
            double zlb = data[lb];
            double zrb = data[rb];
            double zlt = data[lt];
            double zrt = data[rt];
            if (dx + dy - 1.0 < 0.0) {
                z = zlb + dx * (zrb - zlb) + dy * (zlt - zlb);
            } else {
                dx = 1.0 - dx;
                dy = 1.0 - dy;
                z = zrt + dx * (zlt - zrt) + dy * (zrb - zrt);
            }
            interpolated[index] = z;
        }
        return interpolated;
    }
}

