/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Range;

public abstract class Range1D
extends Range {
    private static final long serialVersionUID = -1174175881057971793L;

    protected Range1D() {
        super(1);
    }

    public boolean contains(double v) {
        return v >= this.getXMinAsDouble() && v <= this.getXMaxAsDouble();
    }

    public boolean contains(Range1D r) {
        return r.getXMinAsDouble() >= this.getXMinAsDouble() && r.getXMaxAsDouble() <= this.getXMaxAsDouble();
    }

    public abstract double getXMaxAsDouble();

    public abstract double getXMinAsDouble();

    public static class Float
    extends Range1D
    implements Range.Float,
    Cloneable {
        private static final long serialVersionUID = -4164264992802959334L;
        private float xmin;
        private float xmax;

        public Float() {
            this.xmin = java.lang.Float.NaN;
            this.xmax = java.lang.Float.NaN;
        }

        public Float(Range1D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
        }

        public Float(Float r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
        }

        public Float(float x0, float x1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
        }

        public boolean contains(float v) {
            return v >= this.xmin && v <= this.xmax;
        }

        public Float clip(float x0, float x1) {
            Float nr = new Float(x0, x1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            return nr;
        }

        public Float clip(Range1D r) {
            return this.clip((float)r.getXMinAsDouble(), (float)r.getXMinAsDouble());
        }

        public Object clone() {
            Float range = null;
            try {
                range = (Float)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range1D r;
            return obj instanceof Range1D && (this == (r = (Range1D)obj) || Math.abs(r.getXMinAsDouble() - (double)this.xmin) < (double)2.8E-45f && Math.abs(r.getXMaxAsDouble() - (double)this.xmax) < (double)2.8E-45f);
        }

        public boolean equals(Float r) {
            return this == r || (double)Math.abs(r.xmin - this.xmin) < (double)2.8E-45f && (double)Math.abs(r.xmax - this.xmax) < (double)2.8E-45f;
        }

        public void extend(float amount) {
            this.xmin -= amount;
            this.xmax += amount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public float getMax(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax;
        }

        @Override
        public float getCenter(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.5f * (this.xmax + this.xmin);
        }

        @Override
        public Float getRange(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return (Float)this.clone();
        }

        @Override
        public float getMin(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmin;
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public float getWidth(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax - this.xmin;
        }

        public float getXMax() {
            return this.xmax;
        }

        public float getXMin() {
            return this.xmin;
        }

        public Float getXRange() {
            return (Float)this.clone();
        }

        public float getXWidth() {
            return this.xmax - this.xmin;
        }

        public float getXCenter() {
            return 0.5f * (this.xmax + this.xmin);
        }

        public Float include(float value) {
            if (value < this.xmin) {
                this.xmin = value;
            }
            if (value > this.xmax) {
                this.xmax = value;
            }
            return this;
        }

        public Float include(float xmin, float xmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            return this;
        }

        public Float include(Range1D range) {
            return this.include((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax;
        }

        public void set(float x0, float x1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
        }

        public void set(Range1D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
        }

        public void setCenterAndWidth(float center, float width) {
            this.xmin = center - 0.5f * width;
            this.xmax = center + 0.5f * width;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "]";
        }

        public void translate(float amount) {
            this.xmin += amount;
            this.xmax += amount;
        }

        public Float union(float value) {
            Float range = (Float)this.clone();
            if (value < range.xmin) {
                range.xmin = value;
            }
            if (value > range.xmax) {
                range.xmax = value;
            }
            return range;
        }

        public Float union(float xmin, float xmax) {
            Float range = (Float)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            return range;
        }

        public Float union(Range1D range) {
            return this.union((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble());
        }
    }

    public static class Double
    extends Range1D
    implements Range.Double,
    Cloneable {
        private static final long serialVersionUID = -6191572071758320201L;
        private double xmin;
        private double xmax;

        public Double() {
            this.xmin = java.lang.Double.NaN;
            this.xmax = java.lang.Double.NaN;
        }

        public Double(Range1D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
        }

        public Double(double x0, double x1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
        }

        public Double clip(double x0, double x1) {
            Double nr = new Double(x0, x1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            return nr;
        }

        public Double clip(Range1D r) {
            Double nr = new Double(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            return nr;
        }

        public Object clone() {
            Double range = null;
            try {
                range = (Double)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range1D r;
            return obj instanceof Range1D && (this == (r = (Range1D)obj) || Math.abs(r.getXMinAsDouble() - this.xmin) < 9.9E-324 && Math.abs(r.getXMaxAsDouble() - this.xmax) < 9.9E-324);
        }

        public void extend(double amount) {
            this.xmin -= amount;
            this.xmax += amount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getCenter(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.5 * (this.xmax + this.xmin);
        }

        @Override
        public Double getRange(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return (Double)this.clone();
        }

        @Override
        public double getMax(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax;
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getWidth(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax - this.xmin;
        }

        @Override
        public double getMin(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmin;
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getXMin() {
            return this.xmin;
        }

        public Double getXRange() {
            return (Double)this.clone();
        }

        public double getXWidth() {
            return this.xmax - this.xmin;
        }

        public double getXCenter() {
            return 0.5 * (this.xmax + this.xmin);
        }

        public Double include(double value) {
            if (value < this.xmin) {
                this.xmin = value;
            }
            if (value > this.xmax) {
                this.xmax = value;
            }
            return this;
        }

        public Double include(double xmin, double xmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            return this;
        }

        public Double include(Range1D range) {
            return this.include(range.getXMinAsDouble(), range.getXMaxAsDouble());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax;
        }

        public void set(double x0, double x1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
        }

        public void set(Range1D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
        }

        public void setCenterAndWidth(double center, double width) {
            this.xmin = center - 0.5 * width;
            this.xmax = center + 0.5 * width;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "]";
        }

        public void translate(double amount) {
            this.xmin += amount;
            this.xmax += amount;
        }

        public Double union(double value) {
            Double range = (Double)this.clone();
            if (value < range.xmin) {
                range.xmin = value;
            }
            if (value > range.xmax) {
                range.xmax = value;
            }
            return range;
        }

        public Double union(double xmin, double xmax) {
            Double range = (Double)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            return range;
        }

        public Double union(Range1D range) {
            return this.union(range.getXMinAsDouble(), range.getXMaxAsDouble());
        }
    }

    public static class Int
    extends Range1D
    implements Range.Int {
        private static final long serialVersionUID = -5096845094034133121L;
        private int xmin;
        private int xmax;

        public Int() {
            this.xmin = 0;
            this.xmax = 0;
        }

        public Int(Int r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
        }

        public Int(int l, int r) {
            if (l < r) {
                this.xmin = l;
                this.xmax = r;
            } else {
                this.xmin = r;
                this.xmax = l;
            }
        }

        public boolean contains(int v) {
            return v >= this.xmin && v <= this.xmax;
        }

        public Int clip(int x0, int x1) {
            Int nr = new Int(x0, x1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            return nr;
        }

        public Int clip(Int r) {
            Int nr = new Int(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            return nr;
        }

        public Object clone() {
            Int range = null;
            try {
                range = (Int)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Int r;
            return obj instanceof Int && (this == (r = (Int)obj) || r.xmin == this.xmin && r.xmax == this.xmax);
        }

        public void extend(int amount) {
            this.xmin -= amount;
            this.xmax += amount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public int getCenter(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return (this.xmax + this.xmin) / 2;
        }

        @Override
        public Int getRange(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return (Int)this.clone();
        }

        @Override
        public int getMax(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax;
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public int getWidth(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmax - this.xmin;
        }

        @Override
        public int getMin(int dim) {
            if (dim != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.xmin;
        }

        public int getXMax() {
            return this.xmax;
        }

        public int getXMin() {
            return this.xmin;
        }

        public Int getXRange() {
            return (Int)this.clone();
        }

        public int getXWidth() {
            return this.xmax - this.xmin;
        }

        public int getXCenter() {
            return (this.xmax + this.xmin) / 2;
        }

        public Int include(int value) {
            if (value < this.xmin) {
                this.xmin = value;
            }
            if (value > this.xmax) {
                this.xmax = value;
            }
            return this;
        }

        public Int include(int xmin, int xmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            return this;
        }

        public Int include(Int range) {
            return this.include(range.getXMin(), range.getXMax());
        }

        public void set(int l, int r) {
            if (l < r) {
                this.xmin = l;
                this.xmax = r;
            } else {
                this.xmin = r;
                this.xmax = l;
            }
        }

        public void set(Int r) {
            this.xmin = r.getXMin();
            this.xmax = r.getXMax();
        }

        public void setCenterAndWidth(int center, int width) {
            this.xmin = center - width / 2;
            this.xmax = center + width / 2;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "]";
        }

        public void translate(int amount) {
            this.xmin += amount;
            this.xmax += amount;
        }

        public Int union(int value) {
            Int range = (Int)this.clone();
            if (value < range.xmin) {
                range.xmin = value;
            }
            if (value > range.xmax) {
                range.xmax = value;
            }
            return range;
        }

        public Int union(int xmin, int xmax) {
            Int range = (Int)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            return range;
        }

        public Int union(Int range) {
            return this.union(range.getXMin(), range.getXMax());
        }
    }
}

