/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Point2D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public abstract class Range2D
extends Range {
    private static final long serialVersionUID = 2927117694454510932L;

    protected Range2D() {
        super(2);
    }

    public boolean contains(Range2D r) {
        return r.getXMinAsDouble() >= this.getXMinAsDouble() && r.getXMaxAsDouble() <= this.getXMaxAsDouble() && r.getYMinAsDouble() >= this.getYMinAsDouble() && r.getYMaxAsDouble() <= this.getYMaxAsDouble();
    }

    public boolean contains(Point2D p) {
        return p.x >= this.getXMinAsDouble() && p.x <= this.getXMaxAsDouble() && p.y >= this.getYMinAsDouble() && p.y <= this.getYMaxAsDouble();
    }

    public abstract double getXMaxAsDouble();

    public abstract double getXMinAsDouble();

    public abstract double getYMaxAsDouble();

    public abstract double getYMinAsDouble();

    public static class Float
    extends Range2D
    implements Range.Float,
    Cloneable {
        private static final long serialVersionUID = 7906304104729707229L;
        private float xmin;
        private float xmax;
        private float ymin;
        private float ymax;

        public Float() {
            this.xmin = java.lang.Float.NaN;
            this.xmax = java.lang.Float.NaN;
            this.ymin = java.lang.Float.NaN;
            this.ymax = java.lang.Float.NaN;
        }

        public Float(Range2D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
            this.ymin = (float)r.getYMinAsDouble();
            this.ymax = (float)r.getYMaxAsDouble();
        }

        public Float(Range1D xrange, Range1D yrange) {
            this((float)xrange.getXMinAsDouble(), (float)xrange.getXMaxAsDouble(), (float)yrange.getXMinAsDouble(), (float)yrange.getXMaxAsDouble());
        }

        public void set(Range1D xrange, Range1D yrange) {
            this.set((float)xrange.getXMinAsDouble(), (float)xrange.getXMaxAsDouble(), (float)yrange.getXMinAsDouble(), (float)yrange.getXMaxAsDouble());
        }

        public Float(Range1D.Float xrange, Range1D.Float yrange) {
            this(xrange.getXMin(), xrange.getXMax(), yrange.getXMin(), yrange.getXMax());
        }

        public void set(Range1D.Float xrange, Range1D.Float yrange) {
            this.set(xrange.getXMin(), xrange.getXMax(), yrange.getXMin(), yrange.getXMax());
        }

        public Float(Float r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
            this.ymin = r.ymin;
            this.ymax = r.ymax;
        }

        public Float(float x0, float x1, float y0, float y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public Float clip(float x0, float x1, float y0, float y1) {
            Float nr = new Float(x0, x1, y0, y1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Float clip(Range2D r) {
            Float nr = new Float(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Object clone() {
            Float range = null;
            try {
                range = (Float)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range2D r;
            return obj instanceof Range2D && (this == (r = (Range2D)obj) || Math.abs(r.getXMinAsDouble() - (double)this.xmin) < (double)2.8E-45f && Math.abs(r.getXMaxAsDouble() - (double)this.xmax) < (double)2.8E-45f && Math.abs(r.getYMinAsDouble() - (double)this.ymin) < (double)2.8E-45f && Math.abs(r.getYMaxAsDouble() - (double)this.ymax) < (double)2.8E-45f);
        }

        public boolean equals(Float r) {
            return this == r || (double)Math.abs(r.xmin - this.xmin) < (double)2.8E-45f && (double)Math.abs(r.xmax - this.xmax) < (double)2.8E-45f && (double)Math.abs(r.ymin - this.ymin) < (double)2.8E-45f && (double)Math.abs(r.ymax - this.ymax) < (double)2.8E-45f;
        }

        public void extend(float xamount, float yamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public float getCenter(int dim) {
            if (dim == 0) {
                return 0.5f * (this.xmax + this.xmin);
            }
            if (dim == 1) {
                return 0.5f * (this.ymax + this.ymin);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Float getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Float(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Float(this.ymin, this.ymax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public float getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public float getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public float getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        public float getXMax() {
            return this.xmax;
        }

        public float getYMax() {
            return this.ymax;
        }

        public float getXMin() {
            return this.xmin;
        }

        public Range1D.Float getXRange() {
            return new Range1D.Float(this.xmin, this.xmax);
        }

        public Range1D.Float getYRange() {
            return new Range1D.Float(this.ymin, this.ymax);
        }

        public float getYMin() {
            return this.ymin;
        }

        public float getXWidth() {
            return this.xmax - this.xmin;
        }

        public float getXCenter() {
            return 0.5f * (this.xmax + this.xmin);
        }

        public float getYCenter() {
            return 0.5f * (this.ymax + this.ymin);
        }

        public float getYWidth() {
            return this.ymax - this.ymin;
        }

        public Float include(float x, float y) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            return this;
        }

        public Float include(Range2D range) {
            return this.include((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble(), (float)range.getYMinAsDouble(), (float)range.getYMaxAsDouble());
        }

        public Float include(Float range) {
            return this.include(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax && this.ymin == this.ymin && this.ymax == this.ymax;
        }

        public void set(float x0, float x1, float y0, float y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public void set(Range2D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
            this.ymin = (float)r.getYMinAsDouble();
            this.ymax = (float)r.getYMaxAsDouble();
        }

        public void set(Float r) {
            this.xmin = r.getXMin();
            this.xmax = r.getXMax();
            this.ymin = r.getYMin();
            this.ymax = r.getYMax();
        }

        public void setCenterAndWidth(float xcenter, float xwidth, float ycenter, float ywidth) {
            this.xmin = xcenter - 0.5f * xwidth;
            this.xmax = xcenter + 0.5f * xwidth;
            this.ymin = ycenter - 0.5f * ywidth;
            this.ymax = ycenter + 0.5f * ywidth;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "],[" + this.ymin + "," + this.ymax + "]";
        }

        public void translate(float xamount, float yamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
        }

        public Float union(float xvalue, float yvalue) {
            Float range = (Float)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            return range;
        }

        public Float union(float xmin, float xmax, float ymin, float ymax) {
            Float range = (Float)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            return range;
        }

        public Float include(float xmin, float xmax, float ymin, float ymax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            return this;
        }

        public Float union(Range2D range) {
            return this.union((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble(), (float)range.getYMinAsDouble(), (float)range.getYMaxAsDouble());
        }

        public Float union(Float range) {
            return this.union(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax());
        }
    }

    public static class Double
    extends Range2D
    implements Range.Double,
    Cloneable {
        private static final long serialVersionUID = 3369803771308467437L;
        private double xmin;
        private double xmax;
        private double ymin;
        private double ymax;

        public Double() {
            this.xmin = java.lang.Double.NaN;
            this.xmax = java.lang.Double.NaN;
            this.ymin = java.lang.Double.NaN;
            this.ymax = java.lang.Double.NaN;
        }

        public Double(Range2D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
            this.ymin = r.getYMinAsDouble();
            this.ymax = r.getYMaxAsDouble();
        }

        public Double(double x0, double x1, double y0, double y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public Double(Range1D xrange, Range1D yrange) {
            this(xrange.getXMinAsDouble(), xrange.getXMaxAsDouble(), yrange.getXMinAsDouble(), yrange.getXMaxAsDouble());
        }

        public void set(Range1D xrange, Range1D yrange) {
            this.set(xrange.getXMinAsDouble(), xrange.getXMaxAsDouble(), yrange.getXMinAsDouble(), yrange.getXMaxAsDouble());
        }

        public Double clip(double x0, double x1, double y0, double y1) {
            Double nr = new Double(x0, x1, y0, y1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Double clip(Range2D r) {
            Double nr = new Double(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Object clone() {
            Double range = null;
            try {
                range = (Double)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range2D r;
            return obj instanceof Range2D && (this == (r = (Range2D)obj) || Math.abs(r.getXMinAsDouble() - this.xmin) < 9.9E-324 && Math.abs(r.getXMaxAsDouble() - this.xmax) < 9.9E-324 && Math.abs(r.getYMinAsDouble() - this.ymin) < 9.9E-324 && Math.abs(r.getYMaxAsDouble() - this.ymax) < 9.9E-324);
        }

        public void extend(double xamount, double yamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        public Range1D.Double getXRange() {
            return new Range1D.Double(this.xmin, this.xmax);
        }

        public Range1D.Double getYRange() {
            return new Range1D.Double(this.ymin, this.ymax);
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public double getCenter(int dim) {
            if (dim == 0) {
                return 0.5 * (this.xmax + this.xmin);
            }
            if (dim == 1) {
                return 0.5 * (this.ymax + this.ymin);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Double getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Double(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Double(this.ymin, this.ymax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public double getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getYMax() {
            return this.ymax;
        }

        public double getXMin() {
            return this.xmin;
        }

        public double getYMin() {
            return this.ymin;
        }

        public double getXWidth() {
            return this.xmax - this.xmin;
        }

        public double getXCenter() {
            return 0.5 * (this.xmax + this.xmin);
        }

        public double getYCenter() {
            return 0.5 * (this.ymax + this.ymin);
        }

        public double getYWidth() {
            return this.ymax - this.ymin;
        }

        public Double include(double x, double y) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            return this;
        }

        public Double include(Point2D p) {
            return this.include(p.x, p.y);
        }

        public Double include(Range2D range) {
            return this.include(range.getXMinAsDouble(), range.getXMaxAsDouble(), range.getYMinAsDouble(), range.getYMaxAsDouble());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax && this.ymin == this.ymin && this.ymax == this.ymax;
        }

        public void set(double x0, double x1, double y0, double y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public void set(Range2D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
            this.ymin = r.getYMinAsDouble();
            this.ymax = r.getYMaxAsDouble();
        }

        public void setCenterAndWidth(double xcenter, double xwidth, double ycenter, double ywidth) {
            this.xmin = xcenter - 0.5 * xwidth;
            this.xmax = xcenter + 0.5 * xwidth;
            this.ymin = ycenter - 0.5 * ywidth;
            this.ymax = ycenter + 0.5 * ywidth;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "],[" + this.ymin + "," + this.ymax + "]";
        }

        public void translate(double xamount, double yamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
        }

        public Double union(double xvalue, double yvalue) {
            Double range = (Double)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            return range;
        }

        public Double union(Point2D p) {
            return this.union(p.x, p.y);
        }

        public Double union(double xmin, double xmax, double ymin, double ymax) {
            Double range = (Double)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            return range;
        }

        public Double include(double xmin, double xmax, double ymin, double ymax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            return this;
        }

        public Double union(Range2D range) {
            return this.union(range.getXMinAsDouble(), range.getXMaxAsDouble(), range.getYMinAsDouble(), range.getYMaxAsDouble());
        }
    }

    public static class Int
    extends Range2D
    implements Range.Int,
    Cloneable {
        private static final long serialVersionUID = -3771688259177686692L;
        private int xmin;
        private int xmax;
        private int ymin;
        private int ymax;

        public Int() {
            this.xmin = 0;
            this.xmax = 0;
            this.ymin = 0;
            this.ymax = 0;
        }

        public Int(Int r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
            this.ymin = r.ymin;
            this.ymax = r.ymax;
        }

        public Int(Range1D.Int xrange, Range1D.Int yrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
        }

        public void set(Range1D.Int xrange, Range1D.Int yrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
        }

        public Int(int x0, int x1, int y0, int y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public boolean contains(int x, int y) {
            return x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax;
        }

        public Int clip(int x0, int x1, int y0, int y1) {
            Int nr = new Int(x0, x1, y0, y1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Int clip(Int r) {
            Int nr = new Int(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            return nr;
        }

        public Object clone() {
            Int range = null;
            try {
                range = (Int)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Int r;
            return obj instanceof Int && (this == (r = (Int)obj) || r.xmin == this.xmin && r.xmax == this.xmax && r.ymin == this.ymin && r.ymax == this.ymax);
        }

        public void extend(int xamount, int yamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public int getCenter(int dim) {
            if (dim == 0) {
                return (this.xmax + this.xmin) / 2;
            }
            if (dim == 1) {
                return (this.ymax + this.ymin) / 2;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Int getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Int(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Int(this.ymin, this.ymax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public int getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            throw new IndexOutOfBoundsException();
        }

        public int getXMax() {
            return this.xmax;
        }

        public int getYMax() {
            return this.ymax;
        }

        public int getXMin() {
            return this.xmin;
        }

        public Range1D.Int getXRange() {
            return new Range1D.Int(this.xmin, this.xmax);
        }

        public Range1D.Int getYRange() {
            return new Range1D.Int(this.ymin, this.ymax);
        }

        public int getYMin() {
            return this.ymin;
        }

        public int getXWidth() {
            return this.xmax - this.xmin;
        }

        public int getXCenter() {
            return (this.xmax + this.xmin) / 2;
        }

        public int getYCenter() {
            return (this.ymax + this.ymin) / 2;
        }

        public int getYWidth() {
            return this.ymax - this.ymin;
        }

        public Int include(int x, int y) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            return this;
        }

        public Int include(int xmin, int xmax, int ymin, int ymax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            return this;
        }

        public Int include(Int range) {
            return this.include(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax());
        }

        public void set(int x0, int x1, int y0, int y1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
        }

        public void set(Int r) {
            this.xmin = r.getXMin();
            this.xmax = r.getXMax();
            this.ymin = r.getYMin();
            this.ymax = r.getYMax();
        }

        public void setCenterAndWidth(int xcenter, int xwidth, int ycenter, int ywidth) {
            this.xmin = xcenter - xwidth / 2;
            this.xmax = xcenter + xwidth / 2;
            this.ymin = ycenter - ywidth / 2;
            this.ymax = ycenter + ywidth / 2;
        }

        @Override
        public String toString() {
            return "[" + this.xmin + "," + this.xmax + "],[" + this.ymin + "," + this.ymax + "]";
        }

        public void translate(int xamount, int yamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
        }

        public Int union(int xvalue, int yvalue) {
            Int range = (Int)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            return range;
        }

        public Int union(int xmin, int xmax, int ymin, int ymax) {
            Int range = (Int)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            return range;
        }

        public Int union(Int range) {
            return this.union(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax());
        }
    }
}

