/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public abstract class Range3D
extends Range {
    private static final long serialVersionUID = -7893792822902181226L;

    protected Range3D() {
        super(2);
    }

    public boolean contains(Range3D r) {
        return r.getXMinAsDouble() >= this.getXMinAsDouble() && r.getXMaxAsDouble() <= this.getXMaxAsDouble() && r.getYMinAsDouble() >= this.getYMinAsDouble() && r.getYMaxAsDouble() <= this.getYMaxAsDouble() && r.getZMinAsDouble() >= this.getZMinAsDouble() && r.getZMaxAsDouble() <= this.getZMaxAsDouble();
    }

    public abstract double getXMaxAsDouble();

    public abstract double getXMinAsDouble();

    public abstract double getYMaxAsDouble();

    public abstract double getYMinAsDouble();

    public abstract double getZMaxAsDouble();

    public abstract double getZMinAsDouble();

    public static class Float
    extends Range3D
    implements Range.Float,
    Cloneable {
        private static final long serialVersionUID = -5479043455846444112L;
        private float xmin;
        private float xmax;
        private float ymin;
        private float ymax;
        private float zmin;
        private float zmax;

        public Float() {
            this.xmin = java.lang.Float.NaN;
            this.xmax = java.lang.Float.NaN;
            this.ymin = java.lang.Float.NaN;
            this.ymax = java.lang.Float.NaN;
            this.zmin = java.lang.Float.NaN;
            this.zmax = java.lang.Float.NaN;
        }

        public Float(Range3D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
            this.ymin = (float)r.getYMinAsDouble();
            this.ymax = (float)r.getYMaxAsDouble();
            this.zmin = (float)r.getZMinAsDouble();
            this.zmax = (float)r.getZMaxAsDouble();
        }

        public Float(Range1D xrange, Range1D yrange, Range1D zrange) {
            this.xmin = (float)xrange.getXMinAsDouble();
            this.xmax = (float)xrange.getXMaxAsDouble();
            this.ymin = (float)yrange.getXMinAsDouble();
            this.ymax = (float)yrange.getXMaxAsDouble();
            this.zmin = (float)zrange.getXMinAsDouble();
            this.zmax = (float)zrange.getXMaxAsDouble();
        }

        public void set(Range1D xrange, Range1D yrange, Range1D zrange) {
            this.xmin = (float)xrange.getXMinAsDouble();
            this.xmax = (float)xrange.getXMaxAsDouble();
            this.ymin = (float)yrange.getXMinAsDouble();
            this.ymax = (float)yrange.getXMaxAsDouble();
            this.zmin = (float)zrange.getXMinAsDouble();
            this.zmax = (float)zrange.getXMaxAsDouble();
        }

        public Float(Range1D.Float xrange, Range1D.Float yrange, Range1D.Float zrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
            this.zmin = zrange.getXMin();
            this.zmax = zrange.getXMax();
        }

        public void set(Range1D.Float xrange, Range1D.Float yrange, Range1D.Float zrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
            this.zmin = zrange.getXMin();
            this.zmax = zrange.getXMax();
        }

        public Float(Float r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
            this.ymin = r.ymin;
            this.ymax = r.ymax;
            this.zmin = r.zmin;
            this.zmax = r.zmax;
        }

        public Float(float x0, float x1, float y0, float y1, float z0, float z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = y0;
            }
        }

        public Float clip(float x0, float x1, float y0, float y1, float z0, float z1) {
            Float nr = new Float(x0, x1, y0, y1, z0, z1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.zmin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Float clip(Range3D r) {
            Float nr = new Float(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.zmin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Object clone() {
            Float range = null;
            try {
                range = (Float)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range3D r;
            return obj instanceof Range3D && (this == (r = (Range3D)obj) || Math.abs(r.getXMinAsDouble() - (double)this.xmin) < (double)2.8E-45f && Math.abs(r.getXMaxAsDouble() - (double)this.xmax) < (double)2.8E-45f && Math.abs(r.getYMinAsDouble() - (double)this.ymin) < (double)2.8E-45f && Math.abs(r.getYMaxAsDouble() - (double)this.ymax) < (double)2.8E-45f && Math.abs(r.getZMinAsDouble() - (double)this.zmin) < (double)2.8E-45f && Math.abs(r.getZMaxAsDouble() - (double)this.zmax) < (double)2.8E-45f);
        }

        public boolean equals(Float r) {
            return this == r || (double)Math.abs(r.xmin - this.xmin) < (double)2.8E-45f && (double)Math.abs(r.xmax - this.xmax) < (double)2.8E-45f && (double)Math.abs(r.ymin - this.ymin) < (double)2.8E-45f && (double)Math.abs(r.ymax - this.ymax) < (double)2.8E-45f && (double)Math.abs(r.zmin - this.zmin) < (double)2.8E-45f && (double)Math.abs(r.zmax - this.zmax) < (double)2.8E-45f;
        }

        public void extend(float xamount, float yamount, float zamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
            this.zmin -= zamount;
            this.zmax += zamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getZMaxAsDouble() {
            return this.zmax;
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public float getCenter(int dim) {
            if (dim == 0) {
                return 0.5f * (this.xmax + this.xmin);
            }
            if (dim == 1) {
                return 0.5f * (this.ymax + this.ymin);
            }
            if (dim == 2) {
                return 0.5f * (this.zmax + this.zmin);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Float getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Float(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Float(this.ymin, this.ymax);
            }
            if (dim == 2) {
                return new Range1D.Float(this.zmin, this.zmax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public float getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            if (dim == 2) {
                return this.zmax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public double getZMinAsDouble() {
            return this.zmin;
        }

        @Override
        public float getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            if (dim == 2) {
                return this.zmax - this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public float getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            if (dim == 2) {
                return this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        public float getXMax() {
            return this.xmax;
        }

        public float getZMax() {
            return this.zmax;
        }

        public float getYMax() {
            return this.ymax;
        }

        public float getXMin() {
            return this.xmin;
        }

        public Range1D.Float getXRange() {
            return new Range1D.Float(this.xmin, this.xmax);
        }

        public Range1D.Float getZRange() {
            return new Range1D.Float(this.zmin, this.zmax);
        }

        public Range1D.Float getYRange() {
            return new Range1D.Float(this.ymin, this.ymax);
        }

        public float getZMin() {
            return this.zmin;
        }

        public float getYMin() {
            return this.ymin;
        }

        public float getXWidth() {
            return this.xmax - this.xmin;
        }

        public float getXCenter() {
            return 0.5f * (this.xmax + this.xmin);
        }

        public float getZCenter() {
            return 0.5f * (this.zmax + this.zmin);
        }

        public float getYCenter() {
            return 0.5f * (this.ymax + this.ymin);
        }

        public float getZWidth() {
            return this.zmax - this.zmin;
        }

        public float getYWidth() {
            return this.ymax - this.ymin;
        }

        public Float include(float x, float y, float z) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            if (z < this.zmin) {
                this.zmin = z;
            }
            if (z > this.zmax) {
                this.zmax = z;
            }
            return this;
        }

        public Float include(Range3D range) {
            return this.include((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble(), (float)range.getYMinAsDouble(), (float)range.getYMaxAsDouble(), (float)range.getZMinAsDouble(), (float)range.getZMaxAsDouble());
        }

        public Float include(Float range) {
            return this.include(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax(), range.getZMin(), range.getZMax());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax && this.ymin == this.ymin && this.ymax == this.ymax && this.zmin == this.zmin && this.zmax == this.zmax;
        }

        public void set(float x0, float x1, float y0, float y1, float z0, float z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = z0;
            }
        }

        public void set(Float r) {
            this.xmin = r.getXMin();
            this.xmax = r.getXMax();
            this.ymin = r.getYMin();
            this.ymax = r.getYMax();
            this.zmin = r.getZMin();
            this.zmax = r.getZMax();
        }

        public void set(Range3D r) {
            this.xmin = (float)r.getXMinAsDouble();
            this.xmax = (float)r.getXMaxAsDouble();
            this.ymin = (float)r.getYMinAsDouble();
            this.ymax = (float)r.getYMaxAsDouble();
            this.zmin = (float)r.getZMinAsDouble();
            this.zmax = (float)r.getZMaxAsDouble();
        }

        public void setCenterAndWidth(float xcenter, float xwidth, float ycenter, float ywidth, float zcenter, float zwidth) {
            this.xmin = xcenter - 0.5f * xwidth;
            this.xmax = xcenter + 0.5f * xwidth;
            this.ymin = ycenter - 0.5f * ywidth;
            this.ymax = ycenter + 0.5f * ywidth;
            this.zmin = zcenter - 0.5f * zwidth;
            this.zmax = zcenter + 0.5f * zwidth;
        }

        @Override
        public String toString() {
            return "" + '[' + this.xmin + ',' + this.xmax + "],[" + this.ymin + ',' + this.ymax + "],[" + this.zmin + ',' + this.zmax + ']';
        }

        public void translate(float xamount, float yamount, float zamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
            this.zmin += zamount;
            this.zmax += zamount;
        }

        public Float union(float xvalue, float yvalue, float zvalue) {
            Float range = (Float)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            if (zvalue < range.zmin) {
                range.zmin = zvalue;
            }
            if (zvalue > range.zmax) {
                range.zmax = zvalue;
            }
            return range;
        }

        public Float union(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
            Float range = (Float)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            if (zmin < range.zmin) {
                range.zmin = zmin;
            }
            if (zmax > range.zmax) {
                range.zmax = zmax;
            }
            return range;
        }

        public Float include(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            if (zmin < this.zmin) {
                this.zmin = zmin;
            }
            if (zmax > this.zmax) {
                this.zmax = zmax;
            }
            return this;
        }

        public Float union(Range3D range) {
            return this.union((float)range.getXMinAsDouble(), (float)range.getXMaxAsDouble(), (float)range.getYMinAsDouble(), (float)range.getYMaxAsDouble(), (float)range.getZMinAsDouble(), (float)range.getZMaxAsDouble());
        }

        public Float union(Float range) {
            return this.union(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax(), range.getZMin(), range.getZMax());
        }
    }

    public static class Double
    extends Range3D
    implements Range.Double,
    Cloneable {
        private static final long serialVersionUID = 2246452030290172973L;
        private double xmin;
        private double xmax;
        private double ymin;
        private double ymax;
        private double zmin;
        private double zmax;

        public Double() {
            this.xmin = java.lang.Double.NaN;
            this.xmax = java.lang.Double.NaN;
            this.ymin = java.lang.Double.NaN;
            this.ymax = java.lang.Double.NaN;
            this.zmin = java.lang.Double.NaN;
            this.zmax = java.lang.Double.NaN;
        }

        public Double(Range3D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
            this.ymin = r.getYMinAsDouble();
            this.ymax = r.getYMaxAsDouble();
            this.zmin = r.getZMinAsDouble();
            this.zmax = r.getZMaxAsDouble();
        }

        public Double(Range1D xrange, Range1D yrange, Range1D zrange) {
            this.xmin = xrange.getXMinAsDouble();
            this.xmax = xrange.getXMaxAsDouble();
            this.ymin = yrange.getXMinAsDouble();
            this.ymax = yrange.getXMaxAsDouble();
            this.zmin = zrange.getXMinAsDouble();
            this.zmax = zrange.getXMaxAsDouble();
        }

        public void set(Range1D xrange, Range1D yrange, Range1D zrange) {
            this.xmin = xrange.getXMinAsDouble();
            this.xmax = xrange.getXMaxAsDouble();
            this.ymin = yrange.getXMinAsDouble();
            this.ymax = yrange.getXMaxAsDouble();
            this.zmin = zrange.getXMinAsDouble();
            this.zmax = zrange.getXMaxAsDouble();
        }

        public Double(double x0, double x1, double y0, double y1, double z0, double z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = z0;
            }
        }

        public Double clip(double x0, double x1, double y0, double y1, double z0, double z1) {
            Double nr = new Double(x0, x1, y0, y1, z0, z1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.ymin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Double clip(Range3D r) {
            Double nr = new Double(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.zmin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Object clone() {
            Double range = null;
            try {
                range = (Double)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Range3D r;
            return obj instanceof Range3D && (this == (r = (Range3D)obj) || Math.abs(r.getXMinAsDouble() - this.xmin) < 9.9E-324 && Math.abs(r.getXMaxAsDouble() - this.xmax) < 9.9E-324 && Math.abs(r.getYMinAsDouble() - this.ymin) < 9.9E-324 && Math.abs(r.getYMaxAsDouble() - this.ymax) < 9.9E-324 && Math.abs(r.getZMinAsDouble() - this.zmin) < 9.9E-324 && Math.abs(r.getZMaxAsDouble() - this.zmax) < 9.9E-324);
        }

        public void extend(double xamount, double yamount, double zamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
            this.zmin -= zamount;
            this.zmax += zamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getZMaxAsDouble() {
            return this.zmax;
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public double getCenter(int dim) {
            if (dim == 0) {
                return 0.5 * (this.xmax + this.xmin);
            }
            if (dim == 1) {
                return 0.5 * (this.ymax + this.ymin);
            }
            if (dim == 2) {
                return 0.5 * (this.zmax + this.zmin);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Double getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Double(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Double(this.ymin, this.ymax);
            }
            if (dim == 2) {
                return new Range1D.Double(this.zmin, this.zmax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            if (dim == 2) {
                return this.zmax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getZMinAsDouble() {
            return this.zmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public double getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            if (dim == 2) {
                return this.zmax - this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            if (dim == 2) {
                return this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getZMax() {
            return this.zmax;
        }

        public double getYMax() {
            return this.ymax;
        }

        public double getXMin() {
            return this.xmin;
        }

        public Range1D.Double getXRange() {
            return new Range1D.Double(this.xmin, this.xmax);
        }

        public Range1D.Double getZRange() {
            return new Range1D.Double(this.zmin, this.zmax);
        }

        public Range1D.Double getYRange() {
            return new Range1D.Double(this.ymin, this.ymax);
        }

        public double getZMin() {
            return this.zmin;
        }

        public double getYMin() {
            return this.ymin;
        }

        public double getXWidth() {
            return this.xmax - this.xmin;
        }

        public double getXCenter() {
            return 0.5 * (this.xmax + this.xmin);
        }

        public double getZCenter() {
            return 0.5 * (this.zmax + this.zmin);
        }

        public double getYCenter() {
            return 0.5 * (this.ymax + this.ymin);
        }

        public double getZWidth() {
            return this.zmax - this.zmin;
        }

        public double getYWidth() {
            return this.ymax - this.ymin;
        }

        public Double include(double x, double y, double z) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            if (z < this.zmin) {
                this.zmin = z;
            }
            if (z > this.zmax) {
                this.zmax = z;
            }
            return this;
        }

        public Double include(Range3D range) {
            return this.include(range.getXMinAsDouble(), range.getXMaxAsDouble(), range.getYMinAsDouble(), range.getYMaxAsDouble(), range.getZMinAsDouble(), range.getZMaxAsDouble());
        }

        public boolean isValid() {
            return this.xmin == this.xmin && this.xmax == this.xmax && this.ymin == this.ymin && this.ymax == this.ymax && this.zmin == this.zmin && this.zmax == this.zmax;
        }

        public void set(double x0, double x1, double y0, double y1, double z0, double z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = z0;
            }
        }

        public void set(Range3D r) {
            this.xmin = r.getXMinAsDouble();
            this.xmax = r.getXMaxAsDouble();
            this.ymin = r.getYMinAsDouble();
            this.ymax = r.getYMaxAsDouble();
            this.zmin = r.getZMinAsDouble();
            this.zmax = r.getZMaxAsDouble();
        }

        public void setCenterAndWidth(double xcenter, double xwidth, double ycenter, double ywidth, double zcenter, double zwidth) {
            this.xmin = xcenter - 0.5 * xwidth;
            this.xmax = xcenter + 0.5 * xwidth;
            this.ymin = ycenter - 0.5 * ywidth;
            this.ymax = ycenter + 0.5 * ywidth;
            this.zmin = zcenter - 0.5 * zwidth;
            this.zmax = zcenter + 0.5 * zwidth;
        }

        @Override
        public String toString() {
            return "" + '[' + this.xmin + ',' + this.xmax + "],[" + this.ymin + ',' + this.ymax + "],[" + this.zmin + ',' + this.zmax + ']';
        }

        public void translate(double xamount, double yamount, double zamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
            this.zmin += zamount;
            this.zmax += zamount;
        }

        public Double union(double xvalue, double yvalue, double zvalue) {
            Double range = (Double)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            if (zvalue < range.zmin) {
                range.zmin = zvalue;
            }
            if (zvalue > range.zmax) {
                range.zmax = zvalue;
            }
            return range;
        }

        public Double union(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
            Double range = (Double)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            if (zmin < range.zmin) {
                range.zmin = zmin;
            }
            if (zmax > range.zmax) {
                range.zmax = zmax;
            }
            return range;
        }

        public Double include(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            if (zmin < this.zmin) {
                this.zmin = zmin;
            }
            if (zmax > this.zmax) {
                this.zmax = zmax;
            }
            return this;
        }

        public Double union(Range3D range) {
            return this.union(range.getXMinAsDouble(), range.getXMaxAsDouble(), range.getYMinAsDouble(), range.getYMaxAsDouble(), range.getZMinAsDouble(), range.getZMaxAsDouble());
        }
    }

    public static class Int
    extends Range3D
    implements Range.Int,
    Cloneable {
        private static final long serialVersionUID = 286208478600748675L;
        private int xmin;
        private int xmax;
        private int ymin;
        private int ymax;
        private int zmin;
        private int zmax;

        public Int() {
            this.xmin = 0;
            this.xmax = 0;
            this.ymin = 0;
            this.ymax = 0;
            this.zmin = 0;
            this.zmax = 0;
        }

        public Int(Int r) {
            this.xmin = r.xmin;
            this.xmax = r.xmax;
            this.ymin = r.ymin;
            this.ymax = r.ymax;
            this.zmin = r.zmin;
            this.zmax = r.zmax;
        }

        public Int(Range1D.Int xrange, Range1D.Int yrange, Range1D.Int zrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
            this.zmin = zrange.getXMin();
            this.zmax = zrange.getXMax();
        }

        public void set(Range1D.Int xrange, Range1D.Int yrange, Range1D.Int zrange) {
            this.xmin = xrange.getXMin();
            this.xmax = xrange.getXMax();
            this.ymin = yrange.getXMin();
            this.ymax = yrange.getXMax();
            this.zmin = zrange.getXMin();
            this.zmax = zrange.getXMax();
        }

        public Int(int x0, int x1, int y0, int y1, int z0, int z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = z0;
            }
        }

        public boolean contains(int x, int y, int z) {
            return x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax && z >= this.zmin && z <= this.zmax;
        }

        public Int clip(int x0, int x1, int y0, int y1, int z0, int z1) {
            Int nr = new Int(x0, x1, y0, y1, z0, z1);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.zmin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Int clip(Int r) {
            Int nr = new Int(r);
            if (nr.xmin < this.xmin) {
                if (nr.xmax <= this.xmin) {
                    return null;
                }
                nr.xmin = this.xmin;
            }
            if (nr.xmax > this.xmax) {
                if (nr.xmin >= this.xmax) {
                    return null;
                }
                nr.xmax = this.xmax;
            }
            if (nr.ymin < this.ymin) {
                if (nr.ymax <= this.ymin) {
                    return null;
                }
                nr.ymin = this.ymin;
            }
            if (nr.ymax > this.ymax) {
                if (nr.ymin >= this.ymax) {
                    return null;
                }
                nr.ymax = this.ymax;
            }
            if (nr.zmin < this.zmin) {
                if (nr.zmax <= this.zmin) {
                    return null;
                }
                nr.zmin = this.zmin;
            }
            if (nr.zmax > this.zmax) {
                if (nr.zmin >= this.zmax) {
                    return null;
                }
                nr.zmax = this.zmax;
            }
            return nr;
        }

        public Object clone() {
            Int range = null;
            try {
                range = (Int)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return range;
        }

        public boolean equals(Object obj) {
            Int r;
            return obj instanceof Int && (this == (r = (Int)obj) || r.xmin == this.xmin && r.xmax == this.xmax && r.ymin == this.ymin && r.ymax == this.ymax && r.zmin == this.zmin && r.zmax == this.zmax);
        }

        public void extend(int xamount, int yamount, int zamount) {
            this.xmin -= xamount;
            this.xmax += xamount;
            this.ymin -= yamount;
            this.ymax += yamount;
            this.zmin -= zamount;
            this.zmax += zamount;
        }

        @Override
        public double getXMaxAsDouble() {
            return this.xmax;
        }

        @Override
        public double getZMaxAsDouble() {
            return this.zmax;
        }

        @Override
        public double getYMaxAsDouble() {
            return this.ymax;
        }

        @Override
        public int getCenter(int dim) {
            if (dim == 0) {
                return (this.xmax + this.xmin) / 2;
            }
            if (dim == 1) {
                return (this.ymax + this.ymin) / 2;
            }
            if (dim == 2) {
                return (this.zmax + this.zmin) / 2;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Range1D.Int getRange(int dim) {
            if (dim == 0) {
                return new Range1D.Int(this.xmin, this.xmax);
            }
            if (dim == 1) {
                return new Range1D.Int(this.ymin, this.ymax);
            }
            if (dim == 2) {
                return new Range1D.Int(this.zmin, this.zmax);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getMax(int dim) {
            if (dim == 0) {
                return this.xmax;
            }
            if (dim == 1) {
                return this.ymax;
            }
            if (dim == 2) {
                return this.zmax;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getXMinAsDouble() {
            return this.xmin;
        }

        @Override
        public double getZMinAsDouble() {
            return this.zmin;
        }

        @Override
        public double getYMinAsDouble() {
            return this.ymin;
        }

        @Override
        public int getWidth(int dim) {
            if (dim == 0) {
                return this.xmax - this.xmin;
            }
            if (dim == 1) {
                return this.ymax - this.ymin;
            }
            if (dim == 2) {
                return this.zmax - this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getMin(int dim) {
            if (dim == 0) {
                return this.xmin;
            }
            if (dim == 1) {
                return this.ymin;
            }
            if (dim == 2) {
                return this.zmin;
            }
            throw new IndexOutOfBoundsException();
        }

        public int getXMax() {
            return this.xmax;
        }

        public int getZMax() {
            return this.zmax;
        }

        public int getYMax() {
            return this.ymax;
        }

        public int getXMin() {
            return this.xmin;
        }

        public Range1D.Int getXRange() {
            return new Range1D.Int(this.xmin, this.xmax);
        }

        public Range1D.Int getZRange() {
            return new Range1D.Int(this.zmin, this.zmax);
        }

        public Range1D.Int getYRange() {
            return new Range1D.Int(this.ymin, this.ymax);
        }

        public int getZMin() {
            return this.zmin;
        }

        public int getYMin() {
            return this.ymin;
        }

        public int getXWidth() {
            return this.xmax - this.xmin;
        }

        public int getXCenter() {
            return (this.xmax + this.xmin) / 2;
        }

        public int getZCenter() {
            return (this.zmax + this.zmin) / 2;
        }

        public int getYCenter() {
            return (this.ymax + this.ymin) / 2;
        }

        public int getZWidth() {
            return this.zmax - this.zmin;
        }

        public int getYWidth() {
            return this.ymax - this.ymin;
        }

        public Int include(int x, int y, int z) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
            if (z < this.zmin) {
                this.zmin = z;
            }
            if (z > this.zmax) {
                this.zmax = z;
            }
            return this;
        }

        public Int include(int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
            if (xmin < this.xmin) {
                this.xmin = xmin;
            }
            if (xmax > this.xmax) {
                this.xmax = xmax;
            }
            if (ymin < this.ymin) {
                this.ymin = ymin;
            }
            if (ymax > this.ymax) {
                this.ymax = ymax;
            }
            if (zmin < this.zmin) {
                this.zmin = zmin;
            }
            if (zmax > this.zmax) {
                this.zmax = zmax;
            }
            return this;
        }

        public Int include(Int range) {
            return this.include(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax(), range.getZMin(), range.getZMax());
        }

        public void set(int x0, int x1, int y0, int y1, int z0, int z1) {
            if (x0 < x1) {
                this.xmin = x0;
                this.xmax = x1;
            } else {
                this.xmin = x1;
                this.xmax = x0;
            }
            if (y0 < y1) {
                this.ymin = y0;
                this.ymax = y1;
            } else {
                this.ymin = y1;
                this.ymax = y0;
            }
            if (z0 < z1) {
                this.zmin = z0;
                this.zmax = z1;
            } else {
                this.zmin = z1;
                this.zmax = z0;
            }
        }

        public void set(Int r) {
            this.xmin = r.getXMin();
            this.xmax = r.getXMax();
            this.ymin = r.getYMin();
            this.ymax = r.getYMax();
            this.zmin = r.getZMin();
            this.zmax = r.getZMax();
        }

        public void setCenterAndWidth(int xcenter, int xwidth, int ycenter, int ywidth, int zcenter, int zwidth) {
            this.xmin = xcenter - xwidth / 2;
            this.xmax = xcenter + xwidth / 2;
            this.ymin = ycenter - ywidth / 2;
            this.ymax = ycenter + ywidth / 2;
            this.zmin = zcenter - zwidth / 2;
            this.zmax = zcenter + zwidth / 2;
        }

        @Override
        public String toString() {
            return "" + '[' + this.xmin + ',' + this.xmax + "],[" + this.ymin + ',' + this.ymax + "],[" + this.zmin + ',' + this.zmax + ']';
        }

        public void translate(int xamount, int yamount, int zamount) {
            this.xmin += xamount;
            this.xmax += xamount;
            this.ymin += yamount;
            this.ymax += yamount;
            this.zmin += zamount;
            this.zmax += zamount;
        }

        public Int union(int xvalue, int yvalue, int zvalue) {
            Int range = (Int)this.clone();
            if (xvalue < range.xmin) {
                range.xmin = xvalue;
            }
            if (xvalue > range.xmax) {
                range.xmax = xvalue;
            }
            if (yvalue < range.ymin) {
                range.ymin = yvalue;
            }
            if (yvalue > range.ymax) {
                range.ymax = yvalue;
            }
            if (zvalue < range.zmin) {
                range.zmin = zvalue;
            }
            if (zvalue > range.zmax) {
                range.zmax = zvalue;
            }
            return range;
        }

        public Int union(int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
            Int range = (Int)this.clone();
            if (xmin < range.xmin) {
                range.xmin = xmin;
            }
            if (xmax > range.xmax) {
                range.xmax = xmax;
            }
            if (ymin < range.ymin) {
                range.ymin = ymin;
            }
            if (ymax > range.ymax) {
                range.ymax = ymax;
            }
            if (zmin < range.zmin) {
                range.zmin = zmin;
            }
            if (zmax > range.zmax) {
                range.zmax = zmax;
            }
            return range;
        }

        public Int union(Int range) {
            return this.union(range.getXMin(), range.getXMax(), range.getYMin(), range.getYMax(), range.getZMin(), range.getZMax());
        }
    }
}

