/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.IStringIterator;
import org.jcamp.parser.LabelIterator;
import org.jcamp.parser.Utils;

public class BlockIterator
implements IStringIterator {
    private int start = 0;
    private int end = 0;
    private int depth = 0;
    private String jcamp;
    private LabelIterator labelIter = null;

    public BlockIterator(String jcamp) {
        this.jcamp = jcamp;
        this.labelIter = new LabelIterator(jcamp);
        this.nextBlock();
    }

    @Override
    public int getOffset() {
        if (this.jcamp != null && this.start < this.jcamp.length()) {
            return this.start;
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        if (this.jcamp == null) {
            return false;
        }
        return this.start < this.jcamp.length() && this.start <= this.end;
    }

    @Override
    public String next() {
        if (this.jcamp != null && this.start < this.jcamp.length() && this.start <= this.end) {
            String block = this.jcamp.substring(this.start, this.end);
            this.nextBlock();
            return block;
        }
        return null;
    }

    private void nextBlock() {
        while (true) {
            if (!this.labelIter.hasNext()) {
                this.start = this.end = this.jcamp.length();
                return;
            }
            int offset = this.labelIter.getOffset();
            String label = this.labelIter.next();
            if ((label = Utils.normalizeLabel(label)).equals("##TITLE=")) {
                if (this.depth == 1) {
                    this.start = offset;
                }
                ++this.depth;
                continue;
            }
            if (!label.equals("##END=")) continue;
            --this.depth;
            if (this.depth < 1) {
                this.start = this.end = this.jcamp.length();
                return;
            }
            if (this.depth == 1) break;
        }
        this.end = this.labelIter.getOffset() - 1;
    }
}

