/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jcamp.math.IArray2D;
import org.jcamp.parser.AFFNGroup;
import org.jcamp.parser.AFFNTokenizer;
import org.jcamp.parser.DataGroup;
import org.jcamp.parser.DataType;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.DatatableTokenizer;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuplePage;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.parser.NoteDescriptorFactory;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.IAssignmentTarget;
import org.jcamp.spectrum.Multiplicity;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.assignments.AtomReference;
import org.jcamp.spectrum.notes.BadContentException;
import org.jcamp.spectrum.notes.NoteDescriptor;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

abstract class CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    protected CommonSpectrumJCAMPReader() {
    }

    @Override
    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        throw new JCAMPException("unimplemented adapter method");
    }

    protected double getFirstX(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable x = block.getVariable("X");
        if (x == null || x.getFirst() == null) {
            block.getErrorHandler().error("missing first x");
        }
        return x.getFirst();
    }

    protected double getFirstY(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable y = block.getVariable("Y");
        if (y == null || y.getFirst() == null) {
            block.getErrorHandler().error("missing first y");
        }
        return y.getFirst();
    }

    protected double getLastX(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable x = block.getVariable("X");
        if (x == null || x.getLast() == null) {
            block.getErrorHandler().error("missing last x");
        }
        return x.getLast();
    }

    protected int getNPoints(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrNPoints = block.getDataRecord("NPOINTS");
        if (ldrNPoints == null) {
            block.getErrorHandler().error("missing required label ##NPOINTS=");
        }
        String nPoints = ldrNPoints.getContent();
        return Integer.parseInt(nPoints);
    }

    protected IArray2D getNTuplePageData(JCAMPNTuplePage page) throws JCAMPException {
        return page.getXYData();
    }

    @Deprecated
    protected double[] getNTupleXYData(JCAMPBlock block, JCAMPNTuplePage page, double firstX, double lastX, int nPoints, double xFactor, double yFactor) throws JCAMPException {
        JCAMPDataRecord ldrXYData = page.getDataRecord("DATATABLE");
        if (ldrXYData == null) {
            block.getErrorHandler().fatal("missing required label ##DATATABLE=");
            return null;
        }
        DataVariableInfo varInfo = new DataVariableInfo(ldrXYData);
        if (!varInfo.isIncremental()) {
            block.getErrorHandler().fatal("data form missmatch");
        }
        double[] y = block.getASDFDecoder().decode(ldrXYData, firstX, lastX, xFactor, nPoints);
        int n = y.length;
        double[] yValues = new double[n];
        for (int i = 0; i < n; ++i) {
            yValues[i] = yFactor * y[i];
        }
        return yValues;
    }

    @Deprecated
    protected double[][] getNTupleXYPoints(JCAMPBlock block, JCAMPNTuplePage page) throws JCAMPException {
        JCAMPDataRecord ldrPeaktable = page.getDataRecord("DATATABLE");
        if (ldrPeaktable == null) {
            block.getErrorHandler().fatal("missing required label ##DATATABLE=");
            return null;
        }
        double[][] xy = new double[2][];
        ArrayList<Double> x = new ArrayList<Double>(20);
        ArrayList<Double> y = new ArrayList<Double>(20);
        AFFNTokenizer tokenizer = new AFFNTokenizer(ldrPeaktable);
        while (tokenizer.hasMoreGroups()) {
            AFFNGroup group = tokenizer.nextGroup();
            x.add(new Double(group.getValue(0)));
            y.add(new Double(group.getValue(1)));
        }
        xy[0] = new double[x.size()];
        xy[1] = new double[y.size()];
        for (int i = 0; i < x.size(); ++i) {
            xy[0][i] = (Double)x.get(i);
            xy[1][i] = (Double)y.get(i);
        }
        return xy;
    }

    protected String getOrigin(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrOrigin = block.getDataRecord("ORIGIN");
        if (ldrOrigin == null) {
            block.getErrorHandler().warn("missing required label ##ORIGIN=");
            return "UNKNOWN ORIGIN";
        }
        return ldrOrigin.getContent();
    }

    protected String getOwner(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrOwner = block.getDataRecord("OWNER");
        if (ldrOwner == null) {
            block.getErrorHandler().warn("missing required label ##OWNER=");
            return "COPYRIGHT UNKNOWN";
        }
        return ldrOwner.getContent();
    }

    protected Object[] getPeaktable(JCAMPBlock block, int nPoints, double xFactor, double yFactor) throws JCAMPException {
        JCAMPDataRecord ldrPeaktable = block.getDataRecord("PEAKTABLE");
        if (ldrPeaktable == null) {
            ldrPeaktable = block.getDataRecord("PEAKASSIGNMENTS");
        }
        if (ldrPeaktable == null) {
            ldrPeaktable = block.getDataRecord("XYPOINTS");
        }
        if (ldrPeaktable == null) {
            ldrPeaktable = block.getDataRecord("XYDATA");
        }
        if (ldrPeaktable == null) {
            block.getErrorHandler().fatal("missing peak table");
            return null;
        }
        DatatableTokenizer tokenizer = new DatatableTokenizer(ldrPeaktable);
        if (tokenizer.getType().equals(DataType.XY)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                peaks[i] = new Peak1D(x, y);
                ++i;
            }
            return new Object[]{peaks};
        }
        if (tokenizer.getType().equals(DataType.XYW)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                double w = (Double)group.getValue(2);
                peaks[i] = new Peak1D(x, y, w);
                ++i;
            }
            return new Object[]{peaks};
        }
        if (tokenizer.getType().equals(DataType.XYM)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            Pattern[] pattern = new Pattern[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                Multiplicity m = (Multiplicity)group.getValue(2);
                peaks[i] = new Peak1D(x, y);
                pattern[i] = new Pattern(x, m);
                ++i;
            }
            return new Object[]{peaks, pattern};
        }
        if (tokenizer.getType().equals(DataType.XYA)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            Pattern[] pattern = new Pattern[nPoints];
            Assignment[] assigns = new Assignment[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                String a = (String)group.getValue(2);
                peaks[i] = new Peak1D(x, y);
                IAssignmentTarget[] targets = CommonSpectrumJCAMPReader.parseAssignment(a);
                pattern[i] = new Pattern(x, Multiplicity.UNKNOWN, new Peak1D[]{peaks[i]});
                assigns[i] = new Assignment(pattern[i], targets);
                ++i;
            }
            return new Object[]{peaks, pattern, assigns};
        }
        if (tokenizer.getType().equals(DataType.XYMA)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            Pattern[] pattern = new Pattern[nPoints];
            Assignment[] assigns = new Assignment[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                Multiplicity m = (Multiplicity)group.getValue(2);
                String a = (String)group.getValue(3);
                IAssignmentTarget[] targets = CommonSpectrumJCAMPReader.parseAssignment(a);
                peaks[i] = new Peak1D(x, y);
                pattern[i] = new Pattern(x, m, new Peak1D[]{peaks[i]});
                assigns[i] = new Assignment(pattern[i], targets);
                ++i;
            }
            return new Object[]{peaks, pattern, assigns};
        }
        if (tokenizer.getType().equals(DataType.XYWA)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            Pattern[] pattern = new Pattern[nPoints];
            Assignment[] assigns = new Assignment[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                String a = (String)group.getValue(3);
                IAssignmentTarget[] targets = CommonSpectrumJCAMPReader.parseAssignment(a);
                peaks[i] = new Peak1D(x, y);
                pattern[i] = new Pattern(x, Multiplicity.UNKNOWN, new Peak1D[]{peaks[i]});
                assigns[i] = new Assignment(pattern[i], targets);
                ++i;
            }
            return new Object[]{peaks, pattern, assigns};
        }
        if (tokenizer.getType().equals(DataType.XYMWA)) {
            int i = 0;
            Peak1D[] peaks = new Peak1D[nPoints];
            Pattern[] pattern = new Pattern[nPoints];
            Assignment[] assigns = new Assignment[nPoints];
            while (tokenizer.hasMoreGroups()) {
                DataGroup group = tokenizer.nextGroup();
                double x = xFactor * (Double)group.getValue(0);
                double y = yFactor * (Double)group.getValue(1);
                Multiplicity m = (Multiplicity)group.getValue(2);
                double w = (Double)group.getValue(3);
                String a = (String)group.getValue(4);
                IAssignmentTarget[] targets = CommonSpectrumJCAMPReader.parseAssignment(a);
                peaks[i] = new Peak1D(x, y, w);
                pattern[i] = new Pattern(x, m, new Peak1D[]{peaks[i]});
                assigns[i] = new Assignment(pattern[i], targets);
                ++i;
            }
            return new Object[]{peaks, pattern, assigns};
        }
        block.getErrorHandler().fatal("unknown peaktable");
        return null;
    }

    protected String getTitle(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrTitle = block.getDataRecord("TITLE");
        if (ldrTitle == null) {
            block.getErrorHandler().fatal("missing required label ##TITLE=");
        }
        return ldrTitle.getContent();
    }

    protected double getXFactor(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable x = block.getVariable("X");
        if (x == null || x.getFactor() == null) {
            block.getErrorHandler().warn("missing x factor, assuming 1.0");
            return 1.0;
        }
        return x.getFactor();
    }

    protected Unit getXUnits(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable x = block.getVariable("X");
        if (x == null || x.getUnit() == null) {
            block.getErrorHandler().warn("missing x unit");
            return CommonUnit.generic;
        }
        return x.getUnit();
    }

    protected double[] getXYData(JCAMPBlock block, double firstX, double lastX, int nPoints, double xFactor, double yFactor) throws JCAMPException {
        JCAMPDataRecord ldrXYData = block.getDataRecord("XYDATA");
        if (ldrXYData == null) {
            block.getErrorHandler().fatal("missing required label ##XYDATA=");
            return null;
        }
        double[] y = block.getASDFDecoder().decode(ldrXYData, firstX, lastX, xFactor, nPoints);
        int n = y.length;
        double[] yValues = new double[n];
        for (int i = 0; i < n; ++i) {
            yValues[i] = yFactor * y[i];
        }
        return yValues;
    }

    protected double[][] getXYPoints(JCAMPBlock block, int nPoints, double xFactor, double yFactor) throws JCAMPException {
        JCAMPDataRecord ldrXYPoints = block.getDataRecord("XYPOINTS");
        if (ldrXYPoints == null) {
            block.getErrorHandler().fatal("missing required label ##XYPOINTS=");
            return null;
        }
        int i = 0;
        AFFNTokenizer tokenizer = new AFFNTokenizer(ldrXYPoints);
        class XYPair
        implements Comparable {
            public double x;
            public double y;

            public XYPair(double x, double y) {
                this.x = x;
                this.y = y;
            }

            public int compareTo(Object o) {
                XYPair p = (XYPair)o;
                if (this.x < p.x) {
                    return -1;
                }
                if (this.x > p.x) {
                    return 1;
                }
                return 0;
            }
        }
        TreeSet<XYPair> data = new TreeSet<XYPair>();
        while (tokenizer.hasMoreGroups()) {
            AFFNGroup group = tokenizer.nextGroup();
            data.add(new XYPair(xFactor * group.getValue(0), yFactor * group.getValue(1)));
        }
        if (data.size() != nPoints) {
            block.getErrorHandler().error("bad ##NPOINTS= or duplicate X values");
        }
        double[][] xy = new double[2][data.size()];
        for (XYPair p : data) {
            xy[0][i] = p.x;
            xy[1][i] = p.y;
        }
        return xy;
    }

    protected double getYFactor(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable y = block.getVariable("Y");
        if (y == null || y.getFactor() == null) {
            block.getErrorHandler().warn("missing y factor, assuming 1.0");
            return 1.0;
        }
        return y.getFactor();
    }

    protected Unit getYUnits(JCAMPBlock block) throws JCAMPException {
        JCAMPVariable y = block.getVariable("Y");
        if (y == null || y.getUnit() == null) {
            block.getErrorHandler().warn("missing y unit");
            return CommonUnit.generic;
        }
        return y.getUnit();
    }

    protected static IAssignmentTarget[] parseAssignment(String assign) {
        ArrayList<AtomReference> targets = new ArrayList<AtomReference>(5);
        StringTokenizer tokenizer = new StringTokenizer(assign, ",");
        while (tokenizer.hasMoreTokens()) {
            String target = tokenizer.nextToken();
            try {
                int atomNo = Integer.parseInt(target.trim());
                targets.add(new AtomReference(null, atomNo));
            }
            catch (Exception atomNo) {}
        }
        IAssignmentTarget[] assigns = new IAssignmentTarget[targets.size()];
        for (int i = 0; i < targets.size(); ++i) {
            assigns[i] = (IAssignmentTarget)targets.get(i);
        }
        return assigns;
    }

    protected static double[][] peakTableToPeakSpectrum(Peak1D[] peaks) throws JCAMPException {
        int n = peaks.length;
        if (n == 0) {
            throw new JCAMPException("empty peak table");
        }
        Arrays.sort(peaks);
        ArrayList<Double> px = new ArrayList<Double>(n);
        ArrayList<Double> py = new ArrayList<Double>(n);
        double x0 = peaks[0].getPosition()[0];
        double y0 = peaks[0].getHeight();
        for (int i = 1; i < n; ++i) {
            double x = peaks[i].getPosition()[0];
            double y = peaks[i].getHeight();
            if (x - x0 > Double.MIN_VALUE) {
                px.add(new Double(x0));
                py.add(new Double(y0));
                x0 = x;
                y0 = y;
                continue;
            }
            y0 += y;
        }
        px.add(new Double(x0));
        py.add(new Double(y0));
        double[][] xy = new double[2][px.size()];
        for (int i = 0; i < px.size(); ++i) {
            xy[0][i] = (Double)px.get(i);
            xy[1][i] = (Double)py.get(i);
        }
        return xy;
    }

    protected void setNote(JCAMPBlock block, JCAMPDataRecord ldr, Spectrum spectrum) throws JCAMPException {
        String key = ldr.getKey();
        if (key.length() == 0) {
            return;
        }
        NoteDescriptor descr = NoteDescriptorFactory.getInstance().findByJCAMPKey(key);
        if (descr.equals(NoteDescriptor.IGNORE)) {
            return;
        }
        try {
            Object content = descr.getNoteContentParser().parseContent(ldr.getContent(), descr.getNoteContentClass());
            spectrum.setNote(descr, content);
        }
        catch (BadContentException ex) {
            StringBuilder msg = new StringBuilder("bad ").append(descr.getName()).append(" note:\n").append(ex.getMessage());
            block.getErrorHandler().warn(msg.toString());
        }
    }

    protected void setNotes(JCAMPBlock block, Spectrum spectrum) throws JCAMPException {
        String title = this.getTitle(block);
        spectrum.setTitle(title);
        int n = block.numDataRecords();
        for (int i = 0; i < n; ++i) {
            JCAMPDataRecord ldr = block.getDataRecord(i);
            this.setNote(block, ldr, spectrum);
        }
    }
}

