/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.IJCAMPNoteMarshaller;
import org.jcamp.parser.Utils;

public class DefaultNoteMarshaller
implements IJCAMPNoteMarshaller {
    protected String JCAMPLabel;
    protected String key;

    public DefaultNoteMarshaller() {
    }

    public DefaultNoteMarshaller(String key) {
        this(key, key.toUpperCase());
    }

    public DefaultNoteMarshaller(String key, String JCAMPLabel) {
        this.key = key;
        this.JCAMPLabel = JCAMPLabel;
    }

    @Override
    public String getJCAMPLabel() {
        return Utils.normalizeLabel(this.JCAMPLabel);
    }

    protected String getKey() {
        return this.key;
    }

    @Override
    public void setJCAMPLabel(String newJCAMPLabel) {
        this.JCAMPLabel = newJCAMPLabel;
    }

    @Override
    public void setKey(String newKey) {
        this.key = newKey;
    }

    @Override
    public String toJCAMP(Object value) {
        StringBuilder label = new StringBuilder("##").append(this.JCAMPLabel).append('=');
        label.append(value.toString());
        int len = label.length();
        int line = len / 75;
        for (int i = 0; i < line; ++i) {
            label.insert(75 + i * 78, "=\r\n");
        }
        label.append("\r\n");
        return label.toString();
    }
}

