/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.math.IArray1D;
import org.jcamp.math.IArray2D;
import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuple;
import org.jcamp.parser.JCAMPNTuplePage;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.Fluorescence2DSpectrum;
import org.jcamp.spectrum.FluorescenceSpectrum;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class FluorescenceJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    private static Log log = LogFactory.getLog(FluorescenceJCAMPReader.class);

    protected FluorescenceJCAMPReader() {
    }

    private FluorescenceSpectrum createFS(JCAMPBlock block) throws JCAMPException {
        FluorescenceSpectrum spectrum;
        Unit yUnit;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.nanometerWavelength;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.absorbance;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        if (block.getDataRecord("XYDATA") != null) {
            double lastX;
            double firstX = this.getFirstX(block);
            double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints, xFactor, yFactor);
            if (intensities.length != nPoints) {
                throw new JCAMPException("incorrect ##NPOINTS= or bad ##XYDATA=");
            }
            EquidistantData x = new EquidistantData(firstX, lastX, nPoints, xUnit);
            ArrayData y = new ArrayData(intensities, yUnit);
            spectrum = new FluorescenceSpectrum(x, y, true);
        } else if (block.getDataRecord("XYPOINTS") != null) {
            double[][] xy = this.getXYPoints(block, nPoints, xFactor, yFactor);
            OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
            ArrayData y = new ArrayData(xy[1], yUnit);
            spectrum = new FluorescenceSpectrum(x, y, false);
        } else {
            throw new JCAMPException("missing data: ##XYDATA= or ##XYPOINTS= required.");
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }

    private Fluorescence2DSpectrum createFS2D(JCAMPBlock block) throws JCAMPException {
        double[] intensities;
        EquidistantData y;
        EquidistantData x;
        Unit intensityUnit;
        Unit excitationUnit;
        Unit emissionUnit;
        int i;
        JCAMPNTuple ntuple = block.getNTuple();
        JCAMPVariable[] vars = block.getVariables();
        int nPages = ntuple.numPages();
        int emissionIndex = -1;
        int excitationIndex = -1;
        int intensityIndex = -1;
        for (i = 0; i < vars.length; ++i) {
            String name = vars[i].getName().toUpperCase();
            if ("INTENSITY".equalsIgnoreCase(name)) {
                intensityIndex = i;
                continue;
            }
            if ("EMISSION".equalsIgnoreCase(name)) {
                emissionIndex = i;
                continue;
            }
            if ("EXCITATION".equalsIgnoreCase(name)) {
                excitationIndex = i;
                continue;
            }
            if ("PAGE".equals(name)) continue;
            log.warn((Object)("unknown fluorescence variable: " + name));
        }
        for (i = 0; i < vars.length; ++i) {
            if (intensityIndex < 0 && vars[i].getType().equals(JCAMPVariable.Type.DEPENDENT)) {
                log.warn((Object)("intensity variable could not be recognized: using dependend variable at column " + (i + 1)));
                intensityIndex = i;
            }
            if (emissionIndex < 0 && vars[i].getType().equals(JCAMPVariable.Type.INDEPENDENT)) {
                log.warn((Object)("emission variable could not be recognized: using independend variable at column " + (i + 1)));
                emissionIndex = i;
            }
            if (excitationIndex >= 0 || !vars[i].getType().equals(JCAMPVariable.Type.INDEPENDENT)) continue;
            log.warn((Object)("excitation variable could not be recognized: using independend variable at column " + (i + 1)));
            excitationIndex = i;
        }
        if (emissionIndex < 0) {
            throw new JCAMPException("missing emission variable");
        }
        if (excitationIndex < 0) {
            throw new JCAMPException("missing excitation variable");
        }
        if (intensityIndex < 0) {
            throw new JCAMPException("missing intensity variable");
        }
        Double emissionFirst = vars[emissionIndex].getFirst();
        if (emissionFirst == null) {
            throw new JCAMPException("missing ##FIRST= for emission");
        }
        double mFirst = emissionFirst;
        Double emissionLast = vars[emissionIndex].getLast();
        if (emissionLast == null) {
            throw new JCAMPException("missing ##LAST= for emission");
        }
        double mLast = emissionLast;
        Integer emissionDim = vars[emissionIndex].getDimension();
        if (emissionDim == null) {
            throw new JCAMPException("missing ##VARDIM= for emission");
        }
        int mDim = emissionDim;
        Double excitationFirst = vars[excitationIndex].getFirst();
        if (excitationFirst == null) {
            throw new JCAMPException("missing ##FIRST= for excitation");
        }
        double xFirst = excitationFirst;
        Double excitationLast = vars[excitationIndex].getLast();
        if (excitationLast == null) {
            throw new JCAMPException("missing ##LAST= for excitation");
        }
        double xLast = excitationLast;
        Integer excitationDim = vars[excitationIndex].getDimension();
        if (excitationDim == null) {
            throw new JCAMPException("missing ##VARDIM= for excitation");
        }
        int xDim = excitationDim;
        JCAMPNTuplePage firstPage = block.getNTuple().getPage(0);
        boolean excitationIsX = true;
        if (firstPage.getPageVariableSymbols()[0].equals(vars[excitationIndex].getSymbol())) {
            excitationIsX = false;
        }
        if ((emissionUnit = vars[emissionIndex].getUnit()) == null) {
            emissionUnit = CommonUnit.nanometerWavelength;
        }
        if ((excitationUnit = vars[excitationIndex].getUnit()) == null) {
            excitationUnit = CommonUnit.nanometerWavelength;
        }
        if ((intensityUnit = vars[intensityIndex].getUnit()) == null) {
            intensityUnit = CommonUnit.absorbance;
        }
        if (excitationIsX) {
            x = new EquidistantData(xFirst, xLast, xDim, excitationUnit);
            x.setLabel("Excitation [" + excitationUnit + "]");
            y = new EquidistantData(mFirst, mLast, mDim, emissionUnit);
            y.setLabel("Emission [" + emissionUnit + "]");
            intensities = new double[x.getLength() * y.getLength()];
            if (nPages != emissionDim) {
                log.warn((Object)"number of pages != emission dimension, possible missing values");
            }
            for (int i2 = 0; i2 < nPages; ++i2) {
                int index;
                JCAMPNTuplePage page = block.getNTuple().getPage(i2);
                IArray2D data = page.getXYData();
                String emissionStr = page.getPageVariableValue(vars[emissionIndex].getSymbol());
                if (emissionStr == null) {
                    index = i2 * x.getLength();
                    log.warn((Object)"missing ##PAGE= emission entry, assuming ordered pages");
                } else {
                    double emission = Double.parseDouble(emissionStr);
                    index = y.indexAt(emission);
                    index *= x.getLength();
                }
                IArray1D iArr = data.getYArray();
                for (int j = 0; j < x.getLength(); ++j) {
                    intensities[index + j] = iArr.pointAt(j);
                }
            }
        } else {
            x = new EquidistantData(mFirst, mLast, mDim, emissionUnit);
            x.setLabel("Emission [" + emissionUnit + "]");
            y = new EquidistantData(xFirst, xLast, xDim, excitationUnit);
            y.setLabel("Excitation [" + excitationUnit + "]");
            intensities = new double[x.getLength() * y.getLength()];
            if (nPages != excitationDim) {
                log.warn((Object)"number of pages != excitation dimension, possible missing values");
            }
            for (int i3 = 0; i3 < nPages; ++i3) {
                int index;
                JCAMPNTuplePage page = block.getNTuple().getPage(i3);
                IArray2D data = page.getXYData();
                String excitationStr = page.getPageVariableValue(vars[excitationIndex].getSymbol());
                if (excitationStr == null) {
                    index = i3 * x.getLength();
                    log.warn((Object)"missing ##PAGE= excitation entry, assuming ordered pages");
                } else {
                    double excitation = Double.parseDouble(excitationStr);
                    index = y.indexAt(excitation);
                    index *= x.getLength();
                }
                IArray1D iArr = data.getYArray();
                for (int j = 0; j < x.getLength(); ++j) {
                    intensities[index + j] = iArr.pointAt(j);
                }
            }
        }
        Fluorescence2DSpectrum spectrum = new Fluorescence2DSpectrum(x, y, new ArrayData(intensities, intensityUnit));
        this.setNotes(block, spectrum);
        return spectrum;
    }

    private FluorescenceSpectrum createPeakTable(JCAMPBlock block) throws JCAMPException {
        Object[] tables;
        Object[] peaks;
        Unit yUnit;
        FluorescenceSpectrum spectrum = null;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.nanometerWavelength;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        if (nPoints != (peaks = (Peak1D[])(tables = this.getPeaktable(block, nPoints, xFactor, yFactor))[0]).length) {
            block.getErrorHandler().error("incorrect ##NPOINTS=: expected " + Integer.toString(nPoints) + " but got " + Integer.toString(peaks.length));
            nPoints = peaks.length;
        }
        Arrays.sort(peaks);
        double[] px = new double[nPoints];
        double[] py = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            px[i] = ((Peak)peaks[i]).getPosition()[0];
            py[i] = ((Peak)peaks[i]).getHeight();
        }
        OrderedArrayData x = new OrderedArrayData(px, xUnit);
        ArrayData y = new ArrayData(py, yUnit);
        spectrum = new FluorescenceSpectrum(x, y, false);
        spectrum.setPeakTable((Peak1D[])peaks);
        if (tables.length > 1) {
            spectrum.setPatternTable((Pattern[])tables[1]);
            if (tables.length > 2) {
                spectrum.setAssignments((Assignment[])tables[2]);
            }
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }

    @Override
    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 16) {
            block.getErrorHandler().fatal("JCAMP reader adapter missmatch");
        }
        if (block.isNTupleBlock()) {
            Fluorescence2DSpectrum spectrum = this.createFS2D(block);
            return spectrum;
        }
        FluorescenceSpectrum spectrum = null;
        JCAMPBlock.Type type = block.getType();
        if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
            spectrum = this.createFS(block);
        } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
            spectrum = this.createPeakTable(block);
        } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
            spectrum = this.createPeakTable(block);
        } else {
            block.getErrorHandler().fatal("illegal block type");
        }
        return spectrum;
    }
}

