/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ASDFDecoder;
import org.jcamp.parser.BlockIterator;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.ErrorHandlerAdapter;
import org.jcamp.parser.IErrorHandler;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuple;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.parser.LDRIterator;
import org.jcamp.parser.Utils;

public class JCAMPBlock {
    private ASDFDecoder asdfDecoder = new ASDFDecoder();
    private static Log log = LogFactory.getLog(JCAMPBlock.class);
    private static final IErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandlerAdapter(){

        @Override
        public void fatal(String msg) throws JCAMPException {
            log.fatal((Object)msg);
            throw new JCAMPException("FATAL ERROR! " + msg);
        }

        @Override
        public void error(String msg) throws JCAMPException {
            log.error((Object)msg);
            throw new JCAMPException("ERROR! " + msg);
        }

        @Override
        public void warn(String msg) throws JCAMPException {
            log.warn((Object)msg);
        }
    };
    private IErrorHandler errorHandler = DEFAULT_ERROR_HANDLER;
    private static final String CRLF = "\r\n";
    private final int start;
    private final int end;
    private final String jcamp;
    private final JCAMPBlock parent;
    private int numDataRecords;
    private Type type;
    private int spectrumID;
    private String data;
    private Hashtable childBlocks = new Hashtable(10);
    private Hashtable dataRecords = new Hashtable(50);
    private JCAMPDataRecord[] ldrs;
    private JCAMPBlock[] references = null;
    private boolean ntupleBlock = false;
    private JCAMPNTuple ntuple;
    private JCAMPVariable[] vars = null;
    private boolean isValidating = true;

    public JCAMPBlock(JCAMPBlock parent, String jcamp, int start, int end) throws JCAMPException {
        this.jcamp = jcamp;
        this.start = start;
        this.end = end;
        this.parent = parent;
        this.initBlocks();
        this.initLDRs();
        this.analyzeBlockType();
        this.initNTuple();
        this.initVariables();
    }

    public JCAMPBlock(JCAMPBlock parent, String jcamp, int start, int end, IErrorHandler errorHandler) throws JCAMPException {
        this.jcamp = jcamp;
        this.start = start;
        this.end = end;
        this.parent = parent;
        this.errorHandler = errorHandler;
        this.initBlocks();
        this.initLDRs();
        this.analyzeBlockType();
        this.initNTuple();
        this.initVariables();
    }

    public JCAMPBlock(String jcamp) throws JCAMPException {
        this(jcamp, 0, jcamp.length());
    }

    public JCAMPBlock(String jcamp, int start, int end) throws JCAMPException {
        this(null, jcamp, start, end);
    }

    public JCAMPBlock(String jcamp, int start, int end, IErrorHandler errorHandler) throws JCAMPException {
        this(null, jcamp, start, end, errorHandler);
    }

    public JCAMPBlock(String jcamp, IErrorHandler errorHandler) throws JCAMPException {
        this(jcamp, 0, jcamp.length(), errorHandler);
    }

    private void analyzeBlockType() throws JCAMPException {
        JCAMPDataRecord ldrJCAMPCS = this.getDataRecord("JCAMPCS");
        if (ldrJCAMPCS != null) {
            this.type = Type.STRUCTURE;
        } else {
            JCAMPDataRecord ldrDataType = this.getDataRecord("DATATYPE");
            if (ldrDataType == null) {
                throw new JCAMPException("missing ##DATATYPE=");
            }
            String dtype = ldrDataType.getContent().toUpperCase();
            if (dtype.indexOf("LINK") >= 0) {
                this.type = Type.LINK;
            } else if (dtype.indexOf("TABLE") >= 0) {
                this.type = Type.PEAKTABLE;
                this.analyzeSpectrumID(dtype);
            } else if (dtype.indexOf("ASSIGNMENT") >= 0) {
                this.type = Type.ASSIGNMENT;
                this.analyzeSpectrumID(dtype);
            } else if (dtype.indexOf("PARAMETER") >= 0) {
                this.type = Type.PARAMETER_VALUES;
            } else {
                this.type = Type.FULLSPECTRUM;
                this.analyzeSpectrumID(dtype);
                if (this.spectrumID == 64 && dtype.indexOf("CONTINUOUS") < 0) {
                    this.type = Type.PEAKTABLE;
                }
            }
        }
    }

    private void analyzeSpectrumID(String dataType) {
        if (dataType != null) {
            if ((dataType = dataType.toUpperCase()).indexOf("NMR") > -1) {
                this.spectrumID = 32;
            } else if (dataType.indexOf("MASS") > -1) {
                this.spectrumID = 64;
            } else if (dataType.indexOf("INFRARED") > -1) {
                this.spectrumID = 2;
            } else if (dataType.indexOf("IR") > -1) {
                this.spectrumID = 2;
            } else if (dataType.indexOf("UV") > -1) {
                this.spectrumID = 8;
            } else if (dataType.indexOf("ULTRAVIOLET") > -1) {
                this.spectrumID = 8;
            } else if (dataType.indexOf("RAMAN") > -1) {
                this.spectrumID = 4;
            } else if (dataType.indexOf("FLUORESCENCE") > -1) {
                this.spectrumID = 16;
            } else if (dataType.indexOf("CHROMATOGRAM") > -1) {
                this.spectrumID = 131072;
            }
        }
    }

    public String asSimpleJCAMP() {
        return this.data;
    }

    public JCAMPBlock changeDataRecord(String key, String newValue) throws JCAMPException {
        JCAMPDataRecord oldLDR = this.getDataRecord(key);
        if (oldLDR == null) {
            this.errorHandler.error("LDR \"##" + key + "=\" not found in block");
            return new JCAMPBlock(this.getJCAMP());
        }
        StringBuilder newJCAMP = new StringBuilder();
        if (oldLDR.getStart() > 0) {
            newJCAMP.append(this.jcamp.substring(0, oldLDR.getStart() - 1));
            if (newJCAMP.charAt(newJCAMP.length() - 1) != '\n') {
                newJCAMP.append(CRLF);
            }
        }
        newJCAMP.append("##").append(key).append("=").append(newValue);
        if (newJCAMP.charAt(newJCAMP.length() - 1) != '\n') {
            newJCAMP.append(CRLF);
        }
        if (oldLDR.getEnd() < this.jcamp.length() - 1) {
            newJCAMP.append(this.jcamp.substring(oldLDR.getEnd() + 1));
        }
        return new JCAMPBlock(newJCAMP.toString());
    }

    public JCAMPDataRecord[] getAllDataRecords() {
        return this.ldrs;
    }

    public ASDFDecoder getASDFDecoder() {
        return this.asdfDecoder;
    }

    public JCAMPBlock getBlock(int id) {
        return (JCAMPBlock)this.childBlocks.get(new Integer(id));
    }

    public Enumeration getBlocks() {
        return this.childBlocks.elements();
    }

    public JCAMPDataRecord getDataRecord(int index) {
        return this.ldrs[index];
    }

    public JCAMPDataRecord getDataRecord(String key) {
        return (JCAMPDataRecord)this.dataRecords.get(key);
    }

    public Enumeration getDataRecords() {
        return this.dataRecords.elements();
    }

    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public int getID() {
        JCAMPDataRecord ldr = (JCAMPDataRecord)this.dataRecords.get("BLOCKID");
        if (ldr == null) {
            return -1;
        }
        String blockID = ldr.getValue();
        String id = Utils.removeComments(blockID).trim();
        return Integer.parseInt(id);
    }

    public String getJCAMP() {
        return this.jcamp;
    }

    public JCAMPNTuple getNTuple() {
        return this.ntuple;
    }

    public JCAMPBlock[] getReferences() {
        if (this.references == null) {
            Vector<JCAMPBlock> refs = new Vector<JCAMPBlock>();
            if (this.parent == null) {
                this.references = new JCAMPBlock[0];
                return this.references;
            }
            JCAMPDataRecord xrefLDR = this.getDataRecord("CROSSREFERENCE");
            if (xrefLDR == null) {
                this.references = new JCAMPBlock[0];
                return this.references;
            }
            String xref = xrefLDR.getValue();
            xref = Utils.removeComments(xref).trim();
            StringTokenizer commaTokenizer = new StringTokenizer(xref, ",");
            while (commaTokenizer.hasMoreTokens()) {
                String token = commaTokenizer.nextToken().trim();
                try {
                    int ref = Integer.parseInt(token);
                    JCAMPBlock linkBlock = this.parent.getBlock(ref);
                    refs.addElement(linkBlock);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.references = new JCAMPBlock[refs.size()];
            for (int i = 0; i < refs.size(); ++i) {
                this.references[i] = (JCAMPBlock)refs.elementAt(i);
            }
        }
        return this.references;
    }

    public int getSpectrumID() {
        return this.spectrumID;
    }

    public Type getType() {
        return this.type;
    }

    public JCAMPVariable getVariable(String symbol) {
        if (this.isNTupleBlock()) {
            return this.ntuple.getVariable(symbol);
        }
        symbol = symbol.toUpperCase();
        for (int i = 0; i < this.vars.length; ++i) {
            if (!symbol.equals(this.vars[i].getSymbol())) continue;
            return this.vars[i];
        }
        return null;
    }

    public JCAMPVariable[] getVariables() {
        if (this.isNTupleBlock()) {
            return this.ntuple.getVariables();
        }
        return this.vars;
    }

    private void initBlocks() throws JCAMPException {
        int id = 0;
        StringBuilder tmp = new StringBuilder();
        BlockIterator blockIter = new BlockIterator(this.jcamp.substring(this.start, this.end));
        int o0 = this.start;
        while (blockIter.hasNext()) {
            int offset = blockIter.getOffset();
            int o1 = this.start + offset - 1;
            tmp.append(this.jcamp.substring(o0, o1));
            String block = blockIter.next();
            o0 = this.start + offset + block.length();
            JCAMPBlock jcampBlock = new JCAMPBlock(this, this.jcamp, ++o1, o0);
            int blockID = jcampBlock.getID();
            id = blockID < 0 ? --id : blockID;
            this.childBlocks.put(new Integer(id), jcampBlock);
        }
        tmp.append(this.jcamp.substring(o0, this.end));
        this.data = tmp.toString();
    }

    private void initLDRs() {
        LDRIterator ldrIter = new LDRIterator(this.data);
        int blockIndex = 0;
        ArrayList<JCAMPDataRecord> tmp = new ArrayList<JCAMPDataRecord>();
        while (ldrIter.hasNext()) {
            String ldr;
            int offset = ldrIter.getOffset();
            JCAMPDataRecord dataRecord = new JCAMPDataRecord(this.data, offset, offset + (ldr = ldrIter.next()).length(), blockIndex);
            JCAMPDataRecord ldrList = (JCAMPDataRecord)this.dataRecords.get(dataRecord.getKey());
            if (ldrList == null) {
                this.dataRecords.put(dataRecord.getKey(), dataRecord);
            } else {
                ldrList.listIterator().add(dataRecord);
            }
            tmp.add(dataRecord);
            ++blockIndex;
        }
        this.numDataRecords = blockIndex;
        this.ldrs = new JCAMPDataRecord[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            this.ldrs[i] = (JCAMPDataRecord)tmp.get(i);
        }
    }

    private void initNTuple() throws JCAMPException {
        JCAMPDataRecord endNTupleLDR;
        if (this.isStructureBlock()) {
            return;
        }
        JCAMPDataRecord startNTupleLDR = this.getDataRecord("NTUPLES");
        if (startNTupleLDR == null) {
            this.ntupleBlock = false;
            if (this.getDataRecord("SYMBOL") != null) {
                this.ntupleBlock = true;
                this.errorHandler.error("missing ##NTUPLES=");
            }
            if (this.getDataRecord("VARDIM") != null) {
                this.ntupleBlock = true;
                this.errorHandler.error("missing ##NTUPLES=");
            }
            if (!this.ntupleBlock) {
                return;
            }
        }
        if ((endNTupleLDR = this.getDataRecord("ENDNTUPLES")) == null) {
            this.errorHandler.error("missing ##END NTUPLES=");
        }
        this.ntuple = new JCAMPNTuple(this, startNTupleLDR, endNTupleLDR);
        this.ntupleBlock = true;
    }

    private Double parseDouble(String s) {
        try {
            return new Double(s);
        }
        catch (NumberFormatException e) {
            return new Double(s.replace(",", "."));
        }
    }

    private void initVariables() throws JCAMPException {
        if (this.isStructureBlock()) {
            return;
        }
        if (this.isNTupleBlock()) {
            return;
        }
        if (this.isLinkBlock()) {
            return;
        }
        if (this.type.equals(Type.PARAMETER_VALUES)) {
            return;
        }
        JCAMPDataRecord dataLDR = null;
        Enumeration records = this.getDataRecords();
        while (records.hasMoreElements()) {
            JCAMPDataRecord ldr = (JCAMPDataRecord)records.nextElement();
            if (!ldr.isData()) continue;
            if (dataLDR != null) {
                this.errorHandler.error("more than one data LDR in block: use compound JCAMP");
                break;
            }
            dataLDR = ldr;
        }
        if (dataLDR == null) {
            this.errorHandler.fatal("missing data LDR");
        }
        DataVariableInfo info = new DataVariableInfo(dataLDR);
        String[] symbols = info.getSymbols();
        JCAMPDataRecord ldr = this.getDataRecord("NPOINTS");
        if (ldr == null) {
            this.errorHandler.fatal("missing required label ##NPOINTS=");
        }
        int nPoints = Integer.parseInt(ldr.getContent());
        this.vars = new JCAMPVariable[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            String symbol = symbols[i].toUpperCase();
            JCAMPVariable v = new JCAMPVariable(symbol);
            if (i > 0) {
                v.setType(JCAMPVariable.Type.DEPENDENT);
            } else {
                v.setType(JCAMPVariable.Type.INDEPENDENT);
            }
            if (this.getType().equals(Type.FULLSPECTRUM)) {
                if (info.isIncremental()) {
                    v.setFormat(JCAMPVariable.Format.ASDF);
                } else {
                    v.setFormat(JCAMPVariable.Format.AFFN);
                }
            } else if (this.getType().equals(Type.PEAKTABLE) || this.getType().equals(Type.ASSIGNMENT)) {
                if (symbol.equals("X") || symbol.equals("Y") || symbol.equals("W")) {
                    v.setFormat(JCAMPVariable.Format.AFFN);
                } else {
                    v.setFormat(JCAMPVariable.Format.STRING);
                }
            }
            v.setDimension(nPoints);
            ldr = this.getDataRecord(symbol + "LABEL");
            if (ldr != null) {
                v.setLabel(ldr.getContent());
            }
            if ((ldr = this.getDataRecord(symbol + "UNITS")) != null) {
                v.setUnit(ldr.getContent());
            }
            if ((ldr = this.getDataRecord("FIRST" + symbol)) != null) {
                v.setFirst(this.parseDouble(ldr.getContent()));
            }
            if ((ldr = this.getDataRecord("LAST" + symbol)) != null) {
                v.setLast(this.parseDouble(ldr.getContent()));
            }
            if ((ldr = this.getDataRecord(symbol + "FACTOR")) != null) {
                v.setFactor(this.parseDouble(ldr.getContent()));
            }
            if ((ldr = this.getDataRecord("MIN" + symbol)) != null) {
                v.setMin(this.parseDouble(ldr.getContent()));
            }
            if ((ldr = this.getDataRecord("MAX" + symbol)) != null) {
                v.setMax(this.parseDouble(ldr.getContent()));
            }
            this.vars[i] = v;
        }
    }

    public boolean isLinkBlock() {
        return this.type.equals(Type.LINK);
    }

    public boolean isNTupleBlock() {
        return this.ntupleBlock;
    }

    public boolean isStructureBlock() {
        return this.type.equals(Type.STRUCTURE);
    }

    public static void main(String[] args) {
        String jcamp = null;
        try {
            File dxFile = new File(args[0]);
            FileReader dxIn = new FileReader(dxFile);
            if (dxIn != null) {
                int r;
                int size = (int)dxFile.length();
                int read = 0;
                char[] data = new char[size];
                do {
                    r = dxIn.read(data, read, size - read);
                    read += r;
                } while (r > 0);
                dxIn.close();
                jcamp = String.valueOf(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            JCAMPBlock block = new JCAMPBlock(jcamp);
            System.out.println("Block Data:\n" + block.data);
            System.out.println("Child Blocks: " + block.childBlocks.size());
        }
        catch (JCAMPException e) {
            e.printStackTrace();
        }
    }

    public int numBlocks() {
        return this.childBlocks.size();
    }

    public int numDataRecords() {
        return this.numDataRecords;
    }

    public int numVariables() {
        return this.vars.length;
    }

    public void setASDFDecoder(ASDFDecoder newAsdfDecoder) {
        this.asdfDecoder = newAsdfDecoder;
    }

    public void setErrorHandler(IErrorHandler newErrorHandler) {
        this.errorHandler = newErrorHandler;
    }

    public void setSpectrumID(int newSpectrumID) {
        this.spectrumID = newSpectrumID;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setValidating(boolean useCheckValues) {
        this.isValidating = useCheckValues;
        this.asdfDecoder.enableValidation(useCheckValues);
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = -8081269600789693382L;
        private final String key;
        private final int ordinal;
        public static final Type LINK = new Type(0, "link");
        public static final Type STRUCTURE = new Type(1, "structure");
        public static final Type FULLSPECTRUM = new Type(2, "full spectrum");
        public static final Type PEAKTABLE = new Type(3, "peak table");
        public static final Type ASSIGNMENT = new Type(4, "assignment");
        public static final Type PARAMETER_VALUES = new Type(5, "parameter values");
        private static final Type[] TYPES = new Type[]{LINK, STRUCTURE, FULLSPECTRUM, PEAKTABLE, ASSIGNMENT, PARAMETER_VALUES};
        private static final List TYPES_LIST = Collections.unmodifiableList(Arrays.asList(TYPES));

        private Type(int ordinal, String key) {
            this.ordinal = ordinal;
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public Collection types() {
            return TYPES_LIST;
        }

        private Object readResolve() throws ObjectStreamException {
            return TYPES[this.ordinal];
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public final boolean equals(Object obj) {
            return obj instanceof Type && (Type)obj == this;
        }
    }
}

