/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.ListIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.jcamp.parser.Utils;

public class JCAMPDataRecord {
    private static final String XYDATA_RE = "^([:alpha:][:digit:]*)([:alpha:][:digit:]*)DATA$";
    private static final String XYPOINTS_RE = "^([:alpha:][:digit:]*)([:alpha:][:digit:]*)POINTS$";
    private static final REProgram XYDATA_REPRG;
    private static final REProgram XYPOINTS_REPRG;
    private RE xyDataRE = new RE(XYDATA_REPRG);
    private RE xyPointsRE = new RE(XYPOINTS_REPRG);
    private boolean isData = false;
    private String key;
    private String value;
    private String content;
    private String jcamp;
    private int start;
    private int equalSignPos;
    private int end;
    private int index;
    private int blockIndex;
    private JCAMPDataRecord next = null;
    private JCAMPDataRecord prev = null;

    JCAMPDataRecord(String jcamp, int start, int end, int blockIndex) {
        this.jcamp = jcamp;
        this.start = start;
        this.end = end;
        this.next = null;
        this.prev = null;
        this.index = 0;
        this.blockIndex = blockIndex;
        String label = jcamp.substring(start, end);
        this.equalSignPos = label.indexOf(61);
        this.key = Utils.normalizeLabel(label.substring(2, this.equalSignPos));
        if (this.xyDataRE.match(this.key) || this.xyPointsRE.match(this.key) || this.key.equals("DATATABLE") || this.key.equals("PEAKTABLE") || this.key.equals("PEAKASSIGNMENTS")) {
            this.isData = true;
        }
    }

    JCAMPDataRecord(ListIterator list, String jcamp, int start, int end, int blockIndex) {
        this(jcamp, start, end, blockIndex);
        list.add(this);
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public String getComments() {
        return Utils.extractComments(this.getValue());
    }

    public String getContent() {
        if (this.content == null) {
            this.content = Utils.removeComments(this.getValue()).trim();
        }
        return this.content;
    }

    public int getEnd() {
        return this.end;
    }

    public int getFirstBlockIndex() {
        JCAMPDataRecord d = this.prev;
        while (d != null) {
            d = d.prev;
        }
        return d.blockIndex;
    }

    public String getKey() {
        return this.key;
    }

    public int getListIndex() {
        return this.index;
    }

    public String getOriginalKey() {
        return this.jcamp.substring(this.start + 2, this.start + this.equalSignPos);
    }

    public int getStart() {
        return this.start;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.jcamp.substring(this.start + this.equalSignPos + 1, this.end);
        }
        return this.value;
    }

    public boolean isData() {
        return this.isData;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public ListIterator listIterator() {
        return new Iterator(this);
    }

    static {
        try {
            RECompiler compiler = new RECompiler();
            XYDATA_REPRG = compiler.compile(XYDATA_RE);
            XYPOINTS_REPRG = compiler.compile(XYPOINTS_RE);
        }
        catch (RESyntaxException e) {
            throw new Error("bad RE in DataVariableInfo");
        }
    }

    class Iterator
    implements ListIterator {
        JCAMPDataRecord current;

        Iterator(JCAMPDataRecord current) {
            this.current = current;
        }

        public void add(Object o) {
            if (!(o instanceof JCAMPDataRecord)) {
                return;
            }
            JCAMPDataRecord newLDR = (JCAMPDataRecord)o;
            JCAMPDataRecord cLDR = this.current;
            while (cLDR.next != null) {
                cLDR = cLDR.next;
            }
            cLDR.next = newLDR;
            newLDR.prev = cLDR;
            newLDR.index = cLDR.index + 1;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != null;
        }

        @Override
        public Object next() {
            return this.current.next;
        }

        @Override
        public int nextIndex() {
            if (this.current.next != null) {
                return this.current.index + 1;
            }
            return -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.current.prev != null;
        }

        public Object previous() {
            return this.current.prev;
        }

        @Override
        public int previousIndex() {
            if (this.current.prev != null) {
                return this.current.index - 1;
            }
            return -1;
        }

        @Override
        public void remove() {
            JCAMPDataRecord p = this.current.prev;
            JCAMPDataRecord n = this.current.next;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
                n.index--;
                while (n.next != null) {
                    n = n.next;
                    n.index--;
                }
            }
        }

        public void set(Object o) {
            if (this.current == null) {
                return;
            }
            if (!(o instanceof JCAMPDataRecord)) {
                return;
            }
            JCAMPDataRecord s = (JCAMPDataRecord)o;
            JCAMPDataRecord p = this.current.prev;
            JCAMPDataRecord n = this.current.next;
            s.index = this.current.index;
            this.current.prev = (this.current.next = null);
            this.current.index = 0;
            s.prev = (s.next = null);
            this.current = s;
            if (p != null) {
                p.next = s;
                s.prev = p;
            }
            if (n != null) {
                n.prev = s;
                s.next = n;
            }
        }
    }
}

