/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Vector;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuplePage;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.parser.Utils;

public class JCAMPNTuple {
    private JCAMPDataRecord startLDR;
    private JCAMPDataRecord endLDR;
    private JCAMPBlock containingBlock;
    private JCAMPDataRecord[] headers;
    private JCAMPNTuplePage[] pages;
    private JCAMPVariable[] vars;
    private int numHeaders;
    private int firstIndex;
    private int lastIndex;

    JCAMPNTuple(JCAMPBlock block, JCAMPDataRecord startLDR, JCAMPDataRecord endLDR) throws JCAMPException {
        this.containingBlock = block;
        this.startLDR = startLDR;
        this.endLDR = endLDR;
        this.initialize();
    }

    public JCAMPBlock getBlock() {
        return this.containingBlock;
    }

    public JCAMPDataRecord getHeader(String key) {
        if (this.headers != null) {
            for (int i = 0; i < this.headers.length; ++i) {
                if (!key.equals(this.headers[i].getKey())) continue;
                return this.headers[i];
            }
        }
        return null;
    }

    public JCAMPDataRecord[] getHeaders() {
        return this.headers;
    }

    public String getJCAMP() {
        return this.containingBlock.getJCAMP();
    }

    public JCAMPNTuplePage getPage(int index) {
        if (this.pages != null) {
            return this.pages[index];
        }
        return null;
    }

    public JCAMPNTuplePage[] getPages() {
        return this.pages;
    }

    public JCAMPVariable getVariable(String symbol) {
        symbol = symbol.toUpperCase();
        for (int i = 0; i < this.vars.length; ++i) {
            if (!symbol.equals(this.vars[i].getSymbol())) continue;
            return this.vars[i];
        }
        return null;
    }

    public JCAMPVariable getVariableByName(String name) {
        name = name.toUpperCase();
        for (int i = 0; i < this.vars.length; ++i) {
            if (!name.equals(this.vars[i].getName())) continue;
            return this.vars[i];
        }
        return null;
    }

    public JCAMPVariable[] getVariables() {
        return this.vars;
    }

    public String[] getVariableValues(String ldrKey, JCAMPVariable v) {
        String[] values = new String[this.numPages()];
        for (int i = 0; i < this.numPages(); ++i) {
            JCAMPDataRecord ldr = this.pages[i].getDataRecord(ldrKey);
            if (ldr == null) {
                if (v != null) {
                    values[i] = this.pages[i].getPageVariableValue(v.getSymbol());
                    continue;
                }
                values[i] = null;
                continue;
            }
            values[i] = ldr.getContent();
        }
        return values;
    }

    private void initHeaders() {
        JCAMPDataRecord[] blockLDR = this.containingBlock.getAllDataRecords();
        this.numHeaders = 0;
        for (int i = this.firstIndex; i <= this.lastIndex && !blockLDR[i].getKey().equals("PAGE"); ++i) {
            ++this.numHeaders;
        }
        this.headers = new JCAMPDataRecord[this.numHeaders];
        System.arraycopy(blockLDR, this.firstIndex, this.headers, 0, this.numHeaders);
    }

    private void initialize() throws JCAMPException {
        this.firstIndex = this.startLDR.getBlockIndex() + 1;
        this.lastIndex = this.endLDR.getBlockIndex() - 1;
        if (this.firstIndex > this.lastIndex) {
            return;
        }
        this.initHeaders();
        this.initVariables();
        this.initPages();
    }

    private void initPages() throws JCAMPException {
        int i;
        JCAMPDataRecord[] blockLDR = this.containingBlock.getAllDataRecords();
        JCAMPDataRecord page1 = blockLDR[this.firstIndex + this.numHeaders];
        JCAMPDataRecord page2 = null;
        Vector<JCAMPNTuplePage> tmp = new Vector<JCAMPNTuplePage>();
        for (i = this.firstIndex + this.numHeaders + 1; i < this.lastIndex; ++i) {
            if (!blockLDR[i].getKey().equals("PAGE")) continue;
            page2 = blockLDR[i - 1];
            JCAMPNTuplePage ntuplePage = new JCAMPNTuplePage(this, page1, page2);
            tmp.addElement(ntuplePage);
            page1 = blockLDR[i];
        }
        if (page1 != null) {
            JCAMPNTuplePage ntuplePage = new JCAMPNTuplePage(this, page1, blockLDR[this.lastIndex]);
            tmp.addElement(ntuplePage);
        }
        this.pages = new JCAMPNTuplePage[tmp.size()];
        for (i = 0; i < this.pages.length; ++i) {
            this.pages[i] = (JCAMPNTuplePage)tmp.elementAt(i);
        }
    }

    private void initVariables() throws JCAMPException {
        int i;
        JCAMPDataRecord ldr = this.getHeader("SYMBOL");
        if (ldr == null) {
            throw new JCAMPException("missing variable declaration in NTUPLES");
        }
        String[] symbols = Utils.splitStringCSV(ldr.getContent());
        this.vars = new JCAMPVariable[symbols.length];
        for (int i2 = 0; i2 < this.vars.length; ++i2) {
            this.vars[i2] = new JCAMPVariable(symbols[i2].toUpperCase());
        }
        ldr = this.getHeader("VARNAME");
        if (ldr != null) {
            String[] labels = Utils.splitStringCSV(ldr.getContent());
            if (labels.length != this.vars.length) {
                throw new JCAMPException("bad ##VARNAME=: number of name entries != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setLabel(labels[i]);
                this.vars[i].setName(Utils.normalizeLabel(labels[i]));
            }
        }
        if ((ldr = this.getHeader("VARTYPE")) != null) {
            String[] types = Utils.splitStringCSV(ldr.getContent());
            if (types.length != this.vars.length) {
                throw new JCAMPException("bad ##VARTYPE=: number of type entries != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                if (types[i].equalsIgnoreCase("INDEPENDENT")) {
                    this.vars[i].setType(JCAMPVariable.Type.INDEPENDENT);
                    continue;
                }
                if (types[i].equalsIgnoreCase("DEPENDENT")) {
                    this.vars[i].setType(JCAMPVariable.Type.DEPENDENT);
                    continue;
                }
                if (!types[i].equalsIgnoreCase("PAGE")) continue;
                this.vars[i].setType(JCAMPVariable.Type.PAGE);
            }
        }
        if ((ldr = this.getHeader("VARFORM")) != null) {
            String[] forms = Utils.splitStringCSV(ldr.getContent());
            if (forms.length != this.vars.length) {
                throw new JCAMPException("bad ##VARFORM=: number of varform entries != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                if ("AFFN".equalsIgnoreCase(forms[i])) {
                    this.vars[i].setFormat(JCAMPVariable.Format.AFFN);
                    continue;
                }
                if ("ASDF".equalsIgnoreCase(forms[i])) {
                    this.vars[i].setFormat(JCAMPVariable.Format.ASDF);
                    continue;
                }
                if ("STRING".equalsIgnoreCase(forms[i])) {
                    this.vars[i].setFormat(JCAMPVariable.Format.STRING);
                    continue;
                }
                this.vars[i].setFormat(JCAMPVariable.Format.TEXT);
            }
        }
        if ((ldr = this.getHeader("VARDIM")) != null) {
            String[] dims = Utils.splitStringCSV(ldr.getContent());
            if (dims.length != this.vars.length) {
                throw new JCAMPException("bad ##VARDIM=: number of dimension entries != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setDimension(Integer.parseInt(dims[i]));
            }
        }
        if ((ldr = this.getHeader("FIRST")) != null) {
            String[] firsts = Utils.splitStringCSV(ldr.getContent());
            if (firsts.length != this.vars.length) {
                throw new JCAMPException("bad ##FIRST=: number of first values != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setFirst(new Double(firsts[i]));
            }
        }
        if ((ldr = this.getHeader("LAST")) != null) {
            String[] lasts = Utils.splitStringCSV(ldr.getContent());
            if (lasts.length != this.vars.length) {
                throw new JCAMPException("bad ##LAST=: number of last values != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setLast(new Double(lasts[i]));
            }
        }
        if ((ldr = this.getHeader("MIN")) != null) {
            String[] mins = Utils.splitStringCSV(ldr.getContent());
            if (mins.length != this.vars.length) {
                throw new JCAMPException("bad ##MIN=: number of min values != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setMin(new Double(mins[i]));
            }
        }
        if ((ldr = this.getHeader("MAX")) != null) {
            String[] maxs = Utils.splitStringCSV(ldr.getContent());
            if (maxs.length != this.vars.length) {
                throw new JCAMPException("bad ##MAX=: number of max values != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setMax(new Double(maxs[i]));
            }
        }
        if ((ldr = this.getHeader("FACTOR")) != null) {
            String[] factors = Utils.splitStringCSV(ldr.getContent());
            if (factors.length != this.vars.length) {
                throw new JCAMPException("bad ##FACTOR=: number of factor values != number of variables");
            }
            for (i = 0; i < this.vars.length; ++i) {
                this.vars[i].setFactor(new Double(factors[i]));
            }
        }
        if ((ldr = this.getHeader("UNITS")) != null) {
            String[] units = Utils.splitStringCSV(ldr.getContent());
            if (units.length != this.vars.length) {
                throw new JCAMPException("bad ##UNITS=: number of unit entries != number of variables");
            }
            for (i = 0; i < units.length; ++i) {
                this.vars[i].setUnit(units[i]);
            }
        }
    }

    public int numHeaders() {
        return this.numHeaders;
    }

    public int numPages() {
        if (this.pages == null) {
            return 0;
        }
        return this.pages.length;
    }
}

