/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.jcamp.math.Array1D;
import org.jcamp.math.IArray2D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.OrderedArray1D;
import org.jcamp.math.XYArray2D;
import org.jcamp.parser.AFFNGroup;
import org.jcamp.parser.AFFNTokenizer;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuple;
import org.jcamp.parser.JCAMPVariable;

public class JCAMPNTuplePage {
    private static final String VAR_RE = "([:alpha:][:digit:]*)[:space:]*=";
    private static final String CONTENT_RE = "[:alpha:][:digit:]*[:space:]*=([^,]*)";
    private static final REProgram VAR_REPRG;
    private static final REProgram CONTENT_REPRG;
    private RE contentRE = new RE(CONTENT_REPRG);
    private RE varRE = new RE(VAR_REPRG);
    private JCAMPDataRecord startLDR;
    private JCAMPDataRecord endLDR;
    private JCAMPNTuple ntuple;
    private String[] symbols;
    private String[] values;
    private JCAMPDataRecord dataLDR;
    private DataVariableInfo varInfo;
    private JCAMPVariable xVar;
    private JCAMPVariable yVar;

    JCAMPNTuplePage(JCAMPNTuple ntuple, JCAMPDataRecord startLDR, JCAMPDataRecord endLDR) throws JCAMPException {
        this.startLDR = startLDR;
        this.endLDR = endLDR;
        this.ntuple = ntuple;
        this.init();
    }

    private void analyzeContent(String varlist) {
        this.values = new String[this.symbols.length];
        int pos = 0;
        int i = 0;
        while (this.contentRE.match(varlist, pos)) {
            String value = varlist.substring(this.contentRE.getParenStart(1), this.contentRE.getParenEnd(1));
            this.values[i] = value.trim();
            pos += this.contentRE.getParenLength(0);
            ++i;
        }
    }

    private void analyzeVars(String varlist) throws JCAMPException {
        ArrayList<String> tmp = new ArrayList<String>();
        int pos = 0;
        while (this.varRE.match(varlist, pos)) {
            String symbol = varlist.substring(this.varRE.getParenStart(1), this.varRE.getParenEnd(1));
            tmp.add(symbol.toUpperCase());
            pos += this.varRE.getParenLength(0);
        }
        this.symbols = new String[tmp.size()];
        for (int i = 0; i < this.symbols.length; ++i) {
            this.symbols[i] = (String)tmp.get(i);
        }
        JCAMPBlock block = this.ntuple.getBlock();
        this.dataLDR = this.getDataRecord("DATATABLE");
        if (this.dataLDR == null) {
            block.getErrorHandler().fatal("missing required label ##DATATABLE=");
        }
        this.varInfo = new DataVariableInfo(this.dataLDR);
        if (this.varInfo.getSymbols().length != 2) {
            block.getErrorHandler().error("page ##DATATABLE= must be 2 dimensional");
        }
        this.xVar = this.ntuple.getVariable(this.varInfo.getSymbols()[0]);
        this.yVar = this.ntuple.getVariable(this.varInfo.getSymbols()[1]);
    }

    public JCAMPDataRecord getDataRecord(String key) {
        JCAMPDataRecord[] ldrs = this.ntuple.getBlock().getAllDataRecords();
        for (int i = this.startLDR.getBlockIndex(); i <= this.endLDR.getBlockIndex(); ++i) {
            if (!ldrs[i].getKey().equals(key)) continue;
            return ldrs[i];
        }
        return null;
    }

    public JCAMPDataRecord[] getDataRecords() {
        int n = this.startLDR.getBlockIndex() - this.endLDR.getBlockIndex() + 1;
        JCAMPDataRecord[] blockLDRs = this.ntuple.getBlock().getAllDataRecords();
        JCAMPDataRecord[] ldrs = new JCAMPDataRecord[n];
        System.arraycopy(blockLDRs, this.startLDR.getBlockIndex(), ldrs, 0, n);
        return ldrs;
    }

    public String[] getDatatableVariableSymbols() {
        return this.varInfo.getSymbols();
    }

    public JCAMPNTuple getNTuple() {
        return this.ntuple;
    }

    public String[] getPageVariableSymbols() {
        return this.symbols;
    }

    public String getPageVariableValue(String symbol) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].equals(symbol)) continue;
            return this.values[i];
        }
        return null;
    }

    public String[] getPageVariableValues() {
        return this.values;
    }

    public IArray2D getXYData() throws JCAMPException {
        double yFactor;
        XYArray2D data = null;
        JCAMPBlock block = this.ntuple.getBlock();
        double xFactor = this.xVar.getFactor() == null ? 1.0 : this.xVar.getFactor();
        double d = yFactor = this.xVar.getFactor() == null ? 1.0 : this.yVar.getFactor();
        if (this.varInfo.isIncremental()) {
            int xDim;
            double xLast;
            double xFirst;
            String xSym = this.xVar.getSymbol().toUpperCase();
            JCAMPDataRecord ldrFirstX = this.getDataRecord("FIRST" + xSym);
            if (ldrFirstX != null) {
                xFirst = Double.parseDouble(ldrFirstX.getContent());
            } else {
                if (this.xVar.getFirst() == null) {
                    block.getErrorHandler().fatal("missing first value for incremental variable " + this.xVar.getSymbol());
                }
                xFirst = this.xVar.getFirst();
            }
            JCAMPDataRecord ldrLastX = this.getDataRecord("LAST" + xSym);
            if (ldrLastX != null) {
                xLast = Double.parseDouble(ldrLastX.getContent());
            } else {
                if (this.xVar.getLast() == null) {
                    block.getErrorHandler().fatal("missing last value for incremental variable " + this.xVar.getSymbol());
                }
                xLast = this.xVar.getLast();
            }
            JCAMPDataRecord ldrNPoints = this.getDataRecord("NPOINTS");
            if (ldrNPoints != null) {
                xDim = Integer.parseInt(ldrNPoints.getContent());
            } else {
                if (this.xVar.getDimension() == null) {
                    block.getErrorHandler().fatal("missing dimension for incremental variable " + this.xVar.getSymbol());
                }
                xDim = this.xVar.getDimension();
            }
            double[] y = block.getASDFDecoder().decode(this.dataLDR, xFirst, xLast, xFactor, xDim);
            int n = y.length;
            if (n != xDim) {
                block.getErrorHandler().error("data dimension missmatch");
            }
            double[] yValues = new double[n];
            for (int i = 0; i < n; ++i) {
                yValues[i] = yFactor * y[i];
            }
            data = new XYArray2D(new LinearGrid1D(xFirst, xLast, xDim), new Array1D(yValues));
        } else {
            boolean duplicateFound;
            ArrayList<double[]> xyVec = new ArrayList<double[]>(20);
            AFFNTokenizer tokenizer = new AFFNTokenizer(this.dataLDR);
            while (tokenizer.hasMoreGroups()) {
                AFFNGroup group = tokenizer.nextGroup();
                double[] xyElem = new double[]{group.getValue(0), group.getValue(1)};
                xyVec.add(xyElem);
            }
            Collections.sort(xyVec, new Comparator(){

                public int compare(Object o1, Object o2) {
                    double[] xy1 = (double[])o1;
                    double[] xy2 = (double[])o2;
                    if (xy1[0] < xy2[0]) {
                        return -1;
                    }
                    if (xy1[0] > xy2[0]) {
                        return 1;
                    }
                    return 0;
                }
            });
            int start = 1;
            do {
                int index;
                duplicateFound = false;
                for (index = start; index < xyVec.size(); ++index) {
                    double[] xy2 = (double[])xyVec.get(index);
                    double[] xy1 = (double[])xyVec.get(index - 1);
                    if (xy1[0] != xy2[0]) continue;
                    duplicateFound = true;
                    xyVec.remove(index);
                }
                start = index;
            } while (duplicateFound);
            double[] x = new double[xyVec.size()];
            double[] y = new double[xyVec.size()];
            int i = 0;
            while (i < xyVec.size()) {
                x[i] = ((double[])xyVec.get(i))[0];
                int n = i;
                x[n] = x[n] * xFactor;
                y[i] = ((double[])xyVec.get(i))[1];
                int n2 = i++;
                y[n2] = y[n2] * yFactor;
            }
            data = new XYArray2D(new OrderedArray1D(x), new Array1D(y));
        }
        return data;
    }

    private void init() throws JCAMPException {
        String pageContent = this.startLDR.getContent();
        this.analyzeVars(pageContent);
        this.analyzeContent(pageContent);
    }

    static {
        try {
            RECompiler compiler = new RECompiler();
            VAR_REPRG = compiler.compile(VAR_RE);
            CONTENT_REPRG = compiler.compile(CONTENT_RE);
        }
        catch (RESyntaxException e) {
            throw new Error("bad RE in DataVariableInfo");
        }
    }
}

