/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ChromatogramJCAMPReader;
import org.jcamp.parser.ErrorHandlerAdapter;
import org.jcamp.parser.FluorescenceJCAMPReader;
import org.jcamp.parser.IErrorHandler;
import org.jcamp.parser.IRJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.MSJCAMPReader;
import org.jcamp.parser.NMRJCAMPReader;
import org.jcamp.parser.RamanJCAMPReader;
import org.jcamp.parser.UVJCAMPReader;
import org.jcamp.spectrum.Spectrum;

public class JCAMPReader {
    private static Log log = LogFactory.getLog(JCAMPReader.class);
    private static final IErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandlerAdapter(){

        @Override
        public void fatal(String msg) throws JCAMPException {
            log.fatal((Object)msg);
            throw new JCAMPException("FATAL ERROR! " + msg);
        }

        @Override
        public void error(String msg) throws JCAMPException {
            log.error((Object)msg);
            throw new JCAMPException("ERROR! " + msg);
        }

        @Override
        public void warn(String msg) throws JCAMPException {
            log.warn((Object)msg);
        }
    };
    private IErrorHandler errorHandler = DEFAULT_ERROR_HANDLER;
    private static JCAMPReader theInstance = null;
    private static Hashtable adapters = new Hashtable(20);
    private static boolean isValidating = true;
    private static String mode = "strict";
    private JCAMPBlock rootblock = null;
    private int idoffirstspectrum = -1;
    public static final String STRICT = "strict";
    public static final String RELAXED = "relaxed";

    public JCAMPBlock getRootblock() {
        return this.rootblock;
    }

    public int getIdoffirstspectrum() {
        return this.idoffirstspectrum;
    }

    private JCAMPReader(boolean isValidating, String mode) {
        JCAMPReader.isValidating = isValidating;
        JCAMPReader.mode = mode;
    }

    private JCAMPReader() {
    }

    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        ISpectrumJCAMPReader reader;
        if (block.isLinkBlock()) {
            this.errorHandler.warn("compound JCAMP encountered: using first spectrum block");
            this.rootblock = block;
            block = this.findFirstSpectrumBlock(block);
        }
        if ((reader = this.findAdapter(block.getSpectrumID())) == null) {
            this.errorHandler.fatal("spectrum type not implemented");
        }
        return reader.createSpectrum(block);
    }

    public Spectrum createSpectrum(JCAMPBlock block, int blockID) throws JCAMPException {
        return this.createSpectrum(block.getBlock(blockID));
    }

    public Spectrum createSpectrum(Reader reader) throws IOException, JCAMPException {
        StringBuilder fileData = new StringBuilder();
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        return this.createSpectrum(fileData.toString());
    }

    public Spectrum createSpectrum(String jcamp) throws JCAMPException {
        JCAMPBlock block = new JCAMPBlock(jcamp, this.errorHandler);
        block.setValidating(isValidating);
        return this.createSpectrum(block);
    }

    private ISpectrumJCAMPReader findAdapter(int spectrumID) {
        ISpectrumJCAMPReader adapter = (ISpectrumJCAMPReader)adapters.get(new Integer(spectrumID));
        return adapter;
    }

    private JCAMPBlock findFirstSpectrumBlock(JCAMPBlock block) throws JCAMPException {
        JCAMPBlock b;
        Enumeration blocks = block.getBlocks();
        if (blocks != null) {
            while (blocks.hasMoreElements()) {
                String dataType;
                JCAMPDataRecord dataTypeLDR;
                b = (JCAMPBlock)blocks.nextElement();
                if (b.isStructureBlock() || b.isLinkBlock() || (dataTypeLDR = b.getDataRecord("DATATYPE")) == null || (dataType = dataTypeLDR.getContent().toUpperCase()).endsWith("TABLE") || dataType.endsWith("ASSIGNMENTS")) continue;
                this.idoffirstspectrum = b.getID();
                return b;
            }
        }
        if ((blocks = block.getBlocks()) != null) {
            while (blocks.hasMoreElements()) {
                b = (JCAMPBlock)blocks.nextElement();
                if (b.isStructureBlock() || b.isLinkBlock()) continue;
                return b;
            }
        }
        this.errorHandler.fatal("link block contains no spectrum block");
        return null;
    }

    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public static JCAMPReader getInstance() {
        if (theInstance == null || !isValidating || mode != STRICT) {
            theInstance = new JCAMPReader(true, STRICT);
            JCAMPReader.initAdapters();
        }
        return theInstance;
    }

    public static JCAMPReader getInstance(boolean isValidating, String mode) {
        if (theInstance == null || JCAMPReader.isValidating != isValidating || JCAMPReader.mode != mode) {
            theInstance = new JCAMPReader(isValidating, mode);
            JCAMPReader.initAdapters();
        }
        return theInstance;
    }

    private static void initAdapters() {
        adapters.put(new Integer(32), new NMRJCAMPReader(mode));
        adapters.put(new Integer(2), new IRJCAMPReader());
        adapters.put(new Integer(8), new UVJCAMPReader());
        adapters.put(new Integer(64), new MSJCAMPReader());
        adapters.put(new Integer(4), new RamanJCAMPReader());
        adapters.put(new Integer(131072), new ChromatogramJCAMPReader());
        adapters.put(new Integer(16), new FluorescenceJCAMPReader());
    }

    public void setErrorHandler(IErrorHandler newErrorHandler) {
        this.errorHandler = newErrorHandler;
    }
}

