/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jcamp.units.Unit;

public class JCAMPVariable
implements Serializable {
    private static final long serialVersionUID = 938385277121903673L;
    private String symbol;
    private Format format;
    private String label;
    private String name;
    private Unit unit;
    private Type type = Type.INDEPENDENT;
    private Double min;
    private Double max;
    private Double factor;
    private Double first;
    private Double last;
    private Integer dim;

    JCAMPVariable(String symbol) {
        this.setSymbol(symbol);
    }

    public Integer getDimension() {
        return this.dim;
    }

    public Double getFactor() {
        return this.factor;
    }

    public Double getFirst() {
        return this.first;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getLast() {
        return this.last;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMin() {
        return this.min;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Type getType() {
        return this.type;
    }

    public Unit getUnit() {
        return this.unit;
    }

    void setDimension(int newDim) {
        this.dim = new Integer(newDim);
    }

    void setDimension(Integer newDim) {
        this.dim = newDim;
    }

    void setFactor(double newFactor) {
        this.factor = new Double(newFactor);
    }

    void setFactor(Double newFactor) {
        this.factor = newFactor;
    }

    void setFirst(double newFirst) {
        this.first = new Double(newFirst);
    }

    void setFirst(Double newFirst) {
        this.first = newFirst;
    }

    void setFormat(Format newFormat) {
        this.format = newFormat;
    }

    void setLabel(String newLabel) {
        this.label = newLabel;
    }

    void setLast(double newLast) {
        this.last = new Double(newLast);
    }

    void setLast(Double newLast) {
        this.last = newLast;
    }

    void setMax(double newMax) {
        this.max = new Double(newMax);
    }

    void setMax(Double newMax) {
        this.max = newMax;
    }

    void setMin(double newMin) {
        this.min = new Double(newMin);
    }

    void setMin(Double newMin) {
        this.min = newMin;
    }

    void setName(String newName) {
        this.name = newName;
    }

    void setSymbol(String newSymbol) {
        this.symbol = newSymbol.toUpperCase();
    }

    void setType(Type newType) {
        this.type = newType;
    }

    void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    void setUnit(String newUnit) {
        this.unit = Unit.getUnitFromString(newUnit);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(this.getSymbol());
        tmp.append(": ");
        tmp.append(this.type);
        if (this.type.equals(Type.INDEPENDENT) && this.first != null && this.last != null) {
            tmp.append(" from=").append(this.first);
            tmp.append(" to=").append(this.last);
        }
        if (this.factor != null) {
            tmp.append(" factor=").append(this.factor);
        }
        if (this.unit != null) {
            tmp.append(" unit=").append(this.unit);
        }
        return tmp.toString();
    }

    static final class Type
    implements Serializable {
        private static final long serialVersionUID = -3532511713669747894L;
        private final String key;
        private final int ordinal;
        public static final Type INDEPENDENT = new Type(0, "independent");
        public static final Type DEPENDENT = new Type(1, "dependent");
        public static final Type PAGE = new Type(1, "page");
        private static final Type[] TYPES = new Type[]{INDEPENDENT, DEPENDENT, PAGE};
        private static final List TYPES_LIST = Collections.unmodifiableList(Arrays.asList(TYPES));

        private Type(int ordinal, String key) {
            this.ordinal = ordinal;
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public Collection types() {
            return TYPES_LIST;
        }

        private Object readResolve() throws ObjectStreamException {
            return TYPES[this.ordinal];
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public final boolean equals(Object obj) {
            return obj instanceof Type && (Type)obj == this;
        }
    }

    static final class Format
    implements Serializable {
        private static final long serialVersionUID = 7347848828554403326L;
        private final String key;
        private final int ordinal;
        public static final Format TEXT = new Format(0, "TEXT");
        public static final Format STRING = new Format(1, "STRING");
        public static final Format AFFN = new Format(2, "AFFN");
        public static final Format ASDF = new Format(3, "ASDF");
        private static final Format[] FORMATS = new Format[]{TEXT, STRING, AFFN, ASDF};
        private static final List FORMATS_LIST = Collections.unmodifiableList(Arrays.asList(FORMATS));

        private Format(int ordinal, String key) {
            this.ordinal = ordinal;
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public Collection formats() {
            return FORMATS_LIST;
        }

        private Object readResolve() throws ObjectStreamException {
            return FORMATS[this.ordinal];
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public final boolean equals(Object obj) {
            return obj instanceof Format && (Format)obj == this;
        }
    }
}

