/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Hashtable;
import org.jcamp.parser.FluorescenceJCAMPWriter;
import org.jcamp.parser.IRJCAMPWriter;
import org.jcamp.parser.ISpectrumJCAMPWriter;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.MSJCAMPWriter;
import org.jcamp.parser.NMRJCAMPWriter;
import org.jcamp.parser.RamanJCAMPWriter;
import org.jcamp.parser.UVJCAMPWriter;
import org.jcamp.spectrum.FluorescenceSpectrum;
import org.jcamp.spectrum.IRSpectrum;
import org.jcamp.spectrum.MassSpectrum;
import org.jcamp.spectrum.NMRSpectrum;
import org.jcamp.spectrum.RamanSpectrum;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.UVSpectrum;

public class JCAMPWriter {
    private static JCAMPWriter theInstance = null;
    private static Hashtable adapters = new Hashtable(10);

    private JCAMPWriter() {
    }

    private ISpectrumJCAMPWriter findAdapter(Spectrum spectrum) {
        ISpectrumJCAMPWriter writer = null;
        for (Class<?> spectrumClass = spectrum.getClass(); writer == null && spectrumClass != null; spectrumClass = spectrumClass.getSuperclass()) {
            writer = (ISpectrumJCAMPWriter)adapters.get(spectrumClass);
        }
        return writer;
    }

    public static JCAMPWriter getInstance() {
        if (theInstance == null) {
            theInstance = new JCAMPWriter();
            JCAMPWriter.initAdapters();
        }
        return theInstance;
    }

    private static void initAdapters() {
        adapters.put(NMRSpectrum.class, new NMRJCAMPWriter());
        adapters.put(IRSpectrum.class, new IRJCAMPWriter());
        adapters.put(RamanSpectrum.class, new RamanJCAMPWriter());
        adapters.put(UVSpectrum.class, new UVJCAMPWriter());
        adapters.put(MassSpectrum.class, new MSJCAMPWriter());
        adapters.put(FluorescenceSpectrum.class, new FluorescenceJCAMPWriter());
    }

    public String toJCAMP(Spectrum spectrum) throws JCAMPException {
        ISpectrumJCAMPWriter adapter = this.findAdapter(spectrum);
        if (adapter == null) {
            throw new JCAMPException("cannot write JCAMP for " + spectrum.getClass());
        }
        return adapter.toJCAMP(spectrum);
    }

    public String toSimpleJCAMP(Spectrum spectrum) throws JCAMPException {
        ISpectrumJCAMPWriter adapter = this.findAdapter(spectrum);
        if (adapter == null) {
            throw new JCAMPException("cannot write JCAMP for " + spectrum.getClass());
        }
        return adapter.toSimpleJCAMP(spectrum);
    }
}

