/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.jcamp.parser.IStringIterator;

public class LabelIterator
implements IStringIterator {
    private static String labelRegExp = "^##[^=\\n\\r]*=";
    private static RECompiler compiler = new RECompiler();
    private REProgram labelProgram = null;
    private RE labelRE;
    private int offset;
    private String jcamp;

    public LabelIterator(String jcamp) {
        try {
            this.labelProgram = compiler.compile(labelRegExp);
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
        }
        this.labelRE = new RE(this.labelProgram, 3);
        this.offset = 0;
        this.jcamp = jcamp;
    }

    @Override
    public int getOffset() {
        if (this.jcamp == null) {
            return -1;
        }
        if (this.labelRE.match(this.jcamp, this.offset)) {
            return this.labelRE.getParenStart(0);
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        if (this.jcamp == null) {
            return false;
        }
        return this.labelRE.match(this.jcamp, this.offset);
    }

    @Override
    public String next() {
        if (this.jcamp == null) {
            return null;
        }
        int startMatch = this.offset;
        int endMatch = 0;
        if (this.labelRE.match(this.jcamp, startMatch)) {
            String match = this.labelRE.getParen(0);
            startMatch = this.labelRE.getParenStart(0);
            endMatch = this.labelRE.getParenEnd(0);
            this.offset = endMatch + 1;
            return match;
        }
        return null;
    }
}

