/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LineTokenizer
implements Enumeration {
    private static final int CONV_NONE = 0;
    private static final int CONV_LF = 1;
    private static final int CONV_CR = 2;
    private static final int CONV_CRLF = 3;
    private final String text;
    private final int length;
    private final int convention;
    private int pos = 0;

    public LineTokenizer(String text) {
        this.text = text;
        this.length = text.length();
        this.convention = this.guessConvention();
    }

    public int getPosition() {
        return this.pos < this.length ? this.pos : -1;
    }

    private int guessConvention() {
        int lf = this.text.indexOf("\r\n");
        if (lf < 0) {
            lf = this.text.indexOf("\n");
            if (lf < 0) {
                lf = this.text.indexOf("\r");
                if (lf < 0) {
                    return 0;
                }
                return 2;
            }
            return 1;
        }
        return 3;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreLines();
    }

    public boolean hasMoreLines() {
        return this.pos < this.length;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreLines();
    }

    public Object nextElement() {
        return this.nextLine();
    }

    public String nextLine() {
        String line = "";
        if (this.pos >= this.length) {
            throw new NoSuchElementException();
        }
        switch (this.convention) {
            case 2: {
                int p = this.text.indexOf("\r", this.pos);
                if (p < 0) {
                    line = this.text.substring(this.pos);
                    this.pos = this.length;
                    break;
                }
                line = this.text.substring(this.pos, p);
                this.pos = p + 1;
                break;
            }
            case 1: {
                int p = this.text.indexOf("\n", this.pos);
                if (p < 0) {
                    line = this.text.substring(this.pos);
                    this.pos = this.length;
                    break;
                }
                line = this.text.substring(this.pos, p);
                this.pos = p + 1;
                break;
            }
            case 3: {
                int p = this.text.indexOf("\r\n", this.pos);
                if (p < 0) {
                    line = this.text.substring(this.pos);
                    this.pos = this.length;
                    break;
                }
                line = this.text.substring(this.pos, p);
                this.pos = p + 2;
                break;
            }
            case 0: {
                this.pos = this.length;
                line = this.text;
            }
        }
        return line;
    }

    public String nextToken() {
        return this.nextLine();
    }
}

