/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.CommonSpectrumJCAMPWriter;
import org.jcamp.parser.IJCAMPNoteMarshaller;
import org.jcamp.parser.ISpectrumJCAMPWriter;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.NoteMarshallerFactory;
import org.jcamp.spectrum.MassSpectrum;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.notes.Note;
import org.jcamp.spectrum.notes.NoteDescriptor;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class MSJCAMPWriter
extends CommonSpectrumJCAMPWriter
implements ISpectrumJCAMPWriter {
    private static final String CRLF = "\r\n";

    protected MSJCAMPWriter() {
    }

    private String buildPeakTable(int block, MassSpectrum ms) {
        StringBuilder jcamp = new StringBuilder();
        String title = ms.getTitle();
        jcamp.append("##TITLE=").append(title != null ? title : "").append(CRLF);
        jcamp.append("##JCAMP-DX=5.00").append(CRLF);
        jcamp.append("##DATATYPE=MASS SPECTRUM").append(CRLF);
        jcamp.append("##DATACLASS=PEAK TABLE").append(CRLF);
        if (block != 0) {
            jcamp.append("##BLOCKID=").append(block).append(CRLF);
        }
        jcamp.append(this.getJCAMPNotes(ms));
        jcamp.append(MSJCAMPWriter.getXUnitLDR(ms));
        jcamp.append(MSJCAMPWriter.getYUnitLDR(ms));
        if (ms.hasPeakTable()) {
            Peak1D[] peaks = ms.getPeakTable();
            int n = peaks.length;
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = peaks[i].getPosition()[0];
                double y = peaks[i].getPosition()[1];
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        } else if (!ms.isFullSpectrum()) {
            int n = ms.getXData().getLength();
            jcamp.append("##NPOINTS=").append(n).append(CRLF);
            jcamp.append("##PEAKTABLE=(XY..XY)").append(CRLF);
            for (int i = 0; i < n; ++i) {
                double x = ms.getXData().pointAt(i);
                double y = ms.getYData().pointAt(i);
                jcamp.append(x).append(',').append(y).append(CRLF);
            }
        }
        jcamp.append("##END=").append(CRLF);
        return jcamp.toString();
    }

    @Override
    protected String getJCAMPNotes(Spectrum spectrum) {
        StringBuilder notesStr = new StringBuilder();
        for (Note note : spectrum.getNotes()) {
            NoteDescriptor descr = note.getDescriptor();
            if ("title".equals(descr.getKey()) || !descr.isAllowedForSpectrumID(64)) continue;
            Object value = note.getValue();
            IJCAMPNoteMarshaller marshaller = NoteMarshallerFactory.getInstance().findByDescriptor(descr);
            if (marshaller == null) continue;
            notesStr.append(marshaller.toJCAMP(value));
        }
        return notesStr.toString();
    }

    private static String getXUnitLDR(MassSpectrum ms) {
        Unit unit = ms.getXData().getUnit();
        String name = unit.equals(CommonUnit.mz) ? "##XUNITS=M/Z\r\n" : "##XUNITS=ARBITRARY UNITS\r\n";
        return name;
    }

    private static String getYUnitLDR(MassSpectrum ms) {
        Unit unit = ms.getYData().getUnit();
        String name = unit.equals(CommonUnit.relativeAbundance) || unit.equals(CommonUnit.abundance) ? "##YUNITS=RELATIVE ABUNDANCE\r\n" : "##YUNITS=ARBITRARY UNITS\r\n";
        return name;
    }

    @Override
    public String toJCAMP(Spectrum spectrum) throws JCAMPException {
        if (!(spectrum instanceof MassSpectrum)) {
            throw new JCAMPException("JCAMP adapter missmatch");
        }
        MassSpectrum ms = (MassSpectrum)spectrum;
        StringBuilder jcamp = new StringBuilder();
        jcamp.append(this.buildPeakTable(0, ms));
        return jcamp.toString();
    }

    @Override
    public String toSimpleJCAMP(Spectrum spectrum) throws JCAMPException {
        return this.toJCAMP(spectrum);
    }
}

