/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.math.IArray1D;
import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPNTuplePage;
import org.jcamp.parser.JCAMPVariable;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.NMRFIDSpectrum;
import org.jcamp.spectrum.NMRSpectrum;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class NMRJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    private static Log log = LogFactory.getLog(NMRJCAMPReader.class);
    private String mode;

    protected NMRJCAMPReader(String mode) {
        this.mode = mode;
    }

    private NMRSpectrum createFID(JCAMPBlock block) throws JCAMPException {
        NMRFIDSpectrum spectrum = null;
        String nucleus = this.getNucleus(block);
        double reference = this.getShiftReference(block);
        double freq = this.getFrequency(block);
        if (!block.isNTupleBlock()) {
            ArrayData y;
            IOrderedDataArray1D x;
            Unit yUnit;
            block.getErrorHandler().warn("illegal FID, assuming y values are real FID part");
            Unit xUnit = this.getXUnits(block);
            if (xUnit == null) {
                xUnit = CommonUnit.hertz;
            }
            if ((yUnit = this.getYUnits(block)) == null) {
                yUnit = CommonUnit.intensity;
            }
            double xFactor = this.getXFactor(block);
            double yFactor = this.getYFactor(block);
            int nPoints = this.getNPoints(block);
            if (block.getDataRecord("XYDATA") != null) {
                double lastX;
                double firstX = this.getFirstX(block);
                double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints, xFactor, yFactor);
                if (intensities.length != nPoints) {
                    throw new JCAMPException("incorrect ##NPOINTS= or bad ##XYDATA=");
                }
                x = new EquidistantData(firstX, lastX, nPoints, xUnit);
                y = new ArrayData(intensities, yUnit);
            } else if (block.getDataRecord("XYPOINTS") != null) {
                double[][] xy = this.getXYPoints(block, nPoints, xFactor, yFactor);
                x = new OrderedArrayData(xy[0], xUnit);
                y = new ArrayData(xy[1], yUnit);
            } else {
                throw new JCAMPException("missing data: ##XYDATA= or ##XYPOINTS= required.");
            }
            spectrum = new NMRFIDSpectrum(x, y, nucleus, freq, reference);
        } else {
            Integer dim;
            Double iFactor;
            Double rFactor;
            Double xFactor;
            Double lastX;
            Double firstX;
            JCAMPVariable x = block.getVariable("X");
            JCAMPVariable r = block.getVariable("R");
            JCAMPVariable i = block.getVariable("I");
            if (x == null) {
                block.getErrorHandler().fatal("missing X variable");
            }
            if (r == null) {
                block.getErrorHandler().fatal("missing real fid");
            }
            if (i == null) {
                block.getErrorHandler().fatal("missing imaginary fid");
            }
            if ((firstX = x.getFirst()) == null) {
                block.getErrorHandler().fatal("missing required ##FIRST= for X");
            }
            if ((lastX = x.getLast()) == null) {
                block.getErrorHandler().fatal("missing required ##LAST= for X");
            }
            if ((xFactor = x.getFactor()) == null) {
                block.getErrorHandler().error("missing required ##FACTOR= for X");
                xFactor = new Double(1.0);
            }
            if ((rFactor = r.getFactor()) == null) {
                block.getErrorHandler().error("missing required ##FACTOR= for R");
                rFactor = new Double(1.0);
            }
            if ((iFactor = i.getFactor()) == null) {
                block.getErrorHandler().error("missing required ##FACTOR= for I");
                iFactor = new Double(1.0);
            }
            if ((dim = x.getDimension()) == null) {
                block.getErrorHandler().fatal("missing required ##VARDIM= for X");
            }
            int nPoints = dim;
            Unit xUnit = x.getUnit();
            Unit rUnit = r.getUnit();
            JCAMPNTuplePage page0 = block.getNTuple().getPage(0);
            JCAMPNTuplePage page1 = block.getNTuple().getPage(1);
            if (page0.getDatatableVariableSymbols()[1].equalsIgnoreCase("I")) {
                JCAMPNTuplePage tmp = page0;
                page0 = page1;
                page1 = tmp;
            }
            IArray1D reals = page0.getXYData().getYArray();
            IArray1D imags = page1.getXYData().getYArray();
            EquidistantData xData = new EquidistantData(firstX, lastX, nPoints, xUnit);
            ArrayData rData = new ArrayData(reals, rUnit);
            ArrayData iData = new ArrayData(imags, rUnit);
            spectrum = new NMRFIDSpectrum(xData, rData, iData, nucleus, freq, reference);
        }
        return spectrum;
    }

    private NMRSpectrum createFS(JCAMPBlock block) throws JCAMPException {
        Integer dim;
        Double rFactor;
        Double xFactor;
        Double lastX;
        Double firstX;
        NMRSpectrum spectrum = null;
        String nucleus = this.getNucleus(block);
        if (!block.isNTupleBlock()) {
            Unit yUnit;
            Unit xUnit = this.getXUnits(block);
            if (xUnit == null) {
                xUnit = CommonUnit.hertz;
            }
            if ((yUnit = this.getYUnits(block)) == null) {
                yUnit = CommonUnit.intensity;
            }
            double xFactor2 = this.getXFactor(block);
            double yFactor = this.getYFactor(block);
            int nPoints = this.getNPoints(block);
            IArray1D x = null;
            ArrayData y = null;
            if (block.getDataRecord("XYDATA") != null) {
                double lastX2;
                double firstX2 = this.getFirstX(block);
                double[] intensities = this.getXYData(block, firstX2, lastX2 = this.getLastX(block), nPoints, xFactor2, yFactor);
                if (intensities.length != nPoints) {
                    log.warn((Object)("incorrect ##NPOINTS= or bad ##XYDATA=\nfound " + intensities.length + ", but ##NPOINTS= " + nPoints + ", setting NPOINTS to " + intensities.length));
                    nPoints = intensities.length;
                }
                x = new EquidistantData(firstX2, lastX2, nPoints, xUnit);
                y = new ArrayData(intensities, yUnit);
            } else if (block.getDataRecord("XYPOINTS") != null) {
                double[][] xy = this.getXYPoints(block, nPoints, xFactor2, yFactor);
                x = new OrderedArrayData(xy[0], xUnit);
                y = new ArrayData(xy[1], yUnit);
            } else {
                block.getErrorHandler().fatal("missing data: ##XYDATA= or ##XYPOINTS= required.");
            }
            double reference = Double.NaN;
            try {
                int refPoint = this.getShiftReferencePoint(block);
                reference = x.pointAt(refPoint);
            }
            catch (JCAMPException e) {
                reference = this.getShiftReference(block);
            }
            double freq = this.getFrequency(block);
            spectrum = new NMRSpectrum((IOrderedDataArray1D)x, y, nucleus, freq, reference, true, this.mode);
            return spectrum;
        }
        JCAMPVariable x = block.getVariable("X");
        JCAMPVariable r = block.getVariable("R");
        if (x == null) {
            block.getErrorHandler().fatal("missing X variable");
        }
        if (r == null) {
            block.getErrorHandler().fatal("missing real part");
        }
        if ((firstX = x.getFirst()) == null) {
            block.getErrorHandler().fatal("missing required ##FIRST= for X");
        }
        if ((lastX = x.getLast()) == null) {
            block.getErrorHandler().fatal("missing required ##LAST= for X");
        }
        if ((xFactor = x.getFactor()) == null) {
            block.getErrorHandler().error("missing required ##FACTOR= for X");
            xFactor = new Double(1.0);
        }
        if ((rFactor = r.getFactor()) == null) {
            block.getErrorHandler().error("missing required ##FACTOR= for R");
            rFactor = new Double(1.0);
        }
        if ((dim = x.getDimension()) == null) {
            block.getErrorHandler().fatal("missing required ##VARDIM= for X");
        }
        int nPoints = dim;
        Unit xUnit = x.getUnit();
        Unit rUnit = r.getUnit();
        JCAMPNTuplePage page = block.getNTuple().getPage(0);
        if (page.getDatatableVariableSymbols()[1].equalsIgnoreCase("I")) {
            page = block.getNTuple().getPage(1);
        }
        IArray1D reals = page.getXYData().getYArray();
        EquidistantData xData = new EquidistantData(firstX, lastX, nPoints, xUnit);
        ArrayData rData = new ArrayData(reals, rUnit);
        double reference = Double.NaN;
        try {
            int refPoint = this.getShiftReferencePoint(block);
            reference = xData.pointAt(refPoint);
        }
        catch (JCAMPException e) {
            reference = this.getShiftReference(block);
        }
        double freq = this.getFrequency(block);
        spectrum = new NMRSpectrum(xData, rData, nucleus, freq, reference, true, this.mode);
        return spectrum;
    }

    private NMRSpectrum createPeakTable(JCAMPBlock block) throws JCAMPException {
        Unit yUnit;
        NMRSpectrum spectrum = null;
        String nucleus = this.getNucleus(block);
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.hertz;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        double reference = Double.NaN;
        double freq = Double.NaN;
        int nPoints = this.getNPoints(block);
        Object[] tables = this.getPeaktable(block, nPoints, xFactor, yFactor);
        Peak1D[] peaks = (Peak1D[])tables[0];
        double[][] xy = NMRJCAMPReader.peakTableToPeakSpectrum(peaks);
        OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
        ArrayData y = new ArrayData(xy[1], yUnit);
        try {
            int refPoint = this.getShiftReferencePoint(block);
            reference = x.pointAt(refPoint);
        }
        catch (JCAMPException e) {
            reference = this.getShiftReference(block);
        }
        try {
            freq = this.getFrequency(block);
        }
        catch (JCAMPException e) {
            block.getErrorHandler().warn(e.getMessage());
        }
        spectrum = new NMRSpectrum(x, y, nucleus, freq, reference, false, this.mode);
        spectrum.setPeakTable(peaks);
        if (tables.length > 1) {
            spectrum.setPatternTable((Pattern[])tables[1]);
            if (tables.length > 2) {
                spectrum.setAssignments((Assignment[])tables[2]);
            }
        }
        return spectrum;
    }

    @Override
    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 32) {
            block.getErrorHandler().fatal("adapter missmatch");
        }
        boolean isFID = false;
        NMRSpectrum spectrum = null;
        JCAMPDataRecord ldrDataType = block.getDataRecord("DATATYPE");
        String dataType = ldrDataType.getContent().toUpperCase();
        if (dataType.indexOf("FID") >= 0) {
            isFID = true;
        }
        if (!isFID && block.isNTupleBlock()) {
            JCAMPVariable x = block.getNTuple().getVariable("X");
            if (x.getUnit().equals(CommonUnit.second)) {
                block.getErrorHandler().warn("NMR FID without NMR FID data type");
                isFID = true;
            }
            block.getErrorHandler().warn("nD NMR or NMR spectra with real and imaginary part");
        }
        if (isFID) {
            spectrum = this.createFID(block);
        } else {
            JCAMPBlock.Type type = block.getType();
            if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
                spectrum = this.createFS(block);
            } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
                spectrum = this.createPeakTable(block);
            } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
                spectrum = this.createPeakTable(block);
            } else {
                block.getErrorHandler().fatal("illegal block type");
            }
        }
        String solvent = this.getSolvent(block);
        spectrum.setSolvent(solvent);
        spectrum.setSolventReference(this.getSolventReference(block, solvent));
        this.setNotes(block, spectrum);
        this.getLinkedAssignments(block, spectrum);
        return spectrum;
    }

    private double getBrukerOffset(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrOffset = block.getDataRecord("$OFFSET");
        if (ldrOffset == null) {
            throw new JCAMPException();
        }
        String os = ldrOffset.getContent();
        return Double.valueOf(os);
    }

    private double getBrukerSF(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrSF = block.getDataRecord("$SF");
        if (ldrSF == null) {
            throw new JCAMPException();
        }
        String sf = ldrSF.getContent();
        return Double.valueOf(sf);
    }

    private double getBrukerSW(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrSW = block.getDataRecord("$SW");
        if (ldrSW == null) {
            throw new JCAMPException();
        }
        String sw = ldrSW.getContent();
        return Double.valueOf(sw);
    }

    private double getFrequency(JCAMPBlock block) throws JCAMPException {
        double freq = Double.NaN;
        JCAMPDataRecord ldrFrequency = block.getDataRecord(".OBSERVEFREQUENCY");
        if (ldrFrequency == null) {
            try {
                freq = this.getBrukerSF(block);
            }
            catch (JCAMPException n) {
                block.getErrorHandler().fatal("missing required label ##.OBSERVEFREQUENCY=");
                return 0.0;
            }
            block.getErrorHandler().warn("missing required label ##.OBSERVEFREQUENCY=, using Bruker custom labels");
            return freq;
        }
        freq = Double.valueOf(ldrFrequency.getContent());
        return freq;
    }

    private void getLinkedAssignments(JCAMPBlock block, NMRSpectrum spectrum) throws JCAMPException {
        JCAMPBlock[] linked = block.getReferences();
        for (int i = 0; i < linked.length; ++i) {
            NMRSpectrum linkSpectrum;
            if (linked[i].isStructureBlock() || linked[i].isLinkBlock()) continue;
            JCAMPBlock.Type type = linked[i].getType();
            if (linked[i].getSpectrumID() != 32 || !type.equals(JCAMPBlock.Type.PEAKTABLE) && !type.equals(JCAMPBlock.Type.ASSIGNMENT) || !(linkSpectrum = this.createPeakTable(linked[i])).getNucleus().equals(spectrum.getNucleus())) continue;
            if (linkSpectrum.getFrequency() != linkSpectrum.getFrequency()) {
                linkSpectrum.setFrequency(spectrum.getFrequency());
            }
            if (linkSpectrum.getReference() != linkSpectrum.getReference()) {
                linkSpectrum.setReference(spectrum.getReference());
            }
            if (linkSpectrum.hasPeakTable()) {
                spectrum.setPeakTable(linkSpectrum.getPeakTable());
            }
            if (linkSpectrum.hasPatternTable()) {
                spectrum.setPatternTable(linkSpectrum.getPatternTable());
            }
            if (!linkSpectrum.hasAssignments()) continue;
            spectrum.setAssignments(linkSpectrum.getAssignments());
        }
    }

    private String getNucleus(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrNucleus = block.getDataRecord(".OBSERVENUCLEUS");
        if (ldrNucleus == null) {
            throw new JCAMPException("missing required label: ##.OBSERVENUCLEUS=");
        }
        return ldrNucleus.getContent();
    }

    private double getShiftReference(JCAMPBlock block) throws JCAMPException {
        double reference = Double.NaN;
        try {
            double freq = this.getBrukerSF(block);
            reference = freq * (this.getBrukerSW(block) - this.getBrukerOffset(block));
            block.getErrorHandler().warn("missing ##.SHIFTREFERENCE=, using Bruker custom labels");
            return reference;
        }
        catch (JCAMPException e) {
            JCAMPDataRecord ldrReferencePoint = block.getDataRecord("$REFERENCEPOINT");
            if (ldrReferencePoint == null) {
                block.getErrorHandler().warn("missing shift reference: assuming 0.0 Hz");
                return 0.0;
            }
            block.getErrorHandler().warn("missing ##.SHIFTREFERENCE=, using SpecInfo ##$REFERENCEPOINT=");
            return Double.valueOf(ldrReferencePoint.getContent());
        }
    }

    private int getShiftReferencePoint(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldrShiftReference = block.getDataRecord(".SHIFTREFERENCE");
        if (ldrShiftReference == null) {
            throw new JCAMPException();
        }
        String shiftRef = ldrShiftReference.getContent();
        StringTokenizer commaTokenizer = new StringTokenizer(shiftRef, ",");
        commaTokenizer.nextToken();
        commaTokenizer.nextToken();
        try {
            int shiftPoint = Integer.parseInt(commaTokenizer.nextToken().trim());
            return shiftPoint;
        }
        catch (NumberFormatException ex) {
            throw new JCAMPException(ex.getMessage());
        }
    }

    private String getSolvent(JCAMPBlock block) throws JCAMPException {
        JCAMPDataRecord ldr = block.getDataRecord(".SHIFTREFERENCE");
        if (ldr == null) {
            ldr = block.getDataRecord("$SOLVENT");
            if (ldr == null) {
                return "TMS";
            }
            return ldr.getContent();
        }
        String shiftRef = ldr.getContent();
        StringTokenizer commaTokenizer = new StringTokenizer(shiftRef, ",");
        commaTokenizer.nextToken();
        return commaTokenizer.nextToken();
    }

    private double getSolventReference(JCAMPBlock block, String solvent) throws JCAMPException {
        JCAMPDataRecord ldr = block.getDataRecord(".SHIFTREFERENCE");
        if (ldr == null) {
            ldr = block.getDataRecord(".SOLVENTREFERENCE");
            if (ldr == null) {
                if (solvent.equals("TMS")) {
                    return 0.0;
                }
                block.getErrorHandler().warn("missing required label for non-TMS solvent: ##.SOLVENTREFERENCE=, setting reference to 0.0");
                return 0.0;
            }
            return Double.parseDouble(ldr.getContent());
        }
        String shiftRef = ldr.getContent();
        String[] tokens = shiftRef.split(",", -1);
        double solvRef = Double.parseDouble(tokens[3]);
        return solvRef;
    }
}

