/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jcamp.parser.DefaultNoteMarshaller;
import org.jcamp.parser.IJCAMPNoteMarshaller;
import org.jcamp.parser.IgnoreNoteMarshaller;
import org.jcamp.spectrum.notes.NoteDescriptor;

public class NoteMarshallerFactory {
    private static NoteMarshallerFactory theInstance = null;
    private static Hashtable marshallerTable = new Hashtable();
    private static Class DEFAULT_MARSHALLER = DefaultNoteMarshaller.class;

    private NoteMarshallerFactory() {
        this.initFactory();
    }

    public IJCAMPNoteMarshaller findByDescriptor(NoteDescriptor descriptor) {
        IJCAMPNoteMarshaller marshaller = (IJCAMPNoteMarshaller)marshallerTable.get(descriptor);
        if (marshaller == null) {
            try {
                marshaller = (IJCAMPNoteMarshaller)DEFAULT_MARSHALLER.newInstance();
                marshaller.setKey(descriptor.getKey());
                marshaller.setJCAMPLabel(descriptor.getName());
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return marshaller;
    }

    public static NoteMarshallerFactory getInstance() {
        if (theInstance == null) {
            theInstance = new NoteMarshallerFactory();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFactory() {
        marshallerTable.put(NoteDescriptor.TITLE, new IgnoreNoteMarshaller(NoteDescriptor.TITLE.getKey()));
        marshallerTable.put(NoteDescriptor.JCAMPDX, new IgnoreNoteMarshaller(NoteDescriptor.JCAMPDX.getKey()));
        Properties notesProps = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("notes.properties");
            if (is == null) {
                return;
            }
            notesProps.load(is);
            String defaultJCAMPMarshaller = (String)notesProps.get("default.jcamp.marshaller");
            if (defaultJCAMPMarshaller != null) {
                try {
                    DEFAULT_MARSHALLER = Class.forName(defaultJCAMPMarshaller);
                    if (!IJCAMPNoteMarshaller.class.isAssignableFrom(DEFAULT_MARSHALLER)) {
                        DEFAULT_MARSHALLER = DefaultNoteMarshaller.class;
                    }
                }
                catch (Exception e) {
                    DEFAULT_MARSHALLER = DefaultNoteMarshaller.class;
                }
            }
            Enumeration<?> notesNames = notesProps.propertyNames();
            while (notesNames.hasMoreElements()) {
                Class jcampMarshallerClass;
                String jcampMarshallerClassName;
                NoteDescriptor descr;
                String key = (String)notesNames.nextElement();
                IJCAMPNoteMarshaller marshaller = null;
                if (key.indexOf(46) >= 0 || (descr = NoteDescriptor.findByKey(key)) == null) continue;
                String jcamp = (String)notesProps.get(key + ".jcamp");
                if (jcamp == null) {
                    marshaller = new IgnoreNoteMarshaller(key);
                }
                if ((jcampMarshallerClassName = (String)notesProps.get(key + ".jcamp.marshaller")) == null) {
                    jcampMarshallerClass = DEFAULT_MARSHALLER;
                } else {
                    try {
                        jcampMarshallerClass = Class.forName(jcampMarshallerClassName);
                    }
                    catch (ClassNotFoundException e) {
                        jcampMarshallerClass = DEFAULT_MARSHALLER;
                    }
                    if (!IJCAMPNoteMarshaller.class.isAssignableFrom(jcampMarshallerClass)) {
                        jcampMarshallerClass = DEFAULT_MARSHALLER;
                    }
                }
                try {
                    marshaller = (IJCAMPNoteMarshaller)jcampMarshallerClass.newInstance();
                    marshaller.setKey(key);
                    marshaller.setJCAMPLabel(jcamp);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.getMessage());
                }
                marshallerTable.put(descr, marshaller);
            }
        }
        catch (IOException e) {
            System.out.println("error");
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

