/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ASDFCheckHandler;
import org.jcamp.parser.ASDFParseState;

public class ReplacingCheckHandler
implements ASDFCheckHandler {
    private double firstX;
    private double lastX;
    private double deltaX;
    private double xFactor;
    private int nPoints;
    private static Log log = LogFactory.getLog(ReplacingCheckHandler.class);

    public ReplacingCheckHandler(double firstX, double lastX, double xFactor, int nPoints) {
        this.firstX = firstX;
        this.lastX = lastX;
        this.xFactor = xFactor;
        this.deltaX = (lastX - firstX) / (double)(nPoints - 1);
        this.nPoints = nPoints;
    }

    @Override
    public int check(ASDFParseState state) {
        double realY;
        double realX;
        double checkX = this.xFactor * state.getCheckX();
        if (Math.abs(checkX - (realX = this.firstX + (double)state.getCurrentIndex() * this.deltaX)) * this.xFactor > 0.1) {
            log.warn((Object)("x check failed in line" + state.getCurrentLineNumber() + ": expected x = " + Double.toString(checkX) + " but got " + Double.toString(realX)));
            int newIndex = (int)Math.floor((checkX - this.firstX) / this.deltaX + 0.5);
            if (newIndex < 0 || newIndex >= this.nPoints) {
                log.error((Object)"bad x check value");
                return 2;
            }
            state.setCurrentIndex(newIndex);
            return 1;
        }
        double checkY = state.getCheckY();
        if (checkY != (realY = (double)state.getCurrentY())) {
            log.warn((Object)("y check failed in line " + state.getCurrentLineNumber() + ": expected y = " + Double.toString(checkY) + " but got " + Double.toString(realY)));
            return 1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("line " + state.getCurrentLineNumber() + ": check passed"));
        }
        return 2;
    }
}

