/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.CommonSpectrumJCAMPReader;
import org.jcamp.parser.ISpectrumJCAMPReader;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPException;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.EquidistantData;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.UVSpectrum;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class UVJCAMPReader
extends CommonSpectrumJCAMPReader
implements ISpectrumJCAMPReader {
    protected UVJCAMPReader() {
    }

    private UVSpectrum createFS(JCAMPBlock block) throws JCAMPException {
        UVSpectrum spectrum;
        Unit yUnit;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.nanometerWavelength;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.absorbance;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        if (block.getDataRecord("XYDATA") != null) {
            double lastX;
            double firstX = this.getFirstX(block);
            double[] intensities = this.getXYData(block, firstX, lastX = this.getLastX(block), nPoints, xFactor, yFactor);
            if (intensities.length != nPoints) {
                throw new JCAMPException("incorrect ##NPOINTS= or bad ##XYDATA=");
            }
            EquidistantData x = new EquidistantData(firstX, lastX, nPoints, xUnit);
            ArrayData y = new ArrayData(intensities, yUnit);
            spectrum = new UVSpectrum(x, y, true);
        } else if (block.getDataRecord("XYPOINTS") != null) {
            double[][] xy = this.getXYPoints(block, nPoints, xFactor, yFactor);
            OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
            ArrayData y = new ArrayData(xy[1], yUnit);
            spectrum = new UVSpectrum(x, y, false);
        } else {
            throw new JCAMPException("missing data: ##XYDATA= or ##XYPOINTS= required.");
        }
        return spectrum;
    }

    private UVSpectrum createPeakTable(JCAMPBlock block) throws JCAMPException {
        Unit yUnit;
        UVSpectrum spectrum = null;
        Unit xUnit = this.getXUnits(block);
        if (xUnit == null) {
            xUnit = CommonUnit.nanometerWavelength;
        }
        if ((yUnit = this.getYUnits(block)) == null) {
            yUnit = CommonUnit.intensity;
        }
        double xFactor = this.getXFactor(block);
        double yFactor = this.getYFactor(block);
        int nPoints = this.getNPoints(block);
        Object[] tables = this.getPeaktable(block, nPoints, xFactor, yFactor);
        Peak1D[] peaks = (Peak1D[])tables[0];
        if (peaks.length != nPoints) {
            block.getErrorHandler().error("incorrect ##NPOINTS=: expected " + Integer.toString(nPoints) + " but got " + Integer.toString(peaks.length));
            nPoints = peaks.length;
        }
        double[][] xy = UVJCAMPReader.peakTableToPeakSpectrum(peaks);
        OrderedArrayData x = new OrderedArrayData(xy[0], xUnit);
        ArrayData y = new ArrayData(xy[1], yUnit);
        spectrum = new UVSpectrum(x, y, false);
        spectrum.setPeakTable(peaks);
        if (tables.length > 1) {
            spectrum.setPatternTable((Pattern[])tables[1]);
            if (tables.length > 2) {
                spectrum.setAssignments((Assignment[])tables[2]);
            }
        }
        return spectrum;
    }

    @Override
    public Spectrum createSpectrum(JCAMPBlock block) throws JCAMPException {
        if (block.getSpectrumID() != 8) {
            block.getErrorHandler().fatal("JCAMP reader adapter missmatch");
        }
        UVSpectrum spectrum = null;
        JCAMPBlock.Type type = block.getType();
        if (type.equals(JCAMPBlock.Type.FULLSPECTRUM)) {
            spectrum = this.createFS(block);
        } else if (type.equals(JCAMPBlock.Type.PEAKTABLE)) {
            spectrum = this.createPeakTable(block);
        } else if (type.equals(JCAMPBlock.Type.ASSIGNMENT)) {
            spectrum = this.createPeakTable(block);
        } else {
            block.getErrorHandler().fatal("illegal block type");
        }
        this.setNotes(block, spectrum);
        return spectrum;
    }
}

