/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.Array1D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public class ArrayData
implements IDataArray1D {
    private static final long serialVersionUID = -4103255291717042724L;
    private Array1D data;
    private Unit unit;
    private String label;

    public ArrayData(double[] data, Unit unit) {
        this.data = new Array1D(data, false);
        this.unit = unit != null ? unit : CommonUnit.generic;
    }

    public ArrayData(IArray1D data) {
        this(data, CommonUnit.generic);
    }

    public ArrayData(IArray1D data, Unit unit) {
        this.data = new Array1D(data);
        this.unit = unit != null ? unit : CommonUnit.generic;
    }

    @Override
    public Object clone() {
        ArrayData o = null;
        try {
            o = (ArrayData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        o.data = (Array1D)this.data.clone();
        o.unit = (Unit)this.unit.clone();
        return o;
    }

    @Override
    public void convertToUnit(Unit newUnit) throws UnitException {
        double[] array = new double[this.data.getLength()];
        for (int i = 0; i < this.data.getLength(); ++i) {
            array[i] = newUnit.convertFrom(this.data.pointAt(i), this.unit);
        }
        this.setData(new Array1D(array, false));
        this.setUnit(newUnit);
    }

    public IArray1D getData() {
        return this.data;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.unit.toString();
        }
        return this.label;
    }

    @Override
    public int getLength() {
        return this.data.getLength();
    }

    @Override
    public Range.Double getRange() {
        return this.data.getRange();
    }

    @Override
    public Range1D.Double getRange1D() {
        return this.data.getRange1D();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public double pointAt(int index) {
        return this.data.pointAt(index);
    }

    @Override
    public void scale(double amount) {
        this.data.scale(amount);
    }

    void setData(Array1D newData) {
        this.data = newData;
    }

    @Override
    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    @Override
    public void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    @Override
    public double[] toArray() {
        return this.data.toArray();
    }

    @Override
    public void translate(double amount) {
        this.data.translate(amount);
    }
}

