/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.spectrum.IAssignmentTarget;
import org.jcamp.spectrum.ISpectrumLabel;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.spectrum.assignments.AtomReference;

public class Assignment
implements ISpectrumLabel,
Cloneable {
    private IAssignmentTarget[] targets = null;
    private Pattern pattern = null;

    public Assignment(Pattern pattern) {
        this.pattern = (Pattern)pattern.clone();
    }

    public Assignment(Pattern pattern, int[] atoms) {
        this.pattern = (Pattern)pattern.clone();
        this.targets = new AtomReference[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            this.targets[i] = new AtomReference(null, atoms[i]);
        }
    }

    public Assignment(Pattern pattern, IAssignmentTarget[] assigned) {
        this.pattern = (Pattern)pattern.clone();
        this.targets = assigned;
    }

    public Object clone() {
        Assignment assign = null;
        try {
            assign = (Assignment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        assign.setPattern(this.pattern);
        assign.setTargets(this.targets);
        return assign;
    }

    public int compareTo(Object obj) {
        double p1;
        double p0 = this.getPosition()[0];
        if (p0 < (p1 = ((ISpectrumLabel)obj).getPosition()[0])) {
            return -1;
        }
        if (p0 > p1) {
            return 1;
        }
        return 0;
    }

    private String formatLabel() {
        if (this.targets == null || this.targets.length == 0) {
            return "<n/a>";
        }
        StringBuilder astr = new StringBuilder();
        astr.append("<");
        for (int i = 0; i < this.targets.length; ++i) {
            astr.append(this.targets[i].getLabel());
            if (i >= this.targets.length - 1) continue;
            astr.append(",");
        }
        astr.append(">");
        return astr.toString();
    }

    @Override
    public String getLabel() {
        return this.formatLabel();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public double[] getPosition() {
        return this.pattern.getPosition();
    }

    public Spectrum1D getSpectrum() {
        return this.pattern.getSpectrum();
    }

    public IAssignmentTarget[] getTargets() {
        return this.targets;
    }

    public void setPattern(Pattern newPattern) {
        this.pattern = (Pattern)newPattern.clone();
    }

    public void setPosition(double[] newPosition) {
        this.pattern.setPosition(newPosition);
    }

    public void setSpectrum(Spectrum1D spectrum) {
        this.pattern.setSpectrum(spectrum);
    }

    public void setTargets(IAssignmentTarget[] newAssigned) {
        this.targets = newAssigned;
    }

    @Override
    public void translate(double[] amount) {
        this.pattern.translate(amount);
    }
}

