/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.Array1D;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Chromatogram;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IMasterSpectrum;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.MassSpectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.units.CommonUnit;

public class GCMSSpectrum
extends Chromatogram
implements IMasterSpectrum {
    private static final long serialVersionUID = -7114727189019130125L;
    protected MassSpectrum[] massSpectra;

    public GCMSSpectrum(IOrderedDataArray1D times, MassSpectrum[] ms) {
        super(times, GCMSSpectrum.calcTICC(ms));
        this.massSpectra = ms;
        for (int i = 0; i < ms.length; ++i) {
            ms[i].setMasterSpectrum(this);
        }
    }

    public GCMSSpectrum(IOrderedDataArray1D times, IDataArray1D tic, MassSpectrum[] ms) {
        super(times, tic);
        this.massSpectra = ms;
        for (int i = 0; i < ms.length; ++i) {
            ms[i].setMasterSpectrum(this);
        }
    }

    static IDataArray1D calcTICC(MassSpectrum[] ms) {
        int n = ms.length;
        double[] ticc = new double[n];
        for (int i = 0; i < n; ++i) {
            ticc[i] = 0.0;
            MassSpectrum spectrum = ms[i];
            IDataArray1D intensities = spectrum.getYData();
            for (int j = 0; j < intensities.getLength(); ++j) {
                int n2 = i;
                ticc[n2] = ticc[n2] + intensities.pointAt(j);
            }
        }
        return new ArrayData(new Array1D(ticc, false), CommonUnit.intensity);
    }

    @Override
    public Object clone() {
        int n = this.massSpectra.length;
        MassSpectrum[] ms = new MassSpectrum[n];
        for (int i = 0; i < n; ++i) {
            ms[i] = (MassSpectrum)this.massSpectra[i].clone();
        }
        GCMSSpectrum spectrum = null;
        spectrum = (GCMSSpectrum)super.clone();
        spectrum.massSpectra = ms;
        return spectrum;
    }

    @Override
    public int getIdentifier() {
        return 393280;
    }

    @Override
    public Spectrum1D getSlaveSpectrumFromXIndex(int ix) {
        return this.massSpectra[ix];
    }

    @Override
    public Spectrum1D getSlaveSpectrumFromXPosition(double x) {
        int index = this.getXData().indexAt(x);
        return this.massSpectra[index];
    }

    @Override
    public Spectrum1D getSlaveSpectrumFromYIndex(int iy) {
        return null;
    }

    @Override
    public Spectrum1D getSlaveSpectrumFromYPosition(double y) {
        return null;
    }
}

