/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.IPeakPicking;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum1D;

public class MSPeakPicking
implements IPeakPicking {
    final int MS_SIGNIFICANT_PEAKS = 32;

    @Override
    public Vector calculate(Spectrum1D spectrum) {
        int i;
        int i2;
        double amu = 100.0;
        double rj = 40.0;
        double rk = 50.0;
        double rl = 7.0;
        Vector<Peak1D> assigns = new Vector<Peak1D>();
        IOrderedDataArray1D x = spectrum.getXData();
        IDataArray1D y = spectrum.getYData();
        int n = y.getLength();
        Integer[] peaks = new Integer[n];
        for (int i3 = 0; i3 < n; ++i3) {
            peaks[i3] = new Integer(i3);
        }
        int[] sigPeaks = new int[32];
        this.sortPeaksWeighted(spectrum, peaks, 0, n - 1);
        int nSigs = Math.min(32, n);
        for (i2 = 0; i2 < nSigs; ++i2) {
            sigPeaks[i2] = peaks[i2];
        }
        if (n <= 32) {
            for (i2 = 0; i2 < nSigs; ++i2) {
                assigns.addElement(new Peak1D(spectrum, x.pointAt(sigPeaks[i2])));
            }
            return assigns;
        }
        double range = x.getRange1D().getXWidth();
        if (amu > 0.0 && range < amu) {
            double sf = range / amu;
            amu = range;
            rj *= sf;
            rk *= sf;
        }
        for (int filter = 0; filter < 2; ++filter) {
            int i4;
            int resultDatapoints = 0;
            int[] tmpPeaks = new int[n];
            double a1 = filter == 0 ? rk : rl;
            for (i4 = 0; i4 < n; ++i4) {
                int remainPeaks = (int)(rj / amu * (2.0 * a1 + 1.0));
                double intervalLeft = x.pointAt(i4) - a1;
                double intervalRight = x.pointAt(i4) + a1;
                double realLeft = Math.max(intervalLeft, x.pointAt(0));
                double realRight = Math.min(intervalLeft, x.pointAt(n - 1));
                double ratio = intervalRight - intervalLeft == 0.0 ? 1.0 : (realRight - realLeft) / (intervalRight - intervalLeft);
                remainPeaks = (int)((double)remainPeaks * ratio);
                int j = 0;
                for (int k = 0; k < n; ++k) {
                    if (!(x.pointAt(k) >= realLeft) || !(x.pointAt(k) <= realRight) || !(y.pointAt(i4) < y.pointAt(k))) continue;
                    ++j;
                }
                if (j >= remainPeaks) continue;
                tmpPeaks[resultDatapoints] = i4;
                ++resultDatapoints;
            }
            for (i4 = 0; i4 < resultDatapoints; ++i4) {
                peaks[i4] = new Integer(tmpPeaks[i4]);
            }
            n = resultDatapoints;
        }
        int k = 0;
        for (i = 0; i < nSigs; ++i) {
            boolean peakFound = false;
            for (int j = 0; j < n; ++j) {
                if (j != sigPeaks[i]) continue;
                peakFound = true;
                break;
            }
            if (peakFound) continue;
            peaks[n + k] = new Integer(sigPeaks[i]);
            ++k;
        }
        if ((n += k) > 0) {
            this.sortPeaksWeighted(spectrum, peaks, 0, n - 1);
        }
        for (i = 0; i < n; ++i) {
            assigns.addElement(new Peak1D(spectrum, x.pointAt(peaks[i])));
        }
        return assigns;
    }

    private void sortPeaksWeighted(Spectrum1D spectrum, Integer[] peaks, int from, int to) {
        final IOrderedDataArray1D x = spectrum.getXData();
        final IDataArray1D y = spectrum.getYData();
        Arrays.sort(peaks, from, to, new Comparator(){

            public int compare(Object o1, Object o2) {
                double w2;
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                double w1 = Math.sqrt(x.pointAt(i1) * y.pointAt(i1));
                if (w1 < (w2 = Math.sqrt(x.pointAt(i2) * y.pointAt(i2)))) {
                    return 1;
                }
                if (w1 == w2) {
                    return 0;
                }
                return -1;
            }
        });
    }
}

