/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.util.Vector;
import org.jcamp.spectrum.MinHeightPeakPicking;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.spectrum.Spectrum1DIntegral;

public class MinAreaPeakPicking
extends MinHeightPeakPicking {
    private double minArea;

    public MinAreaPeakPicking(double minArea, double minHeight, double noise) {
        super(minHeight, noise);
        this.minArea = minArea;
    }

    @Override
    public Vector calculate(Spectrum1D spectrum) {
        Vector<Peak1D> filteredPeaks = new Vector<Peak1D>();
        if (spectrum.isFullSpectrum()) {
            Vector peaks = super.calculate(spectrum);
            for (int i = 0; i < peaks.size(); ++i) {
                Peak1D peak = (Peak1D)peaks.elementAt(i);
                Spectrum1DIntegral integral = new Spectrum1DIntegral(spectrum, peak.getRange());
                if (!(integral.getArea() > this.minArea)) continue;
                filteredPeaks.addElement(peak);
            }
        }
        return filteredPeaks;
    }

    public double getMinArea() {
        return this.minArea;
    }

    public void setMinArea(double newMinArea) {
        this.minArea = newMinArea;
    }
}

