/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.math.Range2D;
import org.jcamp.math.ReversedLinearAxisMap;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public class NMRSpectrum
extends Spectrum1D {
    private static final long serialVersionUID = -7481239141912664609L;
    public static final Unit DEFAULT_YUNIT = CommonUnit.intensity;
    public static final Unit DEFAULT_XUNIT = CommonUnit.hertz;
    protected String nucleus;
    protected double frequency = 400.0;
    protected double reference = 0.0;
    protected double solventReference = 0.0;
    protected boolean fid = false;
    protected String solvent = "TMS";
    private String mode = "strict";

    protected NMRSpectrum() {
    }

    public NMRSpectrum(IOrderedDataArray1D x, IDataArray1D y, String nucleus, double freq, double ref) {
        super(x, y);
        this.frequency = freq;
        this.reference = ref;
        this.nucleus = nucleus;
    }

    public NMRSpectrum(IOrderedDataArray1D x, IDataArray1D y, String nucleus, double freq, double ref, boolean fullSpectrum, String mode) {
        super(x, y, fullSpectrum);
        this.frequency = freq;
        this.reference = ref;
        this.nucleus = nucleus;
        this.mode = mode;
        this.convertToPPM();
        this.convertToPercent();
        this.xAxisMap = new ReversedLinearAxisMap(this.xData);
        this.yAxisMap = new LinearAxisMap(this.yData);
        this.adjustFullViewRange();
    }

    @Override
    public Object clone() {
        NMRSpectrum spectrum = (NMRSpectrum)super.clone();
        spectrum.xAxisMap = new ReversedLinearAxisMap(spectrum.xData);
        spectrum.yAxisMap = new LinearAxisMap(spectrum.yData);
        return spectrum;
    }

    protected void convertToHertz() {
        if (this.frequency != this.frequency) {
            return;
        }
        if (this.xData.getUnit().equals(CommonUnit.ppm)) {
            this.xData.scale(this.frequency);
            if (this.mode == "strict" && this.reference == this.reference) {
                this.xData.translate(this.reference);
            }
            this.xData.setUnit(CommonUnit.hertz);
            this.adjustFullViewRange();
        }
    }

    public static double[] convertToHertz(double[] ppm, double freq, double ref) {
        int n = ppm.length;
        double[] hz = new double[n];
        for (int i = 0; i < n; ++i) {
            hz[i] = freq * ppm[i] + ref;
        }
        return hz;
    }

    public static double convertToHertz(double ppm, double freq, double ref) {
        double hz = freq * ppm + ref;
        return hz;
    }

    protected void convertToPercent() {
        double imax;
        if (!this.yData.equals(CommonUnit.percentIntensity) && (imax = this.yData.getRange1D().getXMax()) != 0.0) {
            imax = 100.0 / imax;
            this.yData.scale(imax);
            this.yData.setUnit(CommonUnit.percentIntensity);
        }
    }

    public static void convertToPercent(double[] intensities) {
        int i;
        double imax = Math.abs(intensities[0]);
        for (i = 1; i < intensities.length; ++i) {
            double iabs = Math.abs(intensities[i]);
            if (!(iabs > imax)) continue;
            imax = iabs;
        }
        if (imax != 0.0) {
            imax = 100.0 / imax;
            i = 0;
            while (i < intensities.length) {
                int n = i++;
                intensities[n] = intensities[n] * imax;
            }
        }
    }

    protected void convertToPPM() {
        if (this.frequency != this.frequency) {
            return;
        }
        if (this.xData.getUnit().equals(CommonUnit.hertz)) {
            if (this.mode == "strict" && this.reference == this.reference) {
                this.xData.translate(-this.reference);
            }
            this.xData.scale(1.0 / this.frequency);
            this.xData.setUnit(CommonUnit.ppm);
            this.adjustFullViewRange();
        }
    }

    public static double[] convertToPPM(double[] hz, double freq, double ref) {
        int n = hz.length;
        double[] ppm = new double[n];
        for (int i = 0; i < n; ++i) {
            ppm[i] = (hz[i] - ref) / freq;
        }
        return ppm;
    }

    public static double convertToPPM(double hz, double freq, double ref) {
        double ppm = (hz - ref) / freq;
        return ppm;
    }

    @Override
    public Range2D.Double getDataRange() {
        return new Range2D.Double(this.xAxisMap.getDataRange(), this.yAxisMap.getDataRange());
    }

    public double getFrequency() {
        return this.frequency;
    }

    @Override
    public int getIdentifier() {
        return 32;
    }

    public String getNucleus() {
        return this.nucleus;
    }

    public double getReference() {
        return this.reference;
    }

    public String getSolvent() {
        return this.solvent;
    }

    public double getSolventReference() {
        return this.solventReference;
    }

    @Override
    public Range1D.Double getXFullViewRange() {
        return new Range1D.Double(this.xAxisMap.getFullViewRange());
    }

    @Override
    public Range1D.Double getYFullViewRange() {
        return new Range1D.Double(this.yAxisMap.getFullViewRange());
    }

    public boolean isFID() {
        return false;
    }

    @Override
    public boolean isSameType(Spectrum otherSpectrum) {
        return otherSpectrum instanceof NMRSpectrum;
    }

    public void setFrequency(double newFrequency) {
        if (this.frequency != newFrequency) {
            this.convertToHertz();
            this.frequency = newFrequency;
            this.convertToPPM();
        }
    }

    public void setNucleus(String newNucleus) {
        this.nucleus = newNucleus;
    }

    public void setReference(double newReference) {
        if (this.reference != newReference) {
            this.convertToHertz();
            this.reference = newReference;
            this.convertToPPM();
        }
    }

    public void setSolvent(String newSolvent) {
        this.solvent = newSolvent;
    }

    public void setSolventReference(double newSolventReference) {
        this.solventReference = newSolventReference;
    }

    @Override
    public void setXFullViewRange(Range1D.Double dataRange) {
        if (dataRange.getXWidth() > 0.0) {
            this.xAxisMap = new ReversedLinearAxisMap(this.xData, dataRange);
        }
    }

    @Override
    public void setYFullViewRange(Range1D.Double dataRange) {
        this.yAxisMap = new LinearAxisMap(this.yData, dataRange);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

