/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.Array1D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.Unit;

public abstract class OpticalSpectrum1D
extends Spectrum1D {
    private static final long serialVersionUID = -6989200995078011258L;

    protected OpticalSpectrum1D(IOrderedDataArray1D x, IDataArray1D y) {
        super(x, y);
    }

    protected OpticalSpectrum1D() {
    }

    @Override
    public Object clone() {
        OpticalSpectrum1D spectrum = (OpticalSpectrum1D)super.clone();
        spectrum.xAxisMap = new LinearAxisMap(spectrum.xData);
        spectrum.yAxisMap = new LinearAxisMap(spectrum.yData);
        return spectrum;
    }

    public void convertToAbsorbance() {
        IDataArray1D newY = OpticalSpectrum1D.convertToAbsorbance(this.yData);
        if (newY != this.yData) {
            this.setData(this.xData, newY);
            newY.setLabel(null);
            this.adjustFullViewRange();
        }
    }

    public void convertToPercent() {
        IDataArray1D newY = OpticalSpectrum1D.convertToPercent(this.yData);
        if (newY != this.yData) {
            this.setData(this.xData, newY);
            newY.setLabel(null);
            this.adjustFullViewRange();
        }
    }

    public void convertToTransmittance() {
        IDataArray1D newY = OpticalSpectrum1D.convertToTransmittance(this.yData);
        if (newY != this.yData) {
            this.setData(this.xData, newY);
            newY.setLabel(null);
            this.adjustFullViewRange();
        }
    }

    @Override
    public abstract int getIdentifier();

    @Override
    public abstract boolean isSameType(Spectrum var1);

    public boolean isTransmission() {
        Unit yunit = this.yData.getUnit();
        if (yunit.equals(CommonUnit.percentTransmittance) || yunit.equals(CommonUnit.transmittance)) {
            return true;
        }
        if (yunit.equals(CommonUnit.percentAbsorbance) || yunit.equals(CommonUnit.absorbance)) {
            return false;
        }
        return OpticalSpectrum1D.isTransmission(this.yData);
    }

    private static boolean isTransmission(IArray1D data) {
        Range1D.Double range = data.getRange1D();
        double yhigh = range.getXMax() - 0.1 * range.getXWidth();
        double ylow = range.getXMin() + 0.1 * range.getXWidth();
        int nlow = 0;
        int nhigh = 0;
        for (int i = 0; i < data.getLength(); ++i) {
            double y = data.pointAt(i);
            if (y > yhigh) {
                ++nhigh;
                continue;
            }
            if (!(y < ylow)) continue;
            ++nlow;
        }
        return nhigh > nlow;
    }

    protected OpticalSpectrum1D(IOrderedDataArray1D x, IDataArray1D y, boolean fullSpectrum) {
        super(x, y, fullSpectrum);
        if (this.isTransmission()) {
            this.convertToAbsorbance();
            this.adjustFullViewRange();
        }
    }

    private static IDataArray1D convertToAbsorbance(IDataArray1D data) {
        double ref;
        int n = data.getLength();
        if (data.getUnit().equals(CommonUnit.percentTransmittance)) {
            ref = 100.0;
        } else if (data.getUnit().equals(CommonUnit.transmittance)) {
            ref = 1.0;
        } else {
            return data;
        }
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            double t = data.pointAt(i);
            if (t < 0.0) {
                t = 0.0;
            }
            if (t > ref) {
                t = ref;
            }
            y[i] = t > 0.0 ? Math.max(0.0, Math.log(ref / t) / Math.log(10.0)) : 1.0;
        }
        return new ArrayData(new Array1D(y, false), CommonUnit.absorbance);
    }

    private static IDataArray1D convertToPercent(IDataArray1D data) {
        int n = data.getLength();
        if (data.getUnit().equals(CommonUnit.transmittance)) {
            double max = data.getRange1D().getXMax();
            double[] y = new double[n];
            for (int i = 0; i < n; ++i) {
                y[i] = 100.0 * (data.pointAt(i) / max);
            }
            return new ArrayData(new Array1D(y, false), CommonUnit.percentTransmittance);
        }
        return data;
    }

    private static IDataArray1D convertToTransmittance(IDataArray1D data) {
        int n = data.getLength();
        if (data.getUnit().equals(CommonUnit.absorbance)) {
            double[] y = new double[n];
            for (int i = 0; i < n; ++i) {
                double a = data.pointAt(i);
                if (a > 1.0) {
                    a = 1.0;
                }
                if (a < 0.0) {
                    a = 0.0;
                }
                y[i] = 100.0 / Math.pow(10.0, a);
            }
            return new ArrayData(new Array1D(y, false), CommonUnit.percentTransmittance);
        }
        return data;
    }
}

