/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import java.text.FieldPosition;
import java.text.NumberFormat;
import org.jcamp.math.Range1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.ISpectrumLabel;
import org.jcamp.spectrum.Peak;
import org.jcamp.spectrum.Spectrum1D;

public class Peak1D
extends Peak
implements Cloneable {
    Range1D.Double range = new Range1D.Double();
    Range1D.Int irange = new Range1D.Int();
    protected static NumberFormat formatPeakPosition = NumberFormat.getInstance();

    public Peak1D(double x, double y) {
        super(null, new double[]{x, x}, y);
        this.range.set(x, x);
    }

    public Peak1D(double x, double y, double w) {
        super(null, new double[]{x, x}, y);
        this.range.setCenterAndWidth(x, w);
    }

    public Peak1D(Spectrum1D spectrum, double position) {
        super(spectrum, new double[]{position, 1.0});
        this.range.set(position, position);
    }

    public Peak1D(Spectrum1D spectrum, double position, Range1D.Double range) {
        super(spectrum, new double[]{position});
        this.setRange(range);
    }

    public Peak1D(Spectrum1D spectrum, int xIndex) {
        this(spectrum, spectrum.getXData().pointAt(xIndex));
    }

    public Peak1D(Spectrum1D spectrum, int index, Range1D.Double range) {
        this(spectrum, spectrum.getXData().pointAt(index), range);
    }

    public Object clone() {
        Peak1D peak = new Peak1D((Spectrum1D)this.spectrum, this.position[0], this.range);
        return peak;
    }

    public int compareTo(Object obj) {
        double p1;
        double p0 = this.getPosition()[0];
        if (p0 < (p1 = ((ISpectrumLabel)obj).getPosition()[0])) {
            return -1;
        }
        if (p0 > p1) {
            return 1;
        }
        return 0;
    }

    private static String formatPeakPosition(double x) {
        double prec = Math.pow(10.0, formatPeakPosition.getMaximumFractionDigits());
        StringBuffer label = new StringBuffer();
        FieldPosition fp = new FieldPosition(0);
        label.setLength(0);
        x = Math.floor(x * prec + 0.5) / prec;
        formatPeakPosition.format(x, label, fp);
        return label.toString();
    }

    public Range1D.Int getIndexRange() {
        return this.irange;
    }

    @Override
    public String getLabel() {
        return Peak1D.formatPeakPosition(this.position[0]);
    }

    public Range1D.Double getRange() {
        return this.range;
    }

    public void setRange(Range1D newRange) {
        this.range.set(newRange);
        if (this.spectrum != null) {
            IOrderedDataArray1D xdata = ((Spectrum1D)this.spectrum).getXData();
            this.irange = new Range1D.Int(xdata.indexAt(this.range.getXMin()), xdata.indexAt(this.range.getXMax()));
        }
    }

    static {
        formatPeakPosition.setMaximumFractionDigits(3);
        formatPeakPosition.setMinimumFractionDigits(0);
        formatPeakPosition.setGroupingUsed(false);
    }
}

