/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.math.AxisMap;
import org.jcamp.math.DataException;
import org.jcamp.math.LinearAxisMap;
import org.jcamp.math.LinearGrid2D;
import org.jcamp.math.Range1D;
import org.jcamp.math.Range3D;
import org.jcamp.math.RectangularGrid2D;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IEquidistant;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.Spectrum;

public abstract class Spectrum2D
extends Spectrum {
    private static final long serialVersionUID = 8483858856131296895L;
    protected IOrderedDataArray1D yData;
    protected IOrderedDataArray1D xData;
    protected IDataArray1D zData;
    protected AxisMap xAxisMap;
    protected AxisMap yAxisMap;
    protected AxisMap zAxisMap;
    protected boolean fullSpectrum = true;
    private LinearGrid2D xyGrid = null;

    protected Spectrum2D(IOrderedDataArray1D x, IOrderedDataArray1D y, IDataArray1D z) {
        this.xData = x;
        this.yData = y;
        this.zData = z;
        this.fullSpectrum = true;
        if (x instanceof IEquidistant && y instanceof IEquidistant) {
            this.xyGrid = new LinearGrid2D(((IEquidistant)((Object)x)).getDataGrid(), ((IEquidistant)((Object)y)).getDataGrid());
        }
    }

    @Override
    public Object clone() {
        return (Spectrum2D)super.clone();
    }

    public Range3D.Double getDataRange() {
        return new Range3D.Double(this.xAxisMap.getDataRange(), this.yAxisMap.getDataRange(), this.zAxisMap.getDataRange());
    }

    @Override
    public String getXAxisLabel() {
        if (this.xData != null) {
            return this.xData.getLabel();
        }
        return "";
    }

    @Override
    public AxisMap getXAxisMap() {
        return this.xAxisMap;
    }

    public IOrderedDataArray1D getXData() {
        return this.xData;
    }

    public Range1D.Double getXFullViewRange() {
        return new Range1D.Double(this.xAxisMap.getFullViewRange());
    }

    @Override
    public String getYAxisLabel() {
        if (this.yData != null) {
            return this.yData.getLabel();
        }
        return "";
    }

    @Override
    public AxisMap getYAxisMap() {
        return this.yAxisMap;
    }

    public IOrderedDataArray1D getYData() {
        return this.yData;
    }

    public Range1D.Double getYFullViewRange() {
        return new Range1D.Double(this.yAxisMap.getFullViewRange());
    }

    public String getZAxisLabel() {
        if (this.zData != null) {
            return this.zData.getLabel();
        }
        return "";
    }

    public AxisMap getZAxisMap() {
        return this.zAxisMap;
    }

    public IDataArray1D getZData() {
        return this.zData;
    }

    public Range1D.Double getZFullViewRange() {
        return new Range1D.Double(this.zAxisMap.getFullViewRange());
    }

    public double interpolateZ(double xvalue, double yvalue) {
        if (this.xyGrid != null) {
            return this.interpolateZGrid(xvalue, yvalue);
        }
        return this.interpolateZArray(xvalue, yvalue);
    }

    private double interpolateZArray(double xvalue, double yvalue) {
        double zvalue;
        double dy;
        double dx;
        int[] by;
        int[] bx;
        double EPS = 1.0E-10;
        int lengthX = this.xData.getLength();
        try {
            bx = this.xData.boundIndices(xvalue);
            by = this.yData.boundIndices(yvalue);
        }
        catch (DataException e) {
            return 0.0;
        }
        if (bx[0] == bx[1]) {
            double x0;
            if (by[0] == by[1]) {
                return this.zData.pointAt(by[0] * lengthX + bx[0]);
            }
            double x1 = x0 = this.xData.pointAt(bx[0]);
            dx = 0.0;
            double y1 = this.yData.pointAt(by[1]);
            double y0 = this.yData.pointAt(by[0]);
            dy = yvalue - y0 > 1.0E-10 ? (y1 - yvalue > 1.0E-10 ? Math.max(0.0, Math.min(1.0, (yvalue - y0) / (y1 - y0))) : 1.0) : 0.0;
        } else {
            double x0 = this.xData.pointAt(bx[0]);
            double x1 = this.xData.pointAt(bx[1]);
            dx = xvalue - x0 > 1.0E-10 ? (x1 - xvalue > 1.0E-10 ? Math.max(0.0, Math.min(1.0, (xvalue - x0) / (x1 - x0))) : 1.0) : 0.0;
            if (by[0] == by[1]) {
                double y0;
                double y1 = y0 = this.yData.pointAt(by[0]);
                dy = 0.0;
            } else {
                double y0 = this.yData.pointAt(by[0]);
                double y1 = this.yData.pointAt(by[1]);
                dy = yvalue - y0 > 1.0E-10 ? (y1 - yvalue > 1.0E-10 ? Math.max(0.0, Math.min(1.0, (yvalue - y0) / (y1 - y0))) : 1.0) : 0.0;
            }
        }
        if (dx == 0.0) {
            if (dy == 0.0) {
                return this.zData.pointAt(by[0] * lengthX + bx[0]);
            }
            if (dy == 1.0) {
                return this.zData.pointAt(by[1] * lengthX + bx[0]);
            }
        } else if (dx == 1.0) {
            if (dy == 0.0) {
                return this.zData.pointAt(by[0] * lengthX + bx[1]);
            }
            if (dy == 1.0) {
                return this.zData.pointAt(by[1] * lengthX + bx[1]);
            }
        }
        int lb = by[0] * lengthX + bx[0];
        int rb = by[0] * lengthX + bx[1];
        int lt = by[1] * lengthX + bx[0];
        int rt = by[1] * lengthX + bx[1];
        double zlb = this.zData.pointAt(lb);
        double zrb = this.zData.pointAt(rb);
        double zlt = this.zData.pointAt(lt);
        double zrt = this.zData.pointAt(rt);
        if (dx + dy - 1.0 < 0.0) {
            zvalue = zlb + dx * (zrb - zlb) + dy * (zlt - zlb);
        } else {
            dx = 1.0 - dx;
            dy = 1.0 - dy;
            zvalue = zrt + dx * (zlt - zrt) + dy * (zrb - zrt);
        }
        return zvalue;
    }

    private double interpolateZGrid(double xvalue, double yvalue) {
        int gy0;
        int lengthX = this.xyGrid.getXGrid().getLength();
        int lengthY = this.xyGrid.getYGrid().getLength();
        double gx = this.xyGrid.getXGrid().coordinateAt(xvalue);
        double gy = this.xyGrid.getYGrid().coordinateAt(yvalue);
        if (gx < -0.5 || gx > (double)lengthX - 0.5 || gy < -0.5 || gy > (double)lengthY - 0.5) {
            return Double.NaN;
        }
        int gx0 = (int)Math.floor(gx + 0.5);
        if (gx0 < 0) {
            gx0 = 0;
        }
        if (gx0 > lengthX - 2) {
            gx0 = lengthX - 2;
        }
        if ((gy0 = (int)Math.floor(gy + 0.5)) < 0) {
            gy0 = 0;
        }
        if (gy0 > lengthY - 2) {
            gy0 = lengthY - 2;
        }
        int lb = gy0 * lengthX + gx0;
        int rb = gy0 * lengthX + gx0 + 1;
        int lt = (gy0 + 1) * lengthX + gx0;
        int rt = (gy0 + 1) * lengthX + gx0 + 1;
        double dx = Math.max(0.0, Math.min(1.0, gx - (double)gx0));
        double dy = Math.max(0.0, Math.min(1.0, gy - (double)gy0));
        double zlb = this.zData.pointAt(lb);
        double zrb = this.zData.pointAt(rb);
        double zlt = this.zData.pointAt(lt);
        double zrt = this.zData.pointAt(rt);
        if (dx + dy - 1.0 < 0.0) {
            return zlb + dx * (zrb - zlb) + dy * (zlt - zlb);
        }
        dx = Math.max(0.0, Math.min(1.0, (double)(gx0 + 1) - gx));
        dy = Math.max(0.0, Math.min(1.0, (double)(gy0 + 1) - gy));
        dx = (double)(gx0 + 1) - gx;
        dy = (double)(gy0 + 1) - gy;
        return zrt + dx * (zlt - zrt) + dy * (zrb - zrt);
    }

    @Override
    public boolean isFullSpectrum() {
        return this.fullSpectrum;
    }

    @Override
    public boolean isSameType(Spectrum otherSpectrum) {
        return false;
    }

    public double[] resample(RectangularGrid2D newGrid) {
        if (this.xyGrid != null) {
            return this.xyGrid.interpolate(newGrid, this.zData.toArray());
        }
        int n = newGrid.getLength();
        double[] sampled = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] xy = newGrid.gridPointAt(i);
            sampled[i] = this.interpolateZArray(xy[0], xy[1]);
        }
        return sampled;
    }

    public void setFullSpectrum(boolean newFullSpectrum) {
        this.fullSpectrum = newFullSpectrum;
    }

    public void setFullViewRange(Range3D.Double range) {
        this.setXFullViewRange(range.getRange(0));
        this.setYFullViewRange(range.getRange(1));
        this.setZFullViewRange(range.getRange(2));
    }

    public void setXFullViewRange(Range1D.Double dataRange) {
        this.xAxisMap = new LinearAxisMap(this.xData, dataRange);
    }

    public void setYFullViewRange(Range1D.Double dataRange) {
        this.yAxisMap = new LinearAxisMap(this.yData, dataRange);
    }

    public void setZFullViewRange(Range1D.Double dataRange) {
        this.zAxisMap = new LinearAxisMap(this.zData, dataRange);
    }
}

