/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum;

import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.spectrum.Spectrum2D;
import org.jcamp.spectrum.SpectrumCursorEvent;
import org.jcamp.spectrum.SpectrumCursorEventMulticaster;
import org.jcamp.spectrum.SpectrumCursorListener;

public abstract class SpectrumCursor {
    protected transient SpectrumCursorListener aSpectrumCursorListener;
    Spectrum spectrum;
    int direction;
    int index = 0;

    SpectrumCursor(Spectrum spectrum, int direction, int index) {
        this.spectrum = spectrum;
        this.direction = direction;
        this.index = index;
    }

    public void addSpectrumCursorListener(SpectrumCursorListener newListener) {
        this.aSpectrumCursorListener = SpectrumCursorEventMulticaster.add(this.aSpectrumCursorListener, newListener);
        this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
    }

    protected void fireCursorPositionChanged(SpectrumCursorEvent event) {
        if (this.aSpectrumCursorListener == null) {
            return;
        }
        this.aSpectrumCursorListener.cursorPositionChanged(event);
    }

    public int getDirection() {
        return this.direction;
    }

    public int getIndex() {
        return this.index;
    }

    public abstract double getPosition();

    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    public abstract void next();

    public abstract void previous();

    public void removeSpectrumCursorListener(SpectrumCursorListener newListener) {
        this.aSpectrumCursorListener = SpectrumCursorEventMulticaster.remove(this.aSpectrumCursorListener, newListener);
    }

    public abstract void toPosition(double var1);

    public static class Y
    extends SpectrumCursor {
        public Y(Spectrum2D spectrum) {
            super(spectrum, 1, 0);
        }

        @Override
        public void next() {
            if (this.index < ((Spectrum2D)this.spectrum).getYData().getLength() - 1) {
                ++this.index;
                this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
            }
        }

        @Override
        public void previous() {
            if (this.index > 0) {
                --this.index;
                this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
            }
        }

        @Override
        public void toPosition(double y) {
            this.index = ((Spectrum2D)this.spectrum).getYData().indexAt(y);
            if (this.index < 0) {
                this.index = 0;
            }
            if (this.index > ((Spectrum2D)this.spectrum).getYData().getLength() - 1) {
                this.index = ((Spectrum2D)this.spectrum).getYData().getLength() - 1;
            }
            this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
        }

        @Override
        public double getPosition() {
            return ((Spectrum2D)this.spectrum).getYData().pointAt(this.index);
        }
    }

    public static class X
    extends SpectrumCursor {
        public X(Spectrum spectrum) {
            super(spectrum, 0, 0);
        }

        @Override
        public void next() {
            if (this.index < ((Spectrum1D)this.spectrum).getXData().getLength() - 1) {
                ++this.index;
                this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
            }
        }

        @Override
        public void previous() {
            if (this.index > 0) {
                --this.index;
                this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
            }
        }

        @Override
        public void toPosition(double x) {
            this.index = ((Spectrum1D)this.spectrum).getXData().indexAt(x);
            if (this.index < 0) {
                this.index = 0;
            }
            if (this.index > ((Spectrum1D)this.spectrum).getYData().getLength() - 1) {
                this.index = ((Spectrum1D)this.spectrum).getYData().getLength() - 1;
            }
            this.fireCursorPositionChanged(new SpectrumCursorEvent(this));
        }

        @Override
        public double getPosition() {
            return ((Spectrum1D)this.spectrum).getXData().pointAt(this.index);
        }
    }
}

