/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum.notes;

import org.jcamp.spectrum.notes.BadContentException;
import org.jcamp.spectrum.notes.INoteContentParser;

public class DefaultNoteContentParser
implements INoteContentParser {
    private static final DefaultNoteContentParser theInstance = new DefaultNoteContentParser();

    private DefaultNoteContentParser() {
    }

    public static final DefaultNoteContentParser getInstance() {
        return theInstance;
    }

    @Override
    public Object parseContent(String content, Class resultClass) throws BadContentException {
        if (String.class.equals((Object)resultClass)) {
            return content;
        }
        if (Integer.class.equals((Object)resultClass)) {
            try {
                return new Integer(content);
            }
            catch (NumberFormatException ex) {
                throw new BadContentException("expecting integer but got: " + content);
            }
        }
        if (Double.class.equals((Object)resultClass)) {
            try {
                return new Double(content);
            }
            catch (NumberFormatException ex) {
                throw new BadContentException("expecting double but got: " + content);
            }
        }
        if (Boolean.class.equals((Object)resultClass)) {
            try {
                return new Boolean(content);
            }
            catch (Exception ex) {
                throw new BadContentException("expecting boolean (true/false) but got: " + content);
            }
        }
        if (Float.class.equals((Object)resultClass)) {
            try {
                return new Float(content);
            }
            catch (NumberFormatException ex) {
                throw new BadContentException("expecting float but got: " + content);
            }
        }
        if (Byte.class.equals((Object)resultClass)) {
            try {
                return new Byte(content);
            }
            catch (NumberFormatException ex) {
                throw new BadContentException("expecting byte but got: " + content);
            }
        }
        return content;
    }
}

