/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.spectrum.notes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.jcamp.spectrum.notes.NoteDescriptor;

public class Note
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8692106189365309099L;
    private Object fieldValue = null;
    protected transient PropertyChangeSupport propertyChange;
    private NoteDescriptor fieldDescriptor = NoteDescriptor.IGNORE;

    public Note() {
    }

    public Note(NoteDescriptor desc, Object value) {
        this.setDescriptor(desc);
        this.setValue(value);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(propertyName, listener);
    }

    public Object clone() {
        Note note = null;
        try {
            note = (Note)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        note.fieldDescriptor = (NoteDescriptor)this.fieldDescriptor.clone();
        return note;
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.getPropertyChange().firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public NoteDescriptor getDescriptor() {
        return this.fieldDescriptor;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public Object getValue() {
        return this.fieldValue;
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.getPropertyChange().hasListeners(propertyName);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(propertyName, listener);
    }

    public void setDescriptor(NoteDescriptor descriptor) {
        this.fieldDescriptor = descriptor;
    }

    public void setValue(Object value) {
        Object oldValue = this.fieldValue;
        this.fieldValue = value;
        if (oldValue == value) {
            return;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.firePropertyChange("value", oldValue, value);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("[").append(this.getDescriptor().toString()).append("] ");
        if (this.fieldValue != null) {
            tmp.append("\"").append(this.fieldValue.toString()).append("\"");
        } else {
            tmp.append("null");
        }
        return tmp.toString();
    }
}

