/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public final class BaseUnit
extends Unit {
    private static final long serialVersionUID = 8264659001185423752L;
    private String name;
    private String symbol;
    private String quantity;
    public static final BaseUnit generic = new BaseUnit("Arbitrary Unit", "", "");
    public static final BaseUnit ampere = new BaseUnit("Electric Current", "ampere", "A");
    public static final BaseUnit candela = new BaseUnit("Luminous Intensity", "candela", "cd");
    public static final BaseUnit kelvin = new BaseUnit("Temperature", "kelvin", "K");
    public static final BaseUnit kilogram = new BaseUnit("Mass", "kilogram", "kg");
    public static final BaseUnit meter = new BaseUnit("Length", "meter", "m");
    public static final BaseUnit second = new BaseUnit("Time", "second", "s");
    public static final BaseUnit mole = new BaseUnit("Amount of Substance", "mole", "mol");
    public static final BaseUnit radian = new BaseUnit("Angle", "radian", "rad");
    public static final BaseUnit steradian = new BaseUnit("Solid Angle", "steradian", "sr");

    protected BaseUnit(String quantity, String name, String symbol) {
        super(symbol, name);
        this.quantity = quantity;
        this.name = name;
        this.symbol = symbol;
    }

    @Override
    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.equals(generic)) {
            return value;
        }
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof BaseUnit) {
                return value;
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.equals(generic)) {
            return value;
        }
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof BaseUnit) {
                return value;
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BaseUnit) {
            BaseUnit base = (BaseUnit)o;
            if (this.getIdentifier() == base.getIdentifier()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuantity() {
        return this.quantity;
    }

    @Override
    public final double getScaleFactor() {
        return 1.0;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isConvertibleTo(Unit thatUnit) {
        if (this.equals(generic)) {
            return true;
        }
        if (this.equals(thatUnit)) {
            return true;
        }
        return thatUnit.isConvertibleTo(this);
    }
}

