/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.BaseUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;
import org.jcamp.units.UnitFactor;

public final class DerivedUnit
extends Unit {
    private static final long serialVersionUID = -6912254468800545391L;
    String quantity = null;
    String name = null;
    String symbol = null;
    UnitFactor[] factors;

    public DerivedUnit() {
        super("");
        this.factors = new UnitFactor[0];
        this.name = "";
        this.quantity = "";
        this.symbol = "";
    }

    public DerivedUnit(BaseUnit[] baseUnits, int[] powers, String quantity, String name, String symbol) {
        this(DerivedUnit.makeFactors(baseUnits, powers), DerivedUnit.makeID(quantity, name, symbol), name);
        this.name = name;
        this.symbol = symbol;
        this.quantity = quantity;
    }

    private DerivedUnit(UnitFactor[] factors, String identifier) {
        super(identifier);
        this.factors = factors;
    }

    private DerivedUnit(UnitFactor[] factors, String identifier, String alias) {
        super(identifier, alias);
        this.factors = factors;
    }

    public DerivedUnit(String quantity, String name, String symbol) {
        super(DerivedUnit.makeID(quantity, name, symbol), name);
        this.factors = new UnitFactor[0];
        this.quantity = quantity;
        this.name = name;
        this.symbol = symbol;
    }

    @Override
    public Object clone() {
        DerivedUnit unit = (DerivedUnit)super.clone();
        for (int i = 0; i < this.factors.length; ++i) {
            unit.factors[i] = (UnitFactor)this.factors[i].clone();
        }
        return unit;
    }

    @Override
    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DerivedUnit) {
                return value;
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DerivedUnit) {
                return value;
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuantity() {
        return this.quantity;
    }

    @Override
    public final double getScaleFactor() {
        return 1.0;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isConvertibleTo(Unit thatUnit) {
        if (thatUnit instanceof DerivedUnit) {
            DerivedUnit thatDerived = (DerivedUnit)thatUnit;
            if (this.factors.length == thatDerived.factors.length) {
                for (int i = 0; i < this.factors.length; ++i) {
                    if (this.factors[i].equals(thatDerived.factors[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (thatUnit instanceof BaseUnit) {
            return false;
        }
        return thatUnit.isConvertibleTo(this);
    }

    private static UnitFactor[] makeFactors(BaseUnit[] baseUnits, int[] powers) {
        int n = baseUnits.length;
        UnitFactor[] factors = new UnitFactor[n];
        for (int i = 0; i < n; ++i) {
            factors[i] = new UnitFactor(baseUnits[i], powers[i]);
        }
        return factors;
    }

    private static String makeID(String quantity, String name, String symbol) {
        if (symbol != null && symbol.length() > 0) {
            return symbol;
        }
        if (name != null && name.length() > 0) {
            return name;
        }
        return quantity;
    }
}

