/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.BaseUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public final class DimensionlessUnit
extends Unit {
    private static final long serialVersionUID = -744159462713730383L;
    String quantity;
    String name;
    String symbol;

    public DimensionlessUnit(String quantity, String name, String symbol) {
        super(quantity, name);
        this.quantity = quantity;
        this.name = name;
        this.symbol = symbol;
    }

    @Override
    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DimensionlessUnit || thatUnit.equals(BaseUnit.generic)) {
                return value;
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof DimensionlessUnit || thatUnit.equals(BaseUnit.generic)) {
                return value;
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuantity() {
        return this.quantity;
    }

    @Override
    final double getScaleFactor() {
        return 1.0;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isConvertibleTo(Unit thatUnit) {
        return BaseUnit.generic.isConvertibleTo(thatUnit);
    }
}

