/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import org.jcamp.units.BaseUnit;
import org.jcamp.units.DerivedUnit;
import org.jcamp.units.ScaledUnit;
import org.jcamp.units.Unit;
import org.jcamp.units.UnitException;

public final class OffsetUnit
extends Unit {
    private static final long serialVersionUID = 7394622355294421470L;
    Unit unit;
    double offset;
    String symbol;
    String name;

    @Override
    public Object clone() {
        OffsetUnit unit = (OffsetUnit)super.clone();
        unit.unit = (Unit)this.unit.clone();
        return unit;
    }

    public OffsetUnit(BaseUnit unit, double offset, String name, String symbol) {
        this((Unit)unit, offset, name, symbol);
    }

    public OffsetUnit(DerivedUnit unit, double offset, String name, String symbol) {
        this((Unit)unit, offset, name, symbol);
    }

    public OffsetUnit(ScaledUnit unit, double offset, String name, String symbol) {
        this((Unit)unit, offset, name, symbol);
    }

    private OffsetUnit(Unit unit, double offset, String name, String symbol) {
        super(name, symbol);
        this.unit = unit;
        this.offset = offset;
        this.name = name;
        this.symbol = symbol;
    }

    @Override
    public double convertFrom(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof ScaledUnit || thatUnit instanceof BaseUnit || thatUnit instanceof DerivedUnit) {
                return value * thatUnit.getScaleFactor() / this.getScaleFactor() - this.offset;
            }
            return thatUnit.convertTo(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public double convertTo(double value, Unit thatUnit) throws UnitException {
        if (this.isConvertibleTo(thatUnit)) {
            if (thatUnit instanceof ScaledUnit || thatUnit instanceof BaseUnit || thatUnit instanceof DerivedUnit) {
                return value * thatUnit.getScaleFactor() / this.getScaleFactor() + this.offset;
            }
            return thatUnit.convertFrom(value, this);
        }
        throw new UnitException("units not convertible");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuantity() {
        return this.unit.getQuantity();
    }

    @Override
    public double getScaleFactor() {
        return this.unit.getScaleFactor();
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isConvertibleTo(Unit thatUnit) {
        if (thatUnit instanceof OffsetUnit) {
            return this.unit.isConvertibleTo(((OffsetUnit)thatUnit).unit);
        }
        if (thatUnit instanceof ScaledUnit) {
            return this.unit.isConvertibleTo(((ScaledUnit)thatUnit).unit);
        }
        if (thatUnit instanceof BaseUnit) {
            return this.unit.isConvertibleTo((BaseUnit)thatUnit);
        }
        if (thatUnit instanceof DerivedUnit) {
            return this.unit.isConvertibleTo((DerivedUnit)thatUnit);
        }
        return false;
    }
}

