/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.units;

import java.io.Serializable;
import java.util.Hashtable;
import org.jcamp.units.AliasUnit;
import org.jcamp.units.CommonUnit;
import org.jcamp.units.SIUnitScale;
import org.jcamp.units.ScaledUnit;
import org.jcamp.units.UnitException;

public abstract class Unit
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6839485344921903829L;
    private static Hashtable idMap = new Hashtable();
    private static Hashtable aliasMap = new Hashtable();
    private final String identifier;

    protected Unit(String identifier) {
        if (identifier != null && identifier.length() > 0) {
            identifier.replace(' ', '_');
        }
        this.identifier = identifier.toUpperCase();
        idMap.put(this.identifier, this);
    }

    protected Unit(String identifier, String alias) {
        if (identifier != null && identifier.length() > 0) {
            identifier.replace(' ', '_');
        }
        this.identifier = identifier.toUpperCase();
        idMap.put(this.identifier, this);
        Unit.addAlias(this, alias);
    }

    public static void addAlias(Unit unit, String alias) {
        if (alias != null && alias.length() > 0) {
            String key = alias.toUpperCase();
            key.replace(' ', '_');
            if (aliasMap.get(key) == null) {
                aliasMap.put(key, unit);
            }
        }
    }

    public Object clone() {
        Unit unit = null;
        try {
            unit = (Unit)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return unit;
    }

    public abstract double convertFrom(double var1, Unit var3) throws UnitException;

    public abstract double convertTo(double var1, Unit var3) throws UnitException;

    public boolean equals(Object obj) {
        Unit unit;
        return obj instanceof Unit && (unit = (Unit)obj).getIdentifier().equals(this.identifier);
    }

    static Unit getBaseUnitFromKey(String id) {
        int n = SIUnitScale.prefixes.length;
        for (int i = 0; i < n; ++i) {
            Unit unit;
            String prefix = SIUnitScale.prefixes[i].getName().toUpperCase();
            if (id.startsWith(prefix) && (unit = Unit.getUnitFromKey(id.substring(prefix.length()))) != null) {
                return new ScaledUnit(unit, SIUnitScale.prefixes[i]);
            }
            prefix = SIUnitScale.prefixes[i].getPrefix().toUpperCase();
            if (!id.startsWith(prefix) || (unit = Unit.getUnitFromKey(id.substring(prefix.length()))) == null) continue;
            return new ScaledUnit(unit, SIUnitScale.prefixes[i]);
        }
        return null;
    }

    final String getIdentifier() {
        return this.identifier;
    }

    public abstract String getName();

    public abstract String getQuantity();

    abstract double getScaleFactor();

    public abstract String getSymbol();

    static Unit getUnitFromKey(String key) {
        Unit unit = (Unit)idMap.get(key);
        if (unit == null) {
            unit = (Unit)aliasMap.get(key);
        }
        return unit;
    }

    public static Unit getUnitFromString(String id) {
        String key = id.toUpperCase();
        Unit unit = Unit.getUnitFromKey(key);
        if (unit == null) {
            unit = Unit.getBaseUnitFromKey(key);
        }
        if (unit == null) {
            String skey;
            if (key.endsWith("ES") && key.length() > 5 && (unit = Unit.getUnitFromKey(skey = key.substring(0, key.length() - 2))) == null) {
                unit = Unit.getBaseUnitFromKey(skey);
            }
            if (unit == null && key.endsWith("S") && key.length() > 4 && (unit = Unit.getUnitFromKey(skey = key.substring(0, key.length() - 1))) == null) {
                unit = Unit.getBaseUnitFromKey(skey);
            }
        }
        if (unit == null) {
            return new AliasUnit(CommonUnit.generic, id);
        }
        return unit;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    private static void initHashtables() {
        try {
            Class.forName("org.jcamp.units.BaseUnit");
            Class.forName("org.jcamp.units.CommonUnit");
        }
        catch (ClassNotFoundException e) {
            System.err.println("predefined units not available");
        }
    }

    public abstract boolean isConvertibleTo(Unit var1);

    public final String toString() {
        String s = this.getSymbol();
        if (s == null || s.length() == 0) {
            s = this.getName();
        }
        if (s == null || s.length() == 0) {
            s = this.getIdentifier();
        }
        return s;
    }

    static {
        Unit.initHashtables();
    }
}

