/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks;

import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import com.googlecode.jfilechooserbookmarks.AbstractBookmarksManager;
import com.googlecode.jfilechooserbookmarks.AbstractFactory;
import com.googlecode.jfilechooserbookmarks.AbstractIconLoader;
import com.googlecode.jfilechooserbookmarks.Bookmark;
import com.googlecode.jfilechooserbookmarks.Communication;
import com.googlecode.jfilechooserbookmarks.JFileChooserCommunication;
import com.googlecode.jfilechooserbookmarks.gui.BaseList;
import com.googlecode.jfilechooserbookmarks.gui.BasePanel;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import com.googlecode.jfilechooserbookmarks.gui.GUIHelper;
import com.googlecode.jfilechooserbookmarks.gui.MouseUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractBookmarksPanel
extends BasePanel {
    private static final long serialVersionUID = -1969362821325599909L;
    public static final int MAX_PATH_LENGTH = 1024;
    protected Communication m_Owner;
    protected BaseList m_ListBookmarks;
    protected DefaultListModel m_ModelBookmarks;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;
    protected JButton m_ButtonCopy;
    protected JButton m_ButtonPaste;
    protected PropertyChangeListener m_DirChangeListener;
    protected boolean m_SkipDirectoryChanges;
    protected AbstractFactory m_Factory;
    protected AbstractIconLoader m_IconLoader;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("directoryChanged") && !AbstractBookmarksPanel.this.m_SkipDirectoryChanges) {
                    AbstractBookmarksPanel.this.m_ListBookmarks.clearSelection();
                }
            }
        };
        this.m_Factory = this.newFactory();
        this.m_IconLoader = this.m_Factory.newIconLoader();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ModelBookmarks = this.loadBookmarks();
        this.m_ListBookmarks = new BaseList((ListModel)this.m_ModelBookmarks);
        this.m_ListBookmarks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = AbstractBookmarksPanel.this.getPopupMenu(e);
                    if (menu != null) {
                        menu.show(AbstractBookmarksPanel.this.m_ListBookmarks, e.getX(), e.getY());
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_ListBookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractBookmarksPanel.this.updateButtons();
                if (AbstractBookmarksPanel.this.m_Owner == null) {
                    return;
                }
                if (AbstractBookmarksPanel.this.m_ListBookmarks.getSelectedIndices().length != 1) {
                    return;
                }
                Bookmark bookmark = (Bookmark)AbstractBookmarksPanel.this.m_ListBookmarks.getSelectedValue();
                if (!bookmark.getDirectory().exists()) {
                    return;
                }
                AbstractBookmarksPanel.this.m_SkipDirectoryChanges = true;
                AbstractBookmarksPanel.this.m_Owner.setCurrentDirectory(bookmark.getDirectory().getAbsoluteFile());
                AbstractBookmarksPanel.this.m_Owner.ensureFileIsVisible(bookmark.getDirectory().getAbsoluteFile());
                AbstractBookmarksPanel.this.m_SkipDirectoryChanges = false;
            }
        });
        this.add((Component)new BaseScrollPane(this.m_ListBookmarks), "Center");
        this.m_PanelButtons = new JPanel(new GridLayout(1, 0));
        this.add((Component)this.m_PanelButtons, "South");
        this.m_ButtonAdd = new JButton(this.m_IconLoader.getAdd());
        this.m_ButtonAdd.setToolTipText("Adds the current directory as bookmark");
        this.m_ButtonAdd.setContentAreaFilled(false);
        this.m_ButtonAdd.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonAdd.setBackground(this.getBackground());
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.addBookmark();
            }
        });
        this.m_PanelButtons.add(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton(this.m_IconLoader.getRemove());
        this.m_ButtonRemove.setToolTipText("Removes the selected bookmark(s)");
        this.m_ButtonRemove.setContentAreaFilled(false);
        this.m_ButtonRemove.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.removeBookmark(AbstractBookmarksPanel.this.m_ListBookmarks.getSelectedIndices());
            }
        });
        this.m_PanelButtons.add(this.m_ButtonRemove);
        this.m_ButtonMoveUp = new JButton(this.m_IconLoader.getUp());
        this.m_ButtonMoveUp.setToolTipText("Moves the selected bookmark(s) up");
        this.m_ButtonMoveUp.setContentAreaFilled(false);
        this.m_ButtonMoveUp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractBookmarksPanel.this.m_ListBookmarks.canMoveUp()) {
                    AbstractBookmarksPanel.this.m_ListBookmarks.moveUp();
                }
                AbstractBookmarksPanel.this.saveBookmarks(AbstractBookmarksPanel.this.m_ModelBookmarks);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton(this.m_IconLoader.getDown());
        this.m_ButtonMoveDown.setToolTipText("Moves the selected bookmark(s) down");
        this.m_ButtonMoveDown.setContentAreaFilled(false);
        this.m_ButtonMoveDown.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractBookmarksPanel.this.m_ListBookmarks.canMoveDown()) {
                    AbstractBookmarksPanel.this.m_ListBookmarks.moveDown();
                }
                AbstractBookmarksPanel.this.saveBookmarks(AbstractBookmarksPanel.this.m_ModelBookmarks);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonMoveDown);
        this.m_ButtonCopy = new JButton(this.m_IconLoader.getCopy());
        this.m_ButtonCopy.setToolTipText("Copies the current directory to the clipboard");
        this.m_ButtonCopy.setContentAreaFilled(false);
        this.m_ButtonCopy.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.copyCurrentDirToClipboard();
            }
        });
        this.m_PanelButtons.add(this.m_ButtonCopy);
        this.m_ButtonPaste = new JButton(this.m_IconLoader.getPaste());
        this.m_ButtonPaste.setToolTipText("Pastes the current directory from the clipboard");
        this.m_ButtonPaste.setContentAreaFilled(false);
        this.m_ButtonPaste.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.pasteCurrentDirFromClipboard();
            }
        });
        this.m_PanelButtons.add(this.m_ButtonPaste);
    }

    public void setOwner(JFileChooser value) {
        this.setOwner(new JFileChooserCommunication(value));
    }

    public void setOwner(Communication value) {
        if (this.m_Owner != null) {
            this.m_Owner.removePropertyChangeListener(this.m_DirChangeListener);
        }
        this.m_Owner = value;
        this.m_Owner.addPropertyChangeListener(this.m_DirChangeListener);
    }

    public Communication getOwner() {
        return this.m_Owner;
    }

    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.m_Owner == null) {
            return null;
        }
        JPopupMenu result = new JPopupMenu();
        final int[] indices = this.m_ListBookmarks.getSelectedIndices();
        JMenuItem menuitem = new JMenuItem("Remove", this.m_IconLoader.getRemove());
        menuitem.setEnabled(indices.length > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.removeBookmark(indices);
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Rename", this.m_IconLoader.getRename());
        menuitem.setEnabled(indices.length == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractBookmarksPanel.this.renameBookmark(indices[0]);
            }
        });
        result.add(menuitem);
        return result;
    }

    protected Bookmark createUniqueBookmark(Bookmark bookmark, DefaultListModel model) {
        Bookmark result = bookmark;
        int count = 1;
        while (model.contains(result)) {
            result = new Bookmark(bookmark.getName() + ++count, bookmark.getDirectory());
        }
        return result;
    }

    protected void addBookmark() {
        Bookmark bookmark;
        if (this.m_Owner == null) {
            System.err.println("No owner set, cannot add boookmark!");
            return;
        }
        File[] files = this.m_Owner.getSelectedFiles();
        boolean added = false;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            added = true;
            bookmark = new Bookmark(file);
            this.m_ModelBookmarks.addElement(this.createUniqueBookmark(bookmark, this.m_ModelBookmarks));
        }
        if (!added) {
            bookmark = new Bookmark(this.m_Owner.getCurrentDirectory());
            this.m_ModelBookmarks.addElement(this.createUniqueBookmark(bookmark, this.m_ModelBookmarks));
        }
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected void removeBookmark(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ModelBookmarks.remove(indices[i]);
        }
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected void renameBookmark(int index) {
        Bookmark bookmark = (Bookmark)this.m_ModelBookmarks.get(index);
        String name = JOptionPane.showInputDialog(GUIHelper.getParentComponent(this), "Please enter a new name:", bookmark.getName());
        if (name == null || name.equals(bookmark.getName())) {
            return;
        }
        this.m_ModelBookmarks.set(index, new Bookmark(name, bookmark.getDirectory()));
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected DefaultListModel loadBookmarks() {
        DefaultListModel<Bookmark> result = new DefaultListModel<Bookmark>();
        List<Bookmark> list = this.getBookmarksManger().load();
        for (Bookmark item : list) {
            result.addElement(item);
        }
        return result;
    }

    protected boolean saveBookmarks(DefaultListModel model) {
        ArrayList<Bookmark> list = new ArrayList<Bookmark>();
        for (int i = 0; i < model.getSize(); ++i) {
            Bookmark bookmark = (Bookmark)model.get(i);
            list.add(bookmark);
        }
        return this.getBookmarksManger().save(list);
    }

    protected void copyCurrentDirToClipboard() {
        ClipboardHelper.copyToClipboard((String)this.m_Owner.getCurrentDirectory().getAbsolutePath());
    }

    protected boolean isValidPath(String dirStr) {
        if (dirStr == null) {
            return false;
        }
        if (dirStr.contains("\n") || dirStr.contains("\r")) {
            return false;
        }
        if (dirStr.length() > 1024) {
            return false;
        }
        File dir = new File(dirStr);
        return dir.exists() && dir.isDirectory();
    }

    protected void pasteCurrentDirFromClipboard() {
        String dirStr = ClipboardHelper.pasteStringFromClipboard();
        if (this.isValidPath(dirStr)) {
            this.m_Owner.setCurrentDirectory(new File(dirStr));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = (Dimension)super.getPreferredSize().clone();
        if (result.getWidth() > (double)this.m_PanelButtons.getPreferredSize().width) {
            result.width = this.m_PanelButtons.getPreferredSize().width;
        }
        return result;
    }

    public void updateButtons() {
        boolean hasBookmarks = this.m_ModelBookmarks.getSize() > 0;
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonMoveUp.setEnabled(hasBookmarks && this.m_ListBookmarks.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(hasBookmarks && this.m_ListBookmarks.canMoveDown());
        this.m_ButtonRemove.setEnabled(hasBookmarks && this.m_ListBookmarks.getSelectedIndices().length > 0);
        this.m_ButtonPaste.setEnabled(ClipboardHelper.canPasteStringFromClipboard() && this.isValidPath(ClipboardHelper.pasteStringFromClipboard()));
    }

    public void reload() {
        this.m_ModelBookmarks = this.loadBookmarks();
        this.m_ListBookmarks.setModel(this.m_ModelBookmarks);
    }

    protected abstract AbstractFactory newFactory();

    public synchronized AbstractBookmarksManager getBookmarksManger() {
        return this.m_Factory.getBookmarksManager();
    }
}

