/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks;

import java.io.File;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bookmark
implements Serializable,
Comparable<Bookmark> {
    private static final long serialVersionUID = 4284430561284693010L;
    protected String m_Name;
    protected File m_Directory;

    public Bookmark(File dir) {
        this(dir.getAbsoluteFile().getName(), dir);
    }

    public Bookmark(String name, File dir) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Directory cannot be null!");
        }
        this.m_Name = name;
        this.m_Directory = dir;
    }

    public String getName() {
        return this.m_Name;
    }

    public File getDirectory() {
        return this.m_Directory;
    }

    @Override
    public int compareTo(Bookmark o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bookmark) {
            return this.compareTo((Bookmark)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.m_Name;
    }
}

