/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks.gui;

import com.googlecode.jfilechooserbookmarks.core.Utils;
import com.googlecode.jfilechooserbookmarks.gui.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class BasePanel
extends JPanel {
    private static final long serialVersionUID = -6780889707840400801L;

    public BasePanel() {
        this(new BorderLayout());
    }

    public BasePanel(LayoutManager manager) {
        super(manager);
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
    }

    protected void initGUI() {
    }

    protected void finishInit() {
    }

    public Frame getParentFrame() {
        return GUIHelper.getParentFrame(this);
    }

    public Dialog getParentDialog() {
        return GUIHelper.getParentDialog(this);
    }

    public JInternalFrame getParentInternalFrame() {
        return GUIHelper.getParentInternalFrame(this);
    }

    public void closeParent() {
        GUIHelper.closeParent(this);
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    protected void beforeHide() {
    }

    protected void afterHide() {
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.beforeShow();
        } else {
            this.beforeHide();
        }
        super.setVisible(value);
        if (value) {
            this.afterShow();
        } else {
            this.afterHide();
        }
    }

    public String getParentTitle() {
        if (this.getParentDialog() != null) {
            return this.getParentDialog().getTitle();
        }
        if (this.getParentFrame() != null) {
            return this.getParentFrame().getTitle();
        }
        return null;
    }

    public void setParentTitle(String value) {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setTitle(value);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle(value);
        }
    }

    public void printErrorMessage(String msg) {
        System.err.println(msg);
    }

    public void printException(String msg, Exception e) {
        msg = this.getClass().getName() + ": " + msg + "\n" + Utils.throwableToString(e);
        System.err.println(msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("\nUsage: " + BasePanel.class.getName() + " <classname of BasePanel descendant>\n");
            System.exit(1);
        }
        BasePanel panel = (BasePanel)Class.forName(args[0]).newInstance();
        JFrame jf = new JFrame(panel.getClass().getName());
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add((Component)panel, "Center");
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setSize(800, 600);
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
    }
}

