/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    public static final String PROPERTY_VALUES = "values";
    public static final String PROPERTY_COMPARATOR = "comparator";
    public static final String PROPERTY_SORTED = "sorted";
    private List<T> _possibleValues = null;
    private List<Category<T>> _categoryValues = null;
    private Double minimum;
    private Double maximum;
    private Comparator<T> comparator = null;
    private boolean sorted = false;
    private boolean alreadySorted = false;
    private Map<T, Integer> positionIndices = new HashMap<T, Integer>();

    public CategoryRange() {
        this._possibleValues = new ArrayList<T>();
        this._categoryValues = new ArrayList<Category<T>>();
        this.alreadySorted = false;
    }

    public CategoryRange(T ... values) {
        this._possibleValues = new ArrayList<T>();
        this._possibleValues.addAll(Arrays.asList(values));
        this.alreadySorted = false;
    }

    public CategoryRange(Set<T> values) {
        this._possibleValues = new ArrayList<T>(values);
        this.alreadySorted = false;
    }

    public CategoryRange(CategoryRange<T> categoryRange) {
        this._categoryValues = new ArrayList<Category<T>>(categoryRange.getCategoryValues());
        this._possibleValues = new ArrayList<T>(categoryRange.getPossibleValues());
        this.comparator = categoryRange.getComparator();
        this.setMinimum(categoryRange.minimum());
        this.setMaximum(categoryRange.maximum());
        this.alreadySorted = false;
    }

    public List<T> getPossibleValues() {
        if (this.sorted && !this.alreadySorted) {
            if (this.comparator == null) {
                Comparator defaultComparator = new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        if (o1 instanceof Comparable) {
                            Comparable t1 = (Comparable)o1;
                            return t1.compareTo(o2);
                        }
                        String s1 = o1.toString();
                        String s2 = o2.toString();
                        return s1.compareTo(s2);
                    }
                };
                Collections.sort(this._possibleValues, defaultComparator);
                this.positionIndices.clear();
            } else {
                Collections.sort(this._possibleValues, this.comparator);
                this.positionIndices.clear();
            }
        }
        return this._possibleValues;
    }

    public Category<T> getCategory(int position) {
        if (position < 1) {
            throw new IllegalArgumentException("Supplied category index was " + position + " but it should be >= 1");
        }
        return this.getCategoryValues().get(position - 1);
    }

    public CategoryRange<T> add(Category<T> c) {
        if (!this.contains(c)) {
            if (this.comparator == null) {
                this._possibleValues.add(c.getValue());
                this._categoryValues.add(c);
            } else {
                this._possibleValues.add(c.getValue());
                this.alreadySorted = false;
                this._categoryValues = null;
            }
            c.setRange(this);
            this.firePropertyChange(PROPERTY_VALUES, null, this._possibleValues);
        }
        return this;
    }

    public void setSorted(boolean sorted) {
        boolean oldValue = this.sorted;
        this.sorted = sorted;
        if (sorted) {
            this._categoryValues = null;
        }
        this.positionIndices.clear();
        this.firePropertyChange(PROPERTY_SORTED, oldValue, sorted);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        Comparator<T> oldValue = this.comparator;
        this.comparator = comparator;
        this.setSorted(comparator != null);
        this.firePropertyChange(PROPERTY_COMPARATOR, oldValue, comparator);
    }

    @Override
    public Range<T> copy() {
        return new CategoryRange<T>(this);
    }

    @Override
    public T lower() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        return this._possibleValues.get(0);
    }

    @Override
    public T upper() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        int numElements = this._possibleValues.size();
        return this._possibleValues.get(numElements - 1);
    }

    @Override
    public void adjust(T lower, T upper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        if (this.maximum == null) {
            T upper = this.upper();
            if (upper == null) {
                return 1.0;
            }
            this.maximum = (double)this.position(upper) + 1.0;
        }
        return this.maximum;
    }

    @Override
    public double minimum() {
        if (this.minimum == null) {
            T lower = this.lower();
            if (lower == null) {
                return 0.0;
            }
            this.minimum = (double)this.position(lower) - 1.0;
        }
        return this.minimum;
    }

    public void reset() {
        this.maximum = null;
        this.minimum = null;
        this.positionIndices.clear();
    }

    public void setMinimum(double value) {
        Double oldValue = this.minimum;
        this.minimum = value;
        this.firePropertyChange("min", oldValue, value);
    }

    public void setMaximum(double value) {
        Double oldValue = this.maximum;
        this.maximum = value;
        this.firePropertyChange("max", oldValue, value);
    }

    @Override
    public double size() {
        if (this._possibleValues == null) {
            return 0.0;
        }
        int numElements = this._possibleValues.size();
        if (numElements == 0) {
            return 0.0;
        }
        return this.maximum() - this.minimum();
    }

    public int position(T value) {
        Integer index = this.positionIndices.get(value);
        if (index == null) {
            List<T> possibleValues = this.getPossibleValues();
            index = possibleValues.indexOf(value);
            if (index < 0) {
                throw new IllegalArgumentException("Value " + value + " not known");
            }
            this.positionIndices.put(value, index);
        }
        return 1 + index;
    }

    @Override
    public boolean contains(T x) {
        if (x == null) {
            return false;
        }
        for (T category : this._possibleValues) {
            if (!x.equals(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> value) {
        if (value == null) {
            return false;
        }
        for (Category<T> category : this.getCategoryValues()) {
            if (!value.equals(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this._categoryValues == null) {
            this._categoryValues = new ArrayList<Category<T>>();
            for (T value : this.getPossibleValues()) {
                this._categoryValues.add(new Category<T>(value, this));
            }
        }
        return this._categoryValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._categoryValues == null ? 0 : this._categoryValues.hashCode());
        result = 31 * result + (this._possibleValues == null ? 0 : this._possibleValues.hashCode());
        result = 31 * result + (this.maximum == null ? 0 : this.maximum.hashCode());
        result = 31 * result + (this.minimum == null ? 0 : this.minimum.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryRange other = (CategoryRange)obj;
        if (this._categoryValues == null ? other._categoryValues != null : !this._categoryValues.equals(other._categoryValues)) {
            return false;
        }
        if (this._possibleValues == null ? other._possibleValues != null : !this._possibleValues.equals(other._possibleValues)) {
            return false;
        }
        if (this.maximum == null ? other.maximum != null : !this.maximum.equals(other.maximum)) {
            return false;
        }
        return !(this.minimum == null ? other.minimum != null : !this.minimum.equals(other.minimum));
    }

    @Override
    public Range<T> createIntermediate(Range<T> target, double position) {
        CategoryRange<T> r;
        double sourceMin = this.minimum();
        double sourceMax = this.maximum();
        double targetMin = target.minimum();
        double targetMax = target.maximum();
        double min = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        if (position < 0.5) {
            r = new CategoryRange<T>(this);
        } else if (target instanceof CategoryRange) {
            r = new CategoryRange<T>((CategoryRange)target);
        } else {
            throw new IllegalArgumentException("Cannot create intermediate range from " + target.getClass());
        }
        r.setMinimum(min);
        r.setMaximum(max);
        return r;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("#<CategoryRange ");
        builder.append("minimum=");
        builder.append(this.minimum);
        builder.append(" maximum=");
        builder.append(this.maximum);
        builder.append(">");
        return builder.toString();
    }
}

