/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.jshell;

import com.github.fracpete.jshell.event.JShellErrorEvent;
import com.github.fracpete.jshell.event.JShellErrorListener;
import com.github.fracpete.jshell.event.JShellExecEvent;
import com.github.fracpete.jshell.event.JShellExecListener;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.ac.waikato.cms.core.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class JShellExec
implements Serializable,
StreamingProcessOwner {
    protected boolean m_Debug = false;
    protected Boolean m_Available = null;
    protected transient StreamingProcessOutput m_Execution = null;
    protected Set<JShellExecListener> m_JShellExecListeners = new HashSet<JShellExecListener>();
    protected Set<JShellErrorListener> m_JShellErrorListeners = new HashSet<JShellErrorListener>();
    protected StreamingProcessOwner m_StreamingProcessOwner = null;

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    protected void debugMsg(String msg) {
        if (this.m_Debug) {
            System.out.println("[DEBUG] " + msg);
        }
    }

    public void setStreamingProcessOwner(StreamingProcessOwner value) {
        this.m_StreamingProcessOwner = value;
    }

    public StreamingProcessOwner getStreamingProcessOwner() {
        return this.m_StreamingProcessOwner;
    }

    public boolean isRunning() {
        return this.m_Execution != null;
    }

    public void runScript(String code) {
        this.runScript(code, null, null, null);
    }

    public void runScript(String code, List<String> runtimeFlags, List<String> remoteRuntimeFlags, List<String> compilerFlags) {
        String msg;
        File tmpFile;
        this.stopScript();
        try {
            tmpFile = File.createTempFile("jshell-", ".jsh");
            this.debugMsg("tmpfile: " + tmpFile);
        }
        catch (Exception e) {
            this.showErrorMessage("Failed to create temporary file for script!\nCannot execute script!", e);
            this.notifyJShellExecListeners(new JShellExecEvent(this, JShellExecEvent.EventType.SCRIPT_RUN_SETUP_FAILURE));
            return;
        }
        if (!code.toLowerCase().contains("/exit")) {
            code = code + "\n/exit\n";
        }
        if ((msg = FileUtils.writeToFileMsg((String)tmpFile.getAbsolutePath(), (Object)code, (boolean)false, null)) != null) {
            tmpFile.delete();
            this.showErrorMessage("Failed to write script to temporary file: " + tmpFile + "\n" + msg);
            this.notifyJShellExecListeners(new JShellExecEvent(this, JShellExecEvent.EventType.SCRIPT_RUN_SETUP_FAILURE));
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getExecutable());
        cmd.add("--class-path");
        cmd.add(System.getProperty("java.class.path"));
        if (runtimeFlags != null) {
            for (String runtimeFlag : runtimeFlags) {
                cmd.add("-J" + runtimeFlag);
            }
        }
        if (remoteRuntimeFlags != null) {
            for (String remoteRuntimeFlag : remoteRuntimeFlags) {
                cmd.add("-R" + remoteRuntimeFlag);
            }
        }
        if (compilerFlags != null) {
            for (String compilerFlag : compilerFlags) {
                cmd.add("-C" + compilerFlag);
            }
        }
        cmd.add(tmpFile.getAbsolutePath());
        this.debugMsg("Command: " + cmd);
        final ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        this.m_Execution = new StreamingProcessOutput((StreamingProcessOwner)this);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    JShellExec.this.m_Execution.monitor(builder);
                    if (JShellExec.this.m_Execution.getExitCode() != 0) {
                        JShellExec.this.notifyJShellExecListeners(new JShellExecEvent(JShellExec.this, JShellExecEvent.EventType.SCRIPT_RUN_FAILURE));
                    } else {
                        JShellExec.this.notifyJShellExecListeners(new JShellExecEvent(JShellExec.this, JShellExecEvent.EventType.SCRIPT_RUN_SUCCESS));
                    }
                }
                catch (Throwable t) {
                    JShellExec.this.showErrorMessage("Failed to execute script!", t);
                    JShellExec.this.notifyJShellExecListeners(new JShellExecEvent(JShellExec.this, JShellExecEvent.EventType.SCRIPT_RUN_FAILURE));
                }
                JShellExec.this.m_Execution = null;
                JShellExec.this.notifyJShellExecListeners(new JShellExecEvent(JShellExec.this, JShellExecEvent.EventType.SCRIPT_FINISHED));
                tmpFile.delete();
            }
        };
        new Thread(run).start();
        this.notifyJShellExecListeners(new JShellExecEvent(this, JShellExecEvent.EventType.SCRIPT_RUN));
    }

    public void stopScript() {
        if (this.m_Execution != null) {
            this.m_Execution.destroy();
            this.m_Execution = null;
            this.notifyJShellExecListeners(new JShellExecEvent(this, JShellExecEvent.EventType.SCRIPT_STOP));
        }
    }

    public String getExecutable() {
        String home = System.getProperty("java.home");
        String result = home + File.separator + "bin" + File.separator + "jshell";
        if (SystemUtils.IS_OS_WINDOWS) {
            result = result + ".exe";
        }
        return result;
    }

    public boolean isAvailable() {
        if (this.m_Available == null) {
            this.m_Available = JavaVersion.JAVA_RECENT.atLeast(JavaVersion.JAVA_9) && new File(this.getExecutable()).exists() && !System.getProperty("java.class.path").isEmpty();
        }
        return this.m_Available;
    }

    public StreamingProcessOutputType getOutputType() {
        if (this.m_StreamingProcessOwner != null) {
            return this.m_StreamingProcessOwner.getOutputType();
        }
        return StreamingProcessOutputType.BOTH;
    }

    public void processOutput(String line, boolean stdout) {
        if (this.m_StreamingProcessOwner != null) {
            this.m_StreamingProcessOwner.processOutput(line, stdout);
        } else if (stdout) {
            System.out.println(line);
        } else {
            System.err.println(line);
        }
    }

    public void showErrorMessage(String msg) {
        this.showErrorMessage(msg, null);
    }

    public void showErrorMessage(String msg, Throwable t) {
        if (this.m_JShellErrorListeners.isEmpty()) {
            System.err.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        } else {
            this.notifyJShellErrorListeners(new JShellErrorEvent(this, msg, t));
        }
    }

    public void addJShellExecListener(JShellExecListener l) {
        this.m_JShellExecListeners.add(l);
    }

    public void removeJShellExecListener(JShellExecListener l) {
        this.m_JShellExecListeners.remove(l);
    }

    public synchronized void notifyJShellExecListeners(JShellExecEvent e) {
        this.debugMsg("ExecEvent: " + e.toString());
        for (JShellExecListener l : this.m_JShellExecListeners) {
            l.jshellExecEventOccurred(e);
        }
    }

    public void addJShellErrorListener(JShellErrorListener l) {
        this.m_JShellErrorListeners.add(l);
    }

    public void removeJShellErrorListener(JShellErrorListener l) {
        this.m_JShellErrorListeners.remove(l);
    }

    public synchronized void notifyJShellErrorListeners(JShellErrorEvent e) {
        this.debugMsg("Error: " + e.getMessage() + (e.hasException() ? "" : "\n" + e.getException()));
        for (JShellErrorListener l : this.m_JShellErrorListeners) {
            l.jshellErrorOccurred(e);
        }
    }
}

