/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.jshell;

import com.github.fracpete.jshell.JShellExec;
import com.github.fracpete.jshell.event.JShellErrorEvent;
import com.github.fracpete.jshell.event.JShellErrorListener;
import com.github.fracpete.jshell.event.JShellExecEvent;
import com.github.fracpete.jshell.event.JShellExecListener;
import com.github.fracpete.jshell.event.JShellPanelEvent;
import com.github.fracpete.jshell.event.JShellPanelListener;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import nz.ac.waikato.cms.core.FileUtils;
import nz.ac.waikato.cms.core.Utils;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;
import nz.ac.waikato.cms.gui.core.BaseFrame;
import nz.ac.waikato.cms.gui.core.BasePanel;
import nz.ac.waikato.cms.gui.core.ExtensionFileFilter;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class JShellPanel
extends BasePanel
implements StreamingProcessOwner,
JShellErrorListener,
JShellExecListener {
    public static final String[] THEMES = new String[]{"dark", "default", "default-alt", "eclipse", "idea", "monokai", "vs"};
    public static final String DEFAULT_THEME = "default";
    protected JSplitPane m_SplitPane;
    protected JComboBox<String> m_ComboBoxThemes;
    protected RSyntaxTextArea m_TextCode;
    protected BaseFileChooser m_FileChooserScript;
    protected JButton m_ButtonScriptLoad;
    protected JButton m_ButtonScriptSave;
    protected JButton m_ButtonScriptRun;
    protected JButton m_ButtonScriptStop;
    protected BaseFileChooser m_FileChooserOutput;
    protected JButton m_ButtonOutputClear;
    protected JButton m_ButtonOutputSave;
    protected JTextArea m_TextOutput;
    protected JShellExec m_Exec;
    protected Set<JShellPanelListener> m_JShellPanelListeners;
    protected List<String> m_RuntimeFlags;
    protected List<String> m_RemoteRuntimeFlags;
    protected List<String> m_CompilerFlags;

    protected void initialize() {
        this.m_FileChooserScript = new BaseFileChooser();
        this.m_FileChooserScript.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("JShell script", new String[]{"jsh", "jshell"}));
        this.m_FileChooserScript.setAcceptAllFileFilterUsed(true);
        this.m_FileChooserOutput = new BaseFileChooser();
        this.m_FileChooserOutput.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("Text file", "txt"));
        this.m_FileChooserOutput.setAcceptAllFileFilterUsed(true);
        this.m_Exec = new JShellExec();
        this.m_Exec.addJShellErrorListener(this);
        this.m_Exec.addJShellExecListener(this);
        this.m_Exec.setStreamingProcessOwner(this);
        this.m_JShellPanelListeners = new HashSet<JShellPanelListener>();
        this.m_RuntimeFlags = new ArrayList<String>();
        this.m_RemoteRuntimeFlags = new ArrayList<String>();
        this.m_CompilerFlags = new ArrayList<String>();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        if (!this.isAvailable()) {
            JPanel panel = new JPanel(new FlowLayout(1));
            this.add(panel, "Center");
            JLabel label = new JLabel("jshell executable not found (Java 9+ only) - scripting disabled!");
            panel.add(label);
            return;
        }
        this.m_SplitPane = new JSplitPane(0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add(this.m_SplitPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.m_SplitPane.setTopComponent(panel);
        this.m_TextCode = new RSyntaxTextArea(10, 80);
        this.m_TextCode.setSyntaxEditingStyle("text/java");
        this.m_TextCode.setLineWrap(false);
        this.m_TextCode.setAutoIndentEnabled(true);
        this.m_TextCode.setAntiAliasingEnabled(true);
        this.m_TextCode.setCodeFoldingEnabled(true);
        this.m_TextCode.setBracketMatchingEnabled(false);
        this.m_TextCode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JShellPanel.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JShellPanel.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JShellPanel.this.updateButtons();
            }
        });
        panel.add((Component)new RTextScrollPane((RTextArea)this.m_TextCode), "Center");
        JPanel panelTop = new JPanel(new BorderLayout());
        panel.add((Component)panelTop, "North");
        JPanel panelText = new JPanel(new FlowLayout(0));
        panelTop.add((Component)panelText, "West");
        JLabel label = new JLabel("JShell");
        panelText.add(label);
        JPanel panelThemes = new JPanel(new FlowLayout(2));
        panelTop.add((Component)panelThemes, "East");
        this.m_ComboBoxThemes = new JComboBox<String>(THEMES);
        this.m_ComboBoxThemes.setSelectedItem(DEFAULT_THEME);
        this.m_ComboBoxThemes.addActionListener(e -> this.updateTheme());
        label = new JLabel("Theme");
        label.setDisplayedMnemonic('T');
        label.setLabelFor(this.m_ComboBoxThemes);
        panelThemes.add(label);
        panelThemes.add(this.m_ComboBoxThemes);
        JPanel panelRight = new JPanel(new BorderLayout());
        panel.add((Component)panelRight, "East");
        JPanel panelButtons = new JPanel(new GridLayout(0, 1));
        panelRight.add((Component)panelButtons, "North");
        this.m_ButtonScriptLoad = new JButton(GUIHelper.getIcon((String)"open.gif"));
        this.m_ButtonScriptLoad.setToolTipText("Load script from file");
        this.m_ButtonScriptLoad.addActionListener(e -> this.loadScript());
        panelButtons.add(this.m_ButtonScriptLoad);
        this.m_ButtonScriptSave = new JButton(GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonScriptSave.setToolTipText("Save script to file");
        this.m_ButtonScriptSave.addActionListener(e -> this.saveScript());
        panelButtons.add(this.m_ButtonScriptSave);
        this.m_ButtonScriptRun = new JButton(GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonScriptRun.setToolTipText("Execute script");
        this.m_ButtonScriptRun.addActionListener(e -> this.runScript());
        panelButtons.add(this.m_ButtonScriptRun);
        this.m_ButtonScriptStop = new JButton(GUIHelper.getIcon((String)"stop.gif"));
        this.m_ButtonScriptStop.setToolTipText("Stop script");
        this.m_ButtonScriptStop.addActionListener(e -> this.stopScript());
        panelButtons.add(this.m_ButtonScriptStop);
        panel = new JPanel(new BorderLayout());
        this.m_SplitPane.setBottomComponent(panel);
        this.m_TextOutput = new JTextArea(20, 80);
        this.m_TextOutput.setFont(new Font("monospaced", 0, 10));
        panel.add((Component)new JScrollPane(this.m_TextOutput), "Center");
        panelText = new JPanel(new FlowLayout(0));
        panel.add((Component)panelText, "North");
        label = new JLabel("Output");
        panelText.add(label);
        panelRight = new JPanel(new BorderLayout());
        panel.add((Component)panelRight, "East");
        panelButtons = new JPanel(new GridLayout(0, 1));
        panelRight.add((Component)panelButtons, "North");
        this.m_ButtonOutputClear = new JButton(GUIHelper.getIcon((String)"new.gif"));
        this.m_ButtonOutputClear.setToolTipText("Clear output");
        this.m_ButtonOutputClear.addActionListener(e -> this.clearScriptOutput());
        panelButtons.add(this.m_ButtonOutputClear);
        this.m_ButtonOutputSave = new JButton(GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonOutputSave.setToolTipText("Save output to file");
        this.m_ButtonOutputSave.addActionListener(e -> this.saveScriptOutput());
        panelButtons.add(this.m_ButtonOutputSave);
    }

    protected void finishInit() {
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateTheme() {
        String themeURL = "org/fife/ui/rsyntaxtextarea/themes/" + this.m_ComboBoxThemes.getSelectedItem() + ".xml";
        InputStream in = ClassLoader.getSystemResourceAsStream(themeURL);
        try {
            Theme theme = Theme.load((InputStream)in);
            theme.apply(this.m_TextCode);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.closeQuietly((InputStream)in);
        }
    }

    public void setCurrentTheme(String value) {
        for (String theme : THEMES) {
            if (!value.equalsIgnoreCase(theme)) continue;
            this.m_ComboBoxThemes.setSelectedItem(theme);
            break;
        }
    }

    public String getCurrentTheme() {
        return (String)this.m_ComboBoxThemes.getSelectedItem();
    }

    public void setDebug(boolean value) {
        this.m_Exec.setDebug(value);
    }

    public boolean getDebug() {
        return this.m_Exec.getDebug();
    }

    public boolean isRunning() {
        return this.m_Exec.isRunning();
    }

    protected void updateButtons() {
        if (!this.isAvailable()) {
            return;
        }
        boolean running = this.isRunning();
        this.m_ButtonScriptLoad.setEnabled(!running);
        this.m_ButtonScriptSave.setEnabled(!running);
        this.m_ButtonScriptRun.setEnabled(!running && this.m_TextCode.getDocument().getLength() > 0);
        this.m_ButtonScriptStop.setEnabled(running);
        this.m_ButtonOutputClear.setEnabled(this.m_TextOutput.getDocument().getLength() > 0);
        this.m_ButtonOutputSave.setEnabled(this.m_TextOutput.getDocument().getLength() > 0);
    }

    public void loadScript() {
        int retVal = this.m_FileChooserScript.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.loadScript(this.m_FileChooserScript.getSelectedFile());
    }

    public void loadScript(File script) {
        try {
            List<String> lines = Files.readAllLines(script.toPath());
            this.m_TextCode.setText(Utils.flatten(lines, (String)"\n"));
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.SCRIPT_LOAD_SUCCESS));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to load script from: " + script), (Throwable)e);
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.SCRIPT_LOAD_FAILURE));
        }
        this.updateButtons();
    }

    public void saveScript() {
        int retVal = this.m_FileChooserScript.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        File script = this.m_FileChooserScript.getSelectedFile();
        String msg = FileUtils.writeToFileMsg((String)script.getAbsolutePath(), (Object)this.m_TextCode.getText(), (boolean)false, null);
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save script to : " + script + "\n" + msg));
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.SCRIPT_SAVE_FAILURE));
        } else {
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.SCRIPT_SAVE_SUCCESS));
        }
        this.updateButtons();
    }

    public void runScript() {
        this.m_Exec.runScript(this.m_TextCode.getText(), this.m_RuntimeFlags, this.m_RemoteRuntimeFlags, this.m_CompilerFlags);
        this.updateButtons();
    }

    public void stopScript() {
        this.m_Exec.stopScript();
        this.updateButtons();
    }

    public void clearScriptOutput() {
        this.m_TextOutput.setText("");
        this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.OUTPUT_CLEARED));
        this.updateButtons();
    }

    public void saveScriptOutput() {
        int retVal = this.m_FileChooserOutput.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        String msg = FileUtils.writeToFileMsg((String)this.m_FileChooserOutput.getSelectedFile().getAbsolutePath(), (Object)this.m_TextOutput.getText(), (boolean)false, null);
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg, (String)"Failed saving output");
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.OUTPUT_SAVE_FAILURE));
        } else {
            this.notifyJShellPanelListeners(new JShellPanelEvent(this, JShellPanelEvent.EventType.OUTPUT_SAVE_SUCESS));
        }
        this.updateButtons();
    }

    public String getCode() {
        return this.m_TextCode.getText();
    }

    public String getOutput() {
        return this.m_TextOutput.getText();
    }

    public boolean isAvailable() {
        return this.m_Exec.isAvailable();
    }

    public StreamingProcessOutputType getOutputType() {
        return StreamingProcessOutputType.BOTH;
    }

    public void processOutput(String line, boolean stdout) {
        boolean moveToEnd = this.m_TextOutput.getDocument().getLength() == this.m_TextOutput.getCaretPosition();
        this.m_TextOutput.append((stdout ? "[OUT] " : "[ERR] ") + line + "\n");
        if (moveToEnd) {
            this.m_TextOutput.setCaretPosition(this.m_TextOutput.getDocument().getLength());
        }
    }

    public void addJShellExecListener(JShellExecListener l) {
        this.m_Exec.addJShellExecListener(l);
    }

    public void removeJShellExecListener(JShellExecListener l) {
        this.m_Exec.removeJShellExecListener(l);
    }

    public void addJShellPanelListener(JShellPanelListener l) {
        this.m_JShellPanelListeners.add(l);
    }

    public void removeJShellExecListener(JShellPanelListener l) {
        this.m_JShellPanelListeners.remove(l);
    }

    public synchronized void notifyJShellPanelListeners(JShellPanelEvent e) {
        for (JShellPanelListener l : this.m_JShellPanelListeners) {
            l.jshellPanelEventOccurred(e);
        }
    }

    @Override
    public void jshellErrorOccurred(JShellErrorEvent e) {
        if (e.hasException()) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)e.getMessage(), (Throwable)e.getException());
        } else {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)e.getMessage());
        }
    }

    @Override
    public void jshellExecEventOccurred(JShellExecEvent e) {
        this.updateButtons();
    }

    public void setRuntimeFlags(List<String> value) {
        this.m_RuntimeFlags.clear();
        if (value != null) {
            this.m_RuntimeFlags.addAll(value);
        }
    }

    public List<String> getRuntimeFlags() {
        return this.m_RuntimeFlags;
    }

    public void setRemoteRuntimeFlags(List<String> value) {
        this.m_RemoteRuntimeFlags.clear();
        if (value != null) {
            this.m_RemoteRuntimeFlags.addAll(value);
        }
    }

    public List<String> getRemoteRuntimeFlags() {
        return this.m_RemoteRuntimeFlags;
    }

    public void setCompilerFlags(List<String> value) {
        this.m_CompilerFlags.clear();
        if (value != null) {
            this.m_CompilerFlags.addAll(value);
        }
    }

    public List<String> getCompilerFlags() {
        return this.m_CompilerFlags;
    }

    public static void main(String[] args) {
        JShellPanel panel = new JShellPanel();
        panel.addJShellExecListener(e -> System.out.println("exec: " + (Object)((Object)e.getType())));
        panel.addJShellPanelListener(e -> System.out.println("panel: " + (Object)((Object)e.getType())));
        BaseFrame frame = new BaseFrame("JShell");
        frame.setIconImage(GUIHelper.getIcon((String)"jshell.gif").getImage());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)panel), "Center");
        frame.setSize(1200, 900);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

