/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.latex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LaTeXMojo
extends AbstractMojo {
    public static final String DUMMY_TEMPLATE = "%PDF-1.1\n%\u00a5\u00b1\u00eb\n\n1 0 obj\n  << /Type /Catalog\n     /Pages 2 0 R\n  >>\nendobj\n\n2 0 obj\n  << /Type /Pages\n     /Kids [3 0 R]\n     /Count 1\n     /MediaBox [0 0 595 842]\n  >>\nendobj\n\n3 0 obj\n  <<  /Type /Page\n      /Parent 2 0 R\n      /Resources\n       << /Font\n           << /F1\n               << /Type /Font\n                  /Subtype /Type1\n                  /BaseFont /Times-Roman\n               >>\n           >>\n       >>\n      /Contents 4 0 R\n  >>\nendobj\n\n4 0 obj\n  << /Length 59 >>\nstream\n  BT\n    /F1 18 Tf\n    240 440 Td\n    ({NAME}) Tj\n  ET\nendstream\nendobj\n\nxref\n0 5\n0000000000 65535 f \n0000000018 00000 n \n0000000077 00000 n \n0000000178 00000 n \n0000000457 00000 n \ntrailer\n  <<  /Root 1 0 R\n      /Size 5\n  >>\nstartxref\n{STARTXREF}\n%%EOF\n";
    public static final int XREF_OFFSET = 558;
    public static final String PLACEHOLDER_NAME = "{NAME}";
    public static final String PLACEHOLDER_STARTXREF = "{STARTXREF}";
    private File docsRoot;
    private String commonsDirName;
    private File buildDir;
    private File latexBuildDir;
    private String binariesPath;
    private String bibtex;
    private boolean skipBuild;
    private boolean forceBuild;
    private boolean dummyBuild;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.docsRoot.exists()) {
                this.getLog().info((CharSequence)("Directory '" + this.docsRoot + "' does not exist, skipped!"));
                return;
            }
            if (this.skipBuild) {
                this.getLog().info((CharSequence)"Build skipped!");
                return;
            }
            File[] docDirs = this.getDocDirs();
            if (docDirs.length == 0) {
                this.getLog().info((CharSequence)("Directory '" + this.docsRoot + "' contains no sub-directories, skipped!"));
                return;
            }
            File[] buildDirs = this.prepareLaTeXBuildDirectories(docDirs);
            this.buildDocuments(buildDirs);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummyFile(String name) {
        this.getLog().info((CharSequence)("Generating dummy PDF (name): " + name));
        int startxref = 558 + name.length();
        this.getLog().info((CharSequence)("Generating dummy PDF (startxref): " + startxref));
        String pdf = DUMMY_TEMPLATE;
        pdf = pdf.replace(PLACEHOLDER_NAME, name);
        pdf = pdf.replace(PLACEHOLDER_STARTXREF, "" + startxref);
        BufferedWriter bwriter = null;
        FileWriter fwriter = null;
        File output = new File(this.buildDir, name + ".pdf");
        this.getLog().info((CharSequence)("Generating dummy PDF (output): " + output));
        try {
            fwriter = new FileWriter(output, false);
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(pdf);
            bwriter.flush();
        }
        catch (Exception e) {
            try {
                this.getLog().error((CharSequence)("Failed to generate dummy PDF: " + output), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bwriter);
                IOUtils.closeQuietly((Writer)fwriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)bwriter);
            IOUtils.closeQuietly((Writer)fwriter);
        }
        IOUtils.closeQuietly((Writer)bwriter);
        IOUtils.closeQuietly((Writer)fwriter);
    }

    private void buildDocuments(File[] buildDirs) throws IOException, MojoFailureException {
        for (File dir : buildDirs) {
            File texFile = new File(dir, dir.getName() + ".tex");
            File pdfFile = new File(dir, dir.getName() + ".pdf");
            File bibFile = new File(dir, dir.getName() + ".bib");
            if (this.dummyBuild) {
                this.createDummyFile(dir.getName());
                return;
            }
            if (!this.forceBuild && !this.requiresBuilding(dir, pdfFile)) continue;
            CommandLine pdfLaTeX = CommandLine.parse((String)this.executablePath("pdflatex")).addArgument("-shell-escape").addArgument("--halt-on-error").addArgument(texFile.getAbsolutePath());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("pdflatex: " + pdfLaTeX));
            }
            CommandLine bibTeX = CommandLine.parse((String)this.executablePath(this.bibtex)).addArgument(dir.getName());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("bibtex: " + bibTeX));
            }
            this.execute(pdfLaTeX, dir);
            if (bibFile.exists()) {
                this.execute(bibTeX, dir);
                this.execute(pdfLaTeX, dir);
            }
            this.execute(pdfLaTeX, dir);
            FileUtils.copyFile((File)pdfFile, (File)new File(this.buildDir, pdfFile.getName()));
        }
    }

    private boolean requiresBuilding(File dir, File pdfFile) throws IOException {
        Collection texFiles = FileUtils.listFiles((File)dir, (String[])new String[]{"tex", "bib"}, (boolean)true);
        this.getLog().info((CharSequence)texFiles.toString());
        if (pdfFile.exists()) {
            boolean upToDate = true;
            Iterator it = texFiles.iterator();
            while (it.hasNext() && upToDate) {
                File file = (File)it.next();
                if (FileUtils.isFileNewer((File)file, (File)pdfFile)) {
                    if (this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)("Changes detected on " + file.getAbsolutePath()));
                    }
                    return true;
                }
                if (!this.getLog().isInfoEnabled()) continue;
                this.getLog().info((CharSequence)("No change detected on " + file.getAbsolutePath()));
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Skipping: no LaTeX changes detected in " + dir.getCanonicalPath()));
            }
            return false;
        }
        return true;
    }

    private String executablePath(String executable) {
        if (this.binariesPath == null) {
            return executable;
        }
        return this.binariesPath + File.separator + executable;
    }

    private void execute(CommandLine commandLine, File dir) throws IOException, MojoFailureException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(dir);
        if (executor.execute(commandLine) != 0) {
            throw new MojoFailureException("Error code returned for: " + commandLine.toString());
        }
    }

    private File[] prepareLaTeXBuildDirectories(File[] docDirs) throws IOException {
        File[] buildDirs = new File[docDirs.length];
        File commonsDir = new File(this.docsRoot, this.commonsDirName);
        for (int i = 0; i < docDirs.length; ++i) {
            File target;
            File dir = docDirs[i];
            buildDirs[i] = target = new File(this.latexBuildDir, docDirs[i].getName());
            FileUtils.copyDirectory((File)dir, (File)target);
            if (commonsDir.exists()) {
                FileUtils.copyDirectory((File)commonsDir, (File)target);
            }
            Iterator iterator = FileUtils.iterateFiles((File)target, (String[])new String[]{".svn"}, (boolean)true);
            while (iterator.hasNext()) {
                FileUtils.deleteDirectory((File)((File)iterator.next()));
            }
        }
        return buildDirs;
    }

    private File[] getDocDirs() {
        return this.docsRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(LaTeXMojo.this.commonsDirName) && !pathname.isHidden();
            }
        });
    }
}

